/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ant;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class AntClassWriter
extends ClassWriter {
    private final ClassLoader myClassLoader;

    public AntClassWriter(int flags, ClassLoader classLoader) {
        super(flags);
        this.myClassLoader = classLoader;
    }

    public AntClassWriter(ClassReader classReader, int flags, ClassLoader classLoader) {
        super(classReader, flags);
        this.myClassLoader = classLoader;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        Class<?> d;
        Class<?> c;
        try {
            c = this.myClassLoader.loadClass(type1.replace('/', '.'));
            d = this.myClassLoader.loadClass(type2.replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (c.isAssignableFrom(d)) {
            return type1;
        }
        if (d.isAssignableFrom(c)) {
            return type2;
        }
        if (c.isInterface() || d.isInterface()) {
            return "java/lang/Object";
        }
        while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
        }
        return c.getName().replace('.', '/');
    }
}

