/*
 * Decompiled with CFR 0.152.
 */
package com.internetitem.reactorBuilder.maven;

import com.internetitem.reactorBuilder.FileInputter;
import com.internetitem.reactorBuilder.FileOutputter;
import com.internetitem.reactorBuilder.FilesystemModuleLister;
import com.internetitem.reactorBuilder.Inputter;
import com.internetitem.reactorBuilder.LogWrapper;
import com.internetitem.reactorBuilder.ModuleLister;
import com.internetitem.reactorBuilder.Outputter;
import com.internetitem.reactorBuilder.ReactorBuilder;
import com.internetitem.reactorBuilder.config.Configuration;
import com.internetitem.reactorBuilder.maven.MavenLogWrapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-reactor-project", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true, requiresProject=false)
public class CreateReactorProjectMojo
extends AbstractMojo {
    private static final String PROPERTY_PREFIX = "create-reactor.";
    @Parameter(property="xmlns", required=false, defaultValue="${create-reactor.xmlns}")
    private String xmlns = "http://maven.apache.org/POM/4.0.0";
    @Parameter(property="templateFile", required=false, defaultValue="${create-reactor.templateFile}")
    private String templateFile;
    @Parameter(property="groupId", required=false, defaultValue="${create-reactor.groupId}")
    private String groupId;
    @Parameter(property="artifactId", required=false, defaultValue="${create-reactor.artifactId}")
    private String artifactId;
    @Parameter(property="version", required=false, defaultValue="${create-reactor.version}")
    private String version;
    @Parameter(property="packaging", required=false, defaultValue="${create-reactor.packaging}")
    private String packaging = "pom";
    @Parameter(property="prependModules", required=false, defaultValue="${create-reactor.prependModules}")
    private String prependModules;
    @Parameter(property="appendModules", required=false, defaultValue="${create-reactor.appendModules}")
    private String appendModules;
    @Parameter(property="relativeTo", required=false, defaultValue="${create-reactor.relativeTo}")
    private String relativeTo;
    @Parameter(property="moduleSearchDirectories", required=false, defaultValue="${create-reactor.moduleSearchDirectories}")
    private String moduleSearchDirectories;
    @Parameter(property="outputFile", required=false, defaultValue="${create-reactor.outputFile}")
    private String outputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Configuration reactorConfiguration = this.buildReactorConfiguration();
        FileInputter inputter = new FileInputter();
        FileOutputter outputter = new FileOutputter();
        FilesystemModuleLister lister = new FilesystemModuleLister();
        ReactorBuilder builder = new ReactorBuilder((Inputter)inputter, (Outputter)outputter, (ModuleLister)lister);
        try {
            builder.buildReactorProject(reactorConfiguration);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate Reactor Project: " + e.getMessage(), (Exception)e);
        }
    }

    private Configuration buildReactorConfiguration() {
        Configuration config = new Configuration((LogWrapper)new MavenLogWrapper(this.getLog()));
        if (this.xmlns != null) {
            config.setXmlns(this.xmlns);
        }
        if (this.templateFile != null) {
            config.setTemplateFile(this.templateFile);
        }
        if (this.groupId != null) {
            config.setGroupId(this.groupId);
        }
        if (this.artifactId != null) {
            config.setArtifactId(this.artifactId);
        }
        if (this.version != null) {
            config.setVersion(this.version);
        }
        if (this.packaging != null) {
            config.setPackaging(this.packaging);
        }
        if (this.prependModules != null && !this.prependModules.isEmpty()) {
            List<String> prependModulesList = Arrays.asList(this.prependModules.split(":"));
            config.setPrependModules(prependModulesList);
        }
        if (this.appendModules != null && !this.appendModules.isEmpty()) {
            List<String> appendModulesList = Arrays.asList(this.appendModules.split(":"));
            config.setAppendModules(appendModulesList);
        }
        if (this.relativeTo != null) {
            config.setRelativeTo(this.relativeTo);
        }
        if (this.moduleSearchDirectories != null && !this.moduleSearchDirectories.isEmpty()) {
            List<String> moduleSearchDirectoriesList = Arrays.asList(this.moduleSearchDirectories.split(":"));
            config.setModuleSearchDirectories(moduleSearchDirectoriesList);
        }
        if (this.outputFile != null) {
            config.setOutputFile(this.outputFile);
        }
        config.summarizeConfiguration();
        return config;
    }
}

