/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.algebra;

import com.intersult.util.string.DelimiterStringBuilder;
import java.util.LinkedHashMap;
import java.util.Map;

public class Function {
    public static final Function PLUS = new Function("+", "x", "y");
    private String symbol;
    private Map<String, Function> parameters = new LinkedHashMap<String, Function>();
    private Function definition;

    public Function(String symbol, String ... parameters) {
        this.symbol = symbol;
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParameter(String name) {
        if (this.parameters.containsKey(name)) {
            throw new IllegalArgumentException("Parameter '" + name + "' already exists in function '" + this.symbol + "'");
        }
        this.parameters.put(name, null);
    }

    public void setParameter(String name, Function value) {
        if (!this.parameters.containsKey(name)) {
            throw new IllegalArgumentException("Parameter '" + name + "' does not exist in function '" + this.symbol + "'");
        }
        this.parameters.put(name, value);
    }

    public Function getDefinition() {
        return this.definition;
    }

    public void setDefinition(Function definition) {
        this.definition = definition;
    }

    public Function instance() {
        Function instance = new Function(this.symbol, new String[0]);
        instance.parameters.putAll(this.parameters);
        instance.definition = this.definition;
        return instance;
    }

    public String toString() {
        DelimiterStringBuilder buffer = new DelimiterStringBuilder();
        buffer.append(this.symbol);
        buffer.append("(");
        for (Map.Entry<String, Function> parameter : this.parameters.entrySet()) {
            buffer.append(parameter.getKey());
            if (parameter.getValue() == null) continue;
            buffer.append(" = ");
            buffer.append(parameter.getValue().toString());
        }
        buffer.clearDelimiter();
        buffer.append(")");
        return buffer.toString();
    }

    public static void main(String[] args) {
        Function function = new Function("f", new String[0]);
        function.addParameter("x");
        Function plus = PLUS.instance();
        plus.setParameter("x", null);
        function.setParameter("x", plus);
    }
}

