/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.convex;

import com.intersult.ai.convex.Criterion;
import com.intersult.ai.convex.Metric;
import com.intersult.ai.convex.Visitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConvexSet<T> {
    Metric<? super T> metric;
    Criterion criterion;
    private Vertex root = new Vertex(null);

    public ConvexSet(Metric<? super T> metric, Criterion criterion) {
        this.metric = metric;
        this.criterion = criterion;
    }

    public boolean connected(Vertex left, Vertex right) {
        return left.edges.contains(right);
    }

    public void connect(Vertex left, Vertex right) {
        if (left.equals(right)) {
            throw new IllegalArgumentException("Cannot connect knot to itself");
        }
        if (this.connected(left, right)) {
            throw new IllegalArgumentException("Knots already connected");
        }
        left.edges.add(right);
        right.edges.add(left);
    }

    public void disconnect(Vertex left, Vertex right) {
        if (!this.connected(left, right)) {
            throw new IllegalArgumentException("Knots not connected");
        }
        left.edges.remove(right);
        right.edges.remove(left);
    }

    public Metric<? super T> getMetric() {
        return this.metric;
    }

    public Criterion getCriterion() {
        return this.criterion;
    }

    public Vertex add(T value) {
        Vertex best = this.root.find(value);
        if (value.equals(best.getValue())) {
            return best;
        }
        Vertex vertex = new Vertex(value);
        this.connect(best, vertex);
        best.reorganize(this, vertex);
        return vertex;
    }

    public Vertex find(T value) {
        return this.root.find(value);
    }

    public void scan(Visitor<? super T> visitor) {
        this.root.scan(visitor);
    }

    public class Vertex {
        List<Vertex> edges = new ArrayList<Vertex>();
        private T value;

        public Vertex(T value) {
            this.value = value;
        }

        public List<Vertex> getEdges() {
            return this.edges;
        }

        public T getValue() {
            return this.value;
        }

        public void scan(Visitor<? super T> visitor) {
            this.scan(new HashSet<Vertex>(), visitor);
        }

        private void scan(Set<Vertex> visited, Visitor<? super T> visitor) {
            for (Vertex vertex : this.edges) {
                if (visited.contains(vertex)) continue;
                visited.add(vertex);
                visitor.visit(vertex);
                vertex.scan(visited, visitor);
            }
        }

        public Vertex find(T value) {
            int distance = ConvexSet.this.metric.distance(this.value, value);
            Vertex best = null;
            for (Vertex vertex : this.edges) {
                int knotDistance = vertex.distance(value);
                if (knotDistance >= distance) continue;
                best = vertex;
                distance = knotDistance;
            }
            if (best == null) {
                return this;
            }
            return best.find(value);
        }

        public void reorganize(ConvexSet<T> set, Vertex vertex) {
            for (int i = 0; i < this.getEdges().size(); ++i) {
                Vertex edge = this.getEdges().get(i);
                if (vertex == edge) continue;
                if (vertex.vertex(this, edge)) {
                    ConvexSet.this.disconnect(this, edge);
                    edge.reorganize(set, vertex);
                    --i;
                }
                if (ConvexSet.this.connected(vertex, edge) || this.vertex(vertex, edge)) continue;
                ConvexSet.this.connect(vertex, edge);
            }
        }

        public int distance(T value) {
            return ConvexSet.this.metric.distance(this.value, value);
        }

        public boolean vertex(Vertex a, Vertex b) {
            return ConvexSet.this.criterion.convex(a, b, this);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

