/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.convex;

import com.intersult.ai.convex.ConvexSet;
import com.intersult.ai.convex.Visitor;

public class Stats
implements Visitor<Object> {
    private int knots;
    private int edges;
    private int edgesSquare;
    private int edgeMin = Integer.MAX_VALUE;
    private int edgeMax;

    public int getKnots() {
        return this.knots;
    }

    public int getEdges() {
        return this.edges;
    }

    public int getEdgesSquare() {
        return this.edgesSquare;
    }

    public int getEdgeMin() {
        return this.edgeMin;
    }

    public int getEdgeMax() {
        return this.edgeMax;
    }

    @Override
    public void visit(ConvexSet.Vertex convex) {
        ++this.knots;
        this.edges += convex.getEdges().size();
        this.edgesSquare += convex.getEdges().size() * convex.getEdges().size();
        this.edgeMin = Math.min(this.edgeMin, convex.getEdges().size());
        this.edgeMax = Math.max(this.edgeMax, convex.getEdges().size());
    }

    public void print() {
        System.out.println("Knots     : " + this.knots);
        System.out.println("Edges     : " + this.edges);
        double E = (double)this.edges / (double)this.knots;
        System.out.println("E Edges   : " + E);
        double S = Math.sqrt((double)(this.edgesSquare / this.knots) - E * E);
        System.out.println("S Edges   : " + S);
        System.out.println("Min Edges : " + this.edgeMin);
        System.out.println("Max Edges : " + this.edgeMax);
    }
}

