/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.lisp;

import com.intersult.ai.lisp.Constant;
import com.intersult.ai.lisp.Integer;
import com.intersult.ai.lisp.Pair;
import com.intersult.ai.lisp.Symbol;
import com.intersult.parser.NonTerminal;
import com.intersult.parser.ParseException;
import com.intersult.parser.ParseNode;
import com.intersult.parser.Parser;
import com.intersult.parser.Parsers;
import com.intersult.parser.Scanner;
import com.intersult.parser.Terminal;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class Object {
    private static boolean debug = false;
    private static Map<String, Object> functions = new HashMap<String, Object>();
    private static Parser parser;
    public static final Object Null;
    public static final Object False;
    public static final Object Undefined;
    public static final Object True;
    public static final Object TypeObject;
    public static final Object TypeInteger;
    public static final Object TypeSymbol;
    public static final Object TypePair;

    public static Map<String, Object> functions() {
        return functions;
    }

    public static void define(String function) throws ParseException {
        Object.parse(function).define();
    }

    public Object define() {
        Symbol symbol = (Symbol)this.left();
        Object.functions().put(symbol.toString(), this);
        return this;
    }

    public Object undefine() {
        Symbol symbol = (Symbol)this.left();
        return Object.functions().remove(symbol.toString());
    }

    public Object plus() throws Exception {
        Integer left = (Integer)Object.evaluate(this.left());
        Integer right = (Integer)Object.evaluate(this.right().left());
        return new Integer(left.value().add(right.value()));
    }

    public Object negate() throws Exception {
        Integer left = (Integer)Object.evaluate(this.left());
        return new Integer(left.value().negate());
    }

    public Object subtract() throws Exception {
        Integer left = (Integer)Object.evaluate(this.left());
        Integer right = (Integer)Object.evaluate(this.right().left());
        return new Integer(left.value().subtract(right.value()));
    }

    public Object multiply() throws Exception {
        Integer left = (Integer)Object.evaluate(this.left());
        Integer right = (Integer)Object.evaluate(this.right().left());
        return new Integer(left.value().multiply(right.value()));
    }

    public Object divide() throws Exception {
        Integer left = (Integer)Object.evaluate(this.left());
        Integer right = (Integer)Object.evaluate(this.right().left());
        return new Integer(left.value().divide(right.value()));
    }

    public Object gcd() throws Exception {
        Integer left = (Integer)Object.evaluate(this.left());
        Integer right = (Integer)Object.evaluate(this.right().left());
        return new Integer(left.value().gcd(right.value()));
    }

    public Object min() throws Exception {
        Integer left = (Integer)Object.evaluate(this.left());
        Integer right = (Integer)Object.evaluate(this.right().left());
        return new Integer(left.value().min(right.value()));
    }

    public Object max() throws Exception {
        Integer left = (Integer)Object.evaluate(this.left());
        Integer right = (Integer)Object.evaluate(this.right().left());
        return new Integer(left.value().max(right.value()));
    }

    public Object mod() throws Exception {
        Integer left = (Integer)Object.evaluate(this.left());
        Integer right = (Integer)Object.evaluate(this.right().left());
        return new Integer(left.value().mod(right.value()));
    }

    public Object pow() throws Exception {
        Integer left = (Integer)Object.evaluate(this.left());
        Integer right = (Integer)Object.evaluate(this.right().left());
        return new Integer(left.value().pow(right.value().intValue()));
    }

    public Object equals() throws Exception {
        Object left = Object.evaluate(this.left());
        Object right = Object.evaluate(this.right().left());
        if (left instanceof Pair) {
            return False;
        }
        return left.equals(right) ? True : False;
    }

    public Object less() throws Exception {
        Integer left = (Integer)Object.evaluate(this.left());
        Integer right = (Integer)Object.evaluate(this.right().left());
        return left.value().compareTo(right.value()) < 0 ? True : False;
    }

    public Object more() throws Exception {
        Integer left = (Integer)Object.evaluate(this.left());
        Integer right = (Integer)Object.evaluate(this.right().left());
        return left.value().compareTo(right.value()) > 0 ? True : False;
    }

    public Object merge() throws Exception {
        Symbol left = (Symbol)Object.evaluate(this.left());
        Symbol right = (Symbol)Object.evaluate(this.right().left());
        return new Symbol(left.toString() + right.toString());
    }

    public Object cons() throws Exception {
        Object left = Object.evaluate(this.left());
        Object right = Object.evaluate(this.right().left());
        return new Pair(left, right);
    }

    public Object integer() throws Exception {
        return Object.evaluate(this.left()) instanceof Integer ? True : False;
    }

    public Object symbol() throws Exception {
        return Object.evaluate(this.left()) instanceof Symbol ? True : False;
    }

    public Object pair() throws Exception {
        return Object.evaluate(this.left()) instanceof Pair ? True : False;
    }

    public Object type() throws Exception {
        String name = Object.evaluate(this.left()).getClass().getName().toLowerCase();
        int dot = name.lastIndexOf(46);
        return new Symbol(dot < 0 ? name : name.substring(dot + 1));
    }

    public Object quote() {
        return this.left();
    }

    public Object left() {
        return Null;
    }

    public Object right() {
        return Null;
    }

    public Object car() throws Exception {
        return Object.evaluate(Object.evaluate(this.left()).left());
    }

    public Object caar() throws Exception {
        return Object.evaluate(this.car().left());
    }

    public Object cdar() throws Exception {
        return this.car().right();
    }

    public Object cadar() throws Exception {
        return Object.evaluate(this.car().right().left());
    }

    public Object cdr() throws Exception {
        return Object.evaluate(this.left()).right();
    }

    public Object cadr() throws Exception {
        return Object.evaluate(this.cdr().left());
    }

    public Object caadr() throws Exception {
        return Object.evaluate(this.cadr().left());
    }

    public Object cdadr() throws Exception {
        return this.cadr().right();
    }

    public Object cadadr() throws Exception {
        return Object.evaluate(this.cadr().right().left());
    }

    public Object cddr() throws Exception {
        return this.cdr().right();
    }

    public Object caddr() throws Exception {
        return Object.evaluate(this.cddr().left());
    }

    public Object caaar() throws Exception {
        return Object.evaluate(this.caar().left());
    }

    public Object test() throws Exception {
        Object condition = Object.evaluate(this.left());
        if (condition.equals(True)) {
            return Object.evaluate(this.right().left());
        }
        if (condition.equals(False)) {
            return Object.evaluate(this.right().right().left());
        }
        return this;
    }

    public Object debug() throws Exception {
        Object value = Object.evaluate(this.left());
        if (!value.equals(Null)) {
            debug = value.equals(True);
        }
        return debug ? True : False;
    }

    public Object evaluate() throws Exception {
        return Object.evaluate(this.left());
    }

    public static Object evaluate(String string) throws Exception {
        return Object.evaluate(Object.parse(string));
    }

    public static Object evaluate(Object object) throws Exception {
        Object result = object;
        if (object instanceof Pair) {
            Object operator = Object.evaluate(Object.substitute(object.left()));
            if (operator instanceof Symbol) {
                Object customMethod = Object.functions().get(operator.toString());
                if (customMethod != null) {
                    Object attribute = customMethod.right().left();
                    Object value = Object.evaluate(object.right());
                    Object term = customMethod.right().right().left();
                    Object temp = Object.let(attribute, value, term);
                    result = Object.evaluate(Object.evaluate(temp));
                    if (debug) {
                        System.out.println("(" + operator + " " + temp + ") -> " + result);
                    }
                } else {
                    Method javaMethod = null;
                    try {
                        javaMethod = Object.class.getMethod(operator.toString(), null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    result = javaMethod != null ? (Object)javaMethod.invoke((java.lang.Object)object.right(), new java.lang.Object[0]) : new Pair(operator, object.right());
                    if (debug) {
                        System.out.println(object + " -> " + result);
                    }
                }
            }
        } else if (object instanceof Symbol) {
            result = Object.substitute(object);
        }
        return result;
    }

    public static Object substitute(Object object) {
        return object;
    }

    public Object let() throws Exception {
        return Object.evaluate(Object.let(this.left(), this.right().left(), this.right().right().left()));
    }

    public static Object let(Object attribute, Object value, Object term) throws Exception {
        if (attribute.constant() && !attribute.equals(value)) {
            return Null;
        }
        if (debug) {
            System.out.println(term + " [" + attribute + " -> " + value + "]");
        }
        Object result = Object.let((Symbol)attribute, value, term);
        if (debug) {
            System.out.println(" = " + result);
        }
        return result;
    }

    private static Object let(Symbol attribute, Object value, Object term) throws Exception {
        if (term instanceof Symbol) {
            return attribute.equals(term) ? value : term;
        }
        if (term instanceof Pair) {
            return new Pair(Object.let(attribute, value, term.left()), Object.let(attribute, value, term.right()));
        }
        return term;
    }

    private static Parser parser() {
        if (parser == null) {
            try {
                Parsers parsers = Parsers.getGlobal().clone();
                parsers.create("list := '(' + object #0 space + ')'");
                parser = parsers.create("expression := object + eof; object := list | symbol | integer");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return parser;
    }

    public static Object parse(String string) throws ParseException {
        return Object.parse(new Scanner(string));
    }

    public static Object parse(Scanner scanner) throws ParseException {
        ParseNode node = Object.parser().parse(scanner);
        if (node == null) {
            throw new ParseException(scanner.error());
        }
        return Object.parse(node);
    }

    public static Object parse(ParseNode node) {
        String name = node.parser().name();
        if (name.equals("expression") || name.equals("list-content") || name.equals("object")) {
            return Object.parse(((NonTerminal)node).get(0));
        }
        if (name.equals("list")) {
            return Object.parseList((NonTerminal)node);
        }
        if (name.equals("symbol")) {
            return Object.parseSymbol((Terminal)node);
        }
        if (name.equals("integer")) {
            return Object.parseInteger((Terminal)node);
        }
        return new Symbol(name);
    }

    public static Object parseList(NonTerminal node) {
        return Object.parseListContent((NonTerminal)node.get(1), 0);
    }

    public static Object parseListContent(NonTerminal node, int index) {
        if (index >= node.count()) {
            return Null;
        }
        return new Pair(Object.parse(node.get(index)), Object.parseListContent(node, index + 2));
    }

    public static Object parseSymbol(Terminal node) {
        return new Symbol(node.value());
    }

    public static Object parseInteger(Terminal node) {
        return new Integer(node.value());
    }

    public abstract boolean constant();

    public static void main(String[] args) throws Exception {
        Scanner scanner = new Scanner();
        while (scanner.readLine(System.in)) {
            try {
                Object f = Object.parse(scanner);
                System.out.println(Object.evaluate(f));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static {
        Null = new Constant("null");
        False = new Constant("false");
        Undefined = new Constant("undefined");
        True = new Constant("true");
        TypeObject = new Constant("object");
        TypeInteger = new Constant("integer");
        TypeSymbol = new Constant("symbol");
        TypePair = new Constant("pair");
        try {
            Object.define("(if x (cons test x))");
            Object.define("(less-or-equal x (not (more (car x) (cadr x))))");
            Object.define("(more-or-equal x (not (less (car x) (cadr x))))");
            Object.define("(not x (test (car x) false true))");
            Object.define("(factorial n (test (equals (car n) 0) 1 (multiply (car n) (factorial (subtract (car n) 1)))))");
            Object.define("(structure-equals x (test (pair (car x)) (and (structure-equals (caar x) (caadr x)) (structure-equals (cadar x) (cadadr x))) (equals (car x) (cadr x))))");
            Object.define("(and x (test (car x) (cadr x) false))");
            Object.define("(or x (test (car x) true (cadr x)))");
            Object.define("(exor x (test (car x) (not (cadr x)) (cadr x)))");
            Object.define("(fibh x (test (equals (car x) 1) (cadr x) (test (equals (car x) 2) (caddr x) (fibh (subtract (car x) 1) (caddr x) (plus (cadr x) (caddr x))))))");
            Object.define("(fib x (fibh (car x) 1 1))");
            Object.define("(structure-compare x (test (pair (car x)) (and (structure-compare (caar x) (caadr x)) (structure-compare (cadar x) (cadadr x))) ((caddr x) (car x) (cadr x))))");
            Object.define("(join x (test (equals (cdar x) null) (cons (caar x) (cadr x)) (cons (caar x) (join (cdar x) (cadr x)))))");
            Object.define("(binomial x (test (or (equals (cadr x) 0) (equals (cadr x) (car x))) 1 (plus (binomial (subtract (car x) 1) (subtract (cadr x) 1)) (binomial (subtract (car x) 1) (cadr x)))))");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

