/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.molecule;

import java.util.List;
import org.apache.commons.collections.map.LinkedMap;

public class Container<KeyType, ElementType extends Element<KeyType>> {
    private LinkedMap map = new LinkedMap();
    private List<ElementType> list;
    private int capacity;

    public Container(int capacity) {
        this.capacity = capacity;
    }

    public void add(ElementType element) {
        int index = this.getIndex(element.getMass());
        this.list.add(index, element);
        if (this.list.size() > this.capacity) {
            ((Element)this.list.remove(this.list.size() - 1)).removed();
        }
    }

    protected void requeue() {
    }

    private int getIndex(double mass) {
        int low = 0;
        int high = this.list.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Element midVal = (Element)this.list.get(mid);
            int cmp = Double.compare(mass, midVal.getMass());
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    public int size() {
        return this.list.size();
    }

    public static interface Element<KeyType> {
        public KeyType getKey();

        public double getMass();

        public void removed();
    }
}

