/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.molecule;

import com.intersult.ai.molecule.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Molecules {
    private Container<Molecule, Container.Element<Molecule>> container = new Container(1000);
    Map<String, Molecule> molecules = new HashMap<String, Molecule>();
    private List<Molecule> reactor = new ArrayList<Molecule>();

    private void add(Molecule molecule) {
        this.container.add(molecule);
        this.molecules.put(molecule.getSymbol(), molecule);
    }

    private Molecule get(String key) {
        Molecule molecule = this.molecules.get(key);
        if (molecule == null) {
            molecule = new Molecule(key);
            this.add(molecule);
        }
        molecule.increase();
        return molecule;
    }

    public void induce(String text) {
        for (char c : text.toCharArray()) {
            Molecule molecule = this.get(Character.toString(c));
            this.induce(molecule);
        }
    }

    private void induce(Molecule molecule) {
    }

    public class Molecule
    implements Container.Element {
        private int count;
        private String symbol;
        private String left;
        private String right;

        Molecule(String symbol) {
            this.symbol = symbol;
        }

        @Override
        public double getMass() {
            return this.count * this.symbol.length();
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getLeft() {
            return this.left;
        }

        public String getRight() {
            return this.right;
        }

        public void increase() {
            ++this.count;
        }

        @Override
        public void removed() {
            Molecules.this.molecules.remove(this.symbol);
        }

        public int hashCode() {
            return this.symbol.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Molecule other = (Molecule)obj;
            return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
        }

        public String toString() {
            return this.symbol + "(" + this.getMass() + ")";
        }

        public Object getKey() {
            return null;
        }
    }
}

