/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.pool;

import com.intersult.ai.pool.Element;
import com.intersult.ai.pool.Pair;
import com.intersult.ai.pool.Symbol;
import com.intersult.parser.NonTerminal;
import com.intersult.parser.ParseException;
import com.intersult.parser.ParseNode;
import com.intersult.parser.Parsers;
import com.intersult.parser.Terminal;

public class Compiler {
    private static Parsers parsers = new Parsers();

    public static Element compile(String input) {
        try {
            NonTerminal node = (NonTerminal)parsers.parse("input", input);
            return Compiler.compileExpression((NonTerminal)node.get(0));
        }
        catch (ParseException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    private static Element compileExpression(NonTerminal expression) {
        ParseNode node = expression.get(0);
        if ("symbol".equals(node.parser().name())) {
            return Compiler.compileSymbol((Terminal)node);
        }
        if ("pair".equals(node.parser().name())) {
            return Compiler.compilePair((NonTerminal)node);
        }
        if ("brace-pair".equals(node.parser().name())) {
            return Compiler.compileBracePair((NonTerminal)node);
        }
        throw new IllegalStateException("Illegal expression type '" + node.parser().name() + "'");
    }

    private static Element compileBracePair(NonTerminal bracePair) {
        NonTerminal node = (NonTerminal)bracePair.get(1);
        return Compiler.compilePair(node);
    }

    private static Element compileSymbol(Terminal symbol) {
        return new Symbol(symbol.value());
    }

    private static Element compilePair(NonTerminal pair) {
        NonTerminal left = (NonTerminal)pair.get(0);
        NonTerminal right = (NonTerminal)pair.get(2);
        return new Pair(Compiler.compileExpression(left), Compiler.compileExpression(right));
    }

    static {
        try {
            parsers.create("input := brace-expression + eof");
            parsers.create("brace-expression := brace-pair | symbol");
            parsers.create("expression := pair | symbol");
            parsers.create("brace-pair := '(' + pair + ')'");
            parsers.create("pair := brace-expression + ' ' + expression");
        }
        catch (ParseException exception) {
            throw new IllegalStateException(exception);
        }
    }
}

