/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.pool;

import com.intersult.ai.pool.Compiler;
import com.intersult.ai.pool.Pair;

public abstract class Element {
    public static final Element FALSE = Compiler.compile(Boolean.FALSE.toString());
    public static final Element TRUE = Compiler.compile(Boolean.TRUE.toString());

    public static Element get(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static Element get(Element ... elements) {
        return Element.get(0, elements);
    }

    private static Element get(int index, Element[] elements) {
        int next = index + 1;
        if (next == elements.length) {
            return elements[index];
        }
        return new Pair(elements[index], Element.get(next, elements));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, true);
        return buffer.toString();
    }

    protected abstract void toString(StringBuilder var1, boolean var2);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public boolean toBoolean() {
        return TRUE.equals(this);
    }
}

