/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.pool;

import com.intersult.ai.pool.Element;
import com.intersult.ai.pool.EvaluationException;
import com.intersult.ai.pool.Operator;
import com.intersult.ai.pool.Pair;
import com.intersult.ai.pool.Symbol;
import com.intersult.ai.pool.eval.Identity;
import com.intersult.ai.pool.load.JavaLoader;
import com.intersult.ai.pool.load.Loader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Executor {
    public static Map<String, Operator> operatorMap = new HashMap<String, Operator>();
    public static List<Loader> loaders;

    public static Element evaluate(Element element) {
        if (element instanceof Pair) {
            Pair pair = (Pair)element;
            Element left = Executor.evaluate(pair.getLeft());
            if (left instanceof Pair) {
                return element;
            }
            Element result = Executor.evaluate((Symbol)left, pair.getRight());
            return result;
        }
        return element;
    }

    public static List<Loader> getLoaders() {
        if (loaders == null) {
            loaders = new ArrayList<Loader>();
            loaders.add(new JavaLoader(Identity.class.getPackage().getName()));
        }
        return loaders;
    }

    private static Element evaluate(Symbol operatorSymbol, Element element) {
        Operator operator = Executor.getOperator(operatorSymbol);
        if (operator == null) {
            throw new EvaluationException("No operator '" + operatorSymbol.getName() + "' defined in loaders");
        }
        Element result = operator.apply(element);
        return result;
    }

    private static Operator getOperator(Symbol symbol) {
        Operator operator = operatorMap.get(symbol.getName());
        if (operator == null) {
            operator = Executor.loadOperator(symbol);
            operatorMap.put(symbol.getName(), operator);
        }
        return operator;
    }

    private static Operator loadOperator(Symbol symbol) {
        for (Loader loader : Executor.getLoaders()) {
            Operator operator = loader.load(symbol);
            if (operator == null) continue;
            return operator;
        }
        return null;
    }
}

