/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.pool.eval;

import com.intersult.ai.pool.Element;
import com.intersult.ai.pool.EvaluationException;
import com.intersult.ai.pool.Operator;
import com.intersult.ai.pool.Pair;
import com.intersult.ai.pool.Symbol;
import com.intersult.ai.pool.eval.Bind;

public class Apply
implements Operator {
    @Override
    public Element apply(Element element) {
        Pair pair = (Pair)element;
        Element actualParameter = pair.getLeft();
        Element formalParameter = ((Pair)pair.getRight()).getLeft();
        try {
            return this.apply(formalParameter, actualParameter, ((Pair)pair.getRight()).getRight());
        }
        catch (Exception exception) {
            throw new EvaluationException("Error applying parameters '" + actualParameter + "' to '" + formalParameter + "'", exception);
        }
    }

    private Element apply(Element formalParameter, Element actualParameter, Element element) throws EvaluationException {
        if (formalParameter instanceof Pair) {
            if (!(actualParameter instanceof Pair)) {
                throw new EvaluationException("Too view parameters");
            }
            Element result = this.apply(((Pair)formalParameter).getLeft(), ((Pair)actualParameter).getLeft(), element);
            return this.apply(((Pair)formalParameter).getRight(), ((Pair)actualParameter).getRight(), result);
        }
        return Bind.bind((Symbol)formalParameter, actualParameter, element);
    }
}

