/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.pool.load;

import com.intersult.ai.pool.Operator;
import com.intersult.ai.pool.Symbol;
import com.intersult.ai.pool.load.Loader;

public class JavaLoader
implements Loader {
    private String packageName;

    public JavaLoader(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public Operator load(Symbol symbol) {
        String typeName = JavaLoader.getTypeName(symbol.getName());
        Class<? extends Operator> operatorType = this.getOperatorType(typeName);
        if (operatorType == null) {
            return null;
        }
        try {
            return operatorType.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot instantiate operator '" + symbol + "'", exception);
        }
    }

    public static String getTypeName(String symbolName) {
        StringBuilder buffer = new StringBuilder();
        int last = 0;
        int index = 0;
        while (index > 0) {
            JavaLoader.appendTypeNamePart(buffer, symbolName, last, index);
            last = index;
            index = symbolName.indexOf(46, last);
        }
        JavaLoader.appendTypeNamePart(buffer, symbolName, last, symbolName.length());
        return buffer.toString();
    }

    private static void appendTypeNamePart(StringBuilder buffer, String symbolName, int start, int end) {
        buffer.append(Character.toUpperCase(symbolName.charAt(start)));
        buffer.append(symbolName, start + 1, end);
    }

    private Class<? extends Operator> getOperatorType(String typeName) {
        try {
            return Class.forName(this.packageName + "." + typeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

