/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.prolog;

import com.intersult.ai.prolog.ChoicePoint;
import com.intersult.ai.prolog.Operation;
import com.intersult.ai.prolog.PrologParser;
import com.intersult.ai.prolog.Term;
import com.intersult.ai.prolog.TermList;
import com.intersult.ai.prolog.buildin.Call;
import com.intersult.ai.prolog.buildin.Nl;
import com.intersult.ai.prolog.buildin.OnceEnter;
import com.intersult.ai.prolog.buildin.OnceLeave;
import com.intersult.ai.prolog.buildin.Print;
import com.intersult.parser.ParseException;
import com.intersult.util.io.IOUtils;
import com.intersult.util.math.Random;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Prolog {
    public boolean trace;
    private Map<String, List<TermList>> db = new LinkedHashMap<String, List<TermList>>();

    public Prolog() {
        try {
            this.consultProgram(this.getClass().getResourceAsStream("/core.pl"));
            this.consult(new TermList(new Call()));
            this.consult(new TermList(new Print()));
            this.consult(new TermList(new Nl()));
            this.consult(new TermList(new OnceEnter()));
            this.consult(new TermList(new OnceLeave()));
        }
        catch (IOException exception) {
            throw new IllegalArgumentException("Cannot reading program", exception);
        }
        catch (ParseException exception) {
            throw new IllegalArgumentException("Error parsing program", exception);
        }
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public Term run(String term) throws ParseException {
        Term parsedTerm = PrologParser.parseTerm(term);
        return this.run(parsedTerm);
    }

    public Term run(Term term) {
        Stack<Operation> stack = new Stack<Operation>();
        TermList goal = new TermList(term);
        int clauseNumber = 0;
        while (goal != null) {
            ChoicePoint choicePoint;
            if (goal.getTerm() == null) {
                throw new IllegalArgumentException("No goal");
            }
            List<TermList> definer = goal.getDefiner(this.db);
            if (definer == null) {
                throw new IllegalArgumentException("Goal '" + goal.getTerm().toString() + "' undefined");
            }
            if (clauseNumber + 1 < definer.size()) {
                stack.push(new ChoicePoint(clauseNumber + 1, goal));
            }
            TermList clause = definer.get(clauseNumber);
            if (this.trace) {
                System.out.print(stack.size() + ": " + goal.getTerm() + " auf " + clause);
            }
            clauseNumber = 0;
            ArrayList<Term> variables = new ArrayList<Term>();
            Term instance = clause.getTerm().instantiate(variables);
            if (Term.unify(stack, instance, goal.getTerm())) {
                if (this.trace) {
                    System.out.println(" -> true");
                }
                instance.invoke(stack, goal);
                goal.instantiate(variables, clause);
                goal = goal.getNext();
                continue;
            }
            if (this.trace) {
                System.out.println(" -> fail");
            }
            if ((choicePoint = Prolog.backtrack(stack)) == null) {
                return Term.FAIL;
            }
            goal = choicePoint.goal;
            goal.clear();
            clauseNumber = choicePoint.clauseNumber;
        }
        return term;
    }

    public Term prove(Term prove) {
        Stack<Operation> stack = new Stack<Operation>();
        List<TermList> equals = this.db.get("equals/2");
        Term term = Term.TRUE;
        for (int i = 0; i < 1000; ++i) {
            TermList clause = equals.get(Random.RANDOM.nextInt(equals.size()));
            ArrayList<Term> variables = new ArrayList<Term>();
            Term goal = new Term("equals");
            Term instance = term.instantiate(new ArrayList<Term>());
            goal.add(instance);
            goal.add(new Term("Result"));
            if (!Term.unify(stack, goal, clause.getTerm().instantiate(variables))) continue;
            if (this.trace) {
                System.out.println(term + " auf " + clause.getTerm() + " -> true");
            }
            term = goal.get(1);
        }
        return term;
    }

    public static ChoicePoint backtrack(Stack<Operation> stack) {
        while (!stack.isEmpty()) {
            Operation operation = stack.pop();
            if (operation instanceof Term) {
                Term term = (Term)operation;
                term.unbind();
                continue;
            }
            if (!(operation instanceof ChoicePoint)) continue;
            return (ChoicePoint)operation;
        }
        return null;
    }

    public void consultProgram(InputStream inputStream) throws IOException, ParseException {
        String string = IOUtils.readString((InputStream)inputStream);
        this.consultProgram(string);
    }

    public void consultProgram(String string) throws ParseException {
        List<TermList> program = PrologParser.parseProgram(string);
        this.consult(program);
    }

    public void consult(String string) throws ParseException {
        TermList termList = PrologParser.parseTermList(string);
        this.consult(termList);
    }

    public void consult(List<TermList> program) {
        for (TermList termList : program) {
            this.consult(termList);
        }
    }

    public void consult(TermList termList) {
        String key = termList.getTerm().getKey();
        List<TermList> clauseList = this.db.get(key);
        if (clauseList == null) {
            clauseList = new ArrayList<TermList>();
            this.db.put(key, clauseList);
        }
        clauseList.add(termList);
    }
}

