/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.prolog;

import com.intersult.ai.prolog.Term;
import com.intersult.ai.prolog.TermList;
import com.intersult.parser.NonTerminal;
import com.intersult.parser.ParseException;
import com.intersult.parser.Parsers;
import com.intersult.parser.SymbolParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrologParser {
    private static Parsers parsers;

    public static Parsers getParsers() throws ParseException {
        if (parsers == null) {
            parsers = Parsers.getGlobal().clone();
            new SymbolParser(parsers, "functor-symbol", "_abcdefghijklmnopqrstuvwxyz1234567890");
            parsers.create("functor := white-space + functor-symbol");
            parsers.create("variable := white-space + upper-symbol");
            parsers.create("list-operator := white-space + ','");
            parsers.create("tail-operator := white-space + '|'");
            parsers.create("end-operator := white-space + '.'");
            parsers.create("if-operator := white-space + ':-'");
            parsers.create("list-elements := argument #0 list-operator");
            parsers.create("list-tail := tail-operator + argument");
            parsers.create("list := white-space + '[' + list-elements + list-tail? + white-space + ']'");
            parsers.create("argument := term | variable | list");
            parsers.create("argument-list := argument #1 list-operator");
            parsers.create("arguments := white-space + '(' + argument-list + white-space + ')'");
            parsers.create("term := functor + arguments?");
            parsers.create("definer := term #1 list-operator");
            parsers.create("definition := if-operator + definer");
            parsers.create("termlist := term + definition? + end-operator");
            parsers.create("program := termlist!");
            parsers.create("term-input := term + white-space + eof");
            parsers.create("termlist-input := termlist + white-space + eof");
            parsers.create("program-input := program + white-space + eof");
        }
        return parsers;
    }

    public static Term parseTerm(String string) throws ParseException {
        NonTerminal node = (NonTerminal)PrologParser.getParsers().parse("term-input", string);
        HashMap<String, Term> variables = new HashMap<String, Term>();
        return PrologParser.compileTerm((NonTerminal)node.get(0), variables);
    }

    public static TermList parseTermList(String string) throws ParseException {
        NonTerminal node = (NonTerminal)PrologParser.getParsers().parse("termlist-input", string);
        return PrologParser.compileTermList((NonTerminal)node.get(0));
    }

    public static List<TermList> parseProgram(String string) throws ParseException {
        NonTerminal node = (NonTerminal)PrologParser.getParsers().parse("program-input", string);
        return PrologParser.compileProgram((NonTerminal)node.get(0));
    }

    private static List<TermList> compileProgram(NonTerminal node) {
        ArrayList<TermList> program = new ArrayList<TermList>();
        for (int i = 0; i < node.count(); ++i) {
            TermList termList = PrologParser.compileTermList((NonTerminal)node.get(i));
            program.add(termList);
        }
        return program;
    }

    private static TermList compileTermList(NonTerminal node) {
        HashMap<String, Term> variables = new HashMap<String, Term>();
        Term term = PrologParser.compileTerm((NonTerminal)node.get(0), variables);
        TermList termList = new TermList(term);
        PrologParser.compileParameters((NonTerminal)node.get(1), termList, variables);
        return termList;
    }

    public static void compileParameters(NonTerminal node, TermList termList, Map<String, Term> variables) {
        String name = node.parser().name();
        if ("definer".equals(name)) {
            PrologParser.compileDefinition(node, termList, variables);
        } else if ("definition".equals(name)) {
            PrologParser.compileParameters((NonTerminal)node.get(1), termList, variables);
        } else if (node.count() > 0) {
            PrologParser.compileParameters((NonTerminal)node.get(0), termList, variables);
        }
    }

    private static void compileDefinition(NonTerminal node, TermList termList, Map<String, Term> variables) {
        for (int i = 0; i < node.count(); i += 2) {
            Term term = PrologParser.compileTerm((NonTerminal)node.get(i), variables);
            termList = termList.insert(new TermList(term));
        }
    }

    private static Term compileTerm(NonTerminal node, Map<String, Term> variables) {
        String functor = PrologParser.compileFunctor((NonTerminal)node.get(0));
        Term term = new Term(functor);
        NonTerminal parameters = (NonTerminal)node.get(1);
        if (parameters.count() > 0) {
            PrologParser.compileParameters(parameters, term, variables);
        }
        return term;
    }

    private static String compileFunctor(NonTerminal node) {
        return node.get(1).value();
    }

    private static void compileParameters(NonTerminal node, Term term, Map<String, Term> variables) {
        String name = node.parser().name();
        if ("arguments".equals(name)) {
            PrologParser.compileParameters((NonTerminal)node.get(2), term, variables);
        } else if ("argument-list".equals(name)) {
            PrologParser.compileArgumentList(node, term, variables);
        } else {
            PrologParser.compileParameters((NonTerminal)node.get(0), term, variables);
        }
    }

    private static void compileArgumentList(NonTerminal node, Term term, Map<String, Term> variables) {
        for (int i = 0; i < node.count(); i += 2) {
            Term argument = PrologParser.compileArgument((NonTerminal)node.get(i), variables);
            term.add(argument);
        }
    }

    private static Term compileArgument(NonTerminal node, Map<String, Term> variables) {
        String name = node.parser().name();
        if ("term".equals(name)) {
            return PrologParser.compileTerm(node, variables);
        }
        if ("variable".equals(name)) {
            return PrologParser.compileVariable(node, variables);
        }
        if ("list".equals(name)) {
            return PrologParser.compileList(node, variables);
        }
        return PrologParser.compileArgument((NonTerminal)node.get(0), variables);
    }

    private static Term compileVariable(NonTerminal node, Map<String, Term> variables) {
        String functor = node.get(1).value();
        Term variable = variables.get(functor);
        if (variable == null) {
            variable = new Term(variables.size());
            variables.put(functor, variable);
        }
        return variable;
    }

    private static Term compileList(NonTerminal node, Map<String, Term> variables) {
        NonTerminal listNode = (NonTerminal)node.get(2);
        Term head = null;
        Term term = null;
        for (int i = 0; i < listNode.count(); i += 2) {
            Term cons = new Term("cons");
            cons.add(PrologParser.compileArgument((NonTerminal)listNode.get(i), variables));
            if (head == null) {
                head = term = cons;
                continue;
            }
            term.add(cons);
            term = cons;
        }
        Term tail = PrologParser.compileTail((NonTerminal)node.get(3), variables);
        if (head == null) {
            return tail;
        }
        term.add(tail);
        return head;
    }

    private static Term compileTail(NonTerminal node, Map<String, Term> variables) {
        if (node.count() == 0) {
            return new Term("null");
        }
        String name = node.parser().name();
        if ("list-tail".equals(name)) {
            return PrologParser.compileArgument((NonTerminal)node.get(1), variables);
        }
        return PrologParser.compileTail((NonTerminal)node.get(0), variables);
    }
}

