/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.prolog;

import com.intersult.ai.prolog.Operation;
import com.intersult.ai.prolog.TermList;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Term
implements Operation {
    public static final Term FAIL = new Term("fail");
    public static final Term TRUE = new Term("true");
    private List<Term> arguments;
    private String functor;
    private boolean bound;
    private Term reference;
    private int index;
    private String key;

    public Term(int index) {
        this.index = index;
        this.bound = false;
    }

    public Term(String functor) {
        this.functor = functor;
        if (!Character.isUpperCase(functor.charAt(0))) {
            this.bound = true;
        }
        this.arguments = new ArrayList<Term>();
    }

    public Term dereference() {
        Term term = this;
        while (term.bound && term.reference != null) {
            term = term.reference;
        }
        return term;
    }

    public String getFunctor() {
        return this.dereference().functor;
    }

    public String getKey() {
        return this.dereference().getKeyCached();
    }

    private String getKeyCached() {
        if (this.key == null) {
            this.key = this.functor == null ? "" : this.functor + "/" + this.arguments.size();
        }
        return this.key;
    }

    public Term get(int index) {
        Term dereference = this.dereference();
        return dereference.bound ? dereference.arguments.get(index) : null;
    }

    public void add(Term term) {
        this.arguments.add(term);
    }

    public static boolean unify(Stack<Operation> stack, Term left, Term right) {
        left = left.dereference();
        right = right.dereference();
        if (!left.bound) {
            left.bind(stack, right);
        } else if (!right.bound) {
            right.bind(stack, left);
        } else {
            if (!left.getKey().equals(right.getKey())) {
                return false;
            }
            for (int i = 0; i < left.arguments.size(); ++i) {
                if (Term.unify(stack, left.arguments.get(i), right.arguments.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public void bind(Stack<Operation> stack, Term term) {
        if (this == term) {
            return;
        }
        if (this.bound) {
            throw new IllegalArgumentException("Term.bind(" + this + "): Can't bind nonvar");
        }
        this.bound = true;
        this.reference = term;
        stack.push(this);
    }

    public void unbind() {
        if (this.reference != null) {
            this.bound = false;
            this.reference = null;
        }
    }

    public Term instantiate(List<Term> variables) {
        if (this.bound) {
            if (this.reference != null) {
                return this.reference.instantiate(variables);
            }
            Term term = new Term(this.functor);
            for (int i = 0; i < this.arguments.size(); ++i) {
                term.arguments.add(this.arguments.get(i).instantiate(variables));
            }
            return term;
        }
        return Term.getVariable(variables, this.index);
    }

    private static Term getVariable(List<Term> variables, int index) {
        Term variable;
        if (variables == null) {
            variable = new Term(index);
        } else if (index < variables.size()) {
            variable = variables.get(index);
        } else {
            variable = new Term(variables.size());
            variables.add(variable);
        }
        return variable;
    }

    public void invoke(Stack<Operation> stack, TermList goal) {
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        if (this.bound) {
            if (this.reference != null) {
                this.reference.toString(buffer);
            } else if (this.getKey().equals("null/0")) {
                buffer.append("[]");
            } else if (this.getKey().equals("cons/2")) {
                Term term = this;
                buffer.append("[");
                while (true) {
                    term.get(0).toString(buffer);
                    term = term.get(1);
                    if (!term.getKey().equals("cons/2")) break;
                    buffer.append(", ");
                }
                if (term.getKey().equals("null/0")) {
                    buffer.append("]");
                } else {
                    buffer.append(" | ");
                    buffer.append(term);
                    buffer.append("]");
                }
            } else {
                buffer.append(this.functor);
                if (!this.arguments.isEmpty()) {
                    buffer.append("(");
                    for (int i = 0; i < this.arguments.size(); ++i) {
                        if (i > 0) {
                            buffer.append(", ");
                        }
                        this.arguments.get(i).toString(buffer);
                    }
                    buffer.append(")");
                }
            }
        } else {
            buffer.append("_");
            buffer.append(this.index);
        }
    }
}

