/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.prolog;

import com.intersult.ai.prolog.Term;
import java.util.List;
import java.util.Map;

public class TermList {
    private TermList next;
    private Term term;
    private List<TermList> definer;

    public TermList(Term term) {
        this.term = term;
    }

    public List<TermList> getDefiner(Map<String, List<TermList>> db) {
        if (this.definer == null) {
            this.definer = db.get(this.term.getKey());
        }
        return this.definer;
    }

    public TermList getNext() {
        return this.next;
    }

    public Term getTerm() {
        return this.term;
    }

    public TermList insert(TermList termList) {
        termList.next = this.next;
        this.next = termList;
        return termList;
    }

    public void remove() {
        this.next = this.next.next;
    }

    public void clear() {
        this.next = null;
    }

    public void instantiate(List<Term> variables, TermList termList) {
        TermList result = this;
        for (termList = termList.getNext(); termList != null; termList = termList.getNext()) {
            result = result.insert(termList.instantiate(variables));
        }
    }

    public TermList instantiate(List<Term> variables) {
        TermList termList = new TermList(this.term.instantiate(variables));
        termList.definer = this.definer;
        return termList;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer(this.term.toString());
        if (this.next != null) {
            buffer.append(" :- ");
        }
        TermList node = this.next;
        while (node != null) {
            buffer.append(node.term);
            if (node.next != null) {
                buffer.append(", ");
            }
            node = node.next;
        }
        buffer.append(".");
        return buffer.toString();
    }
}

