/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.semantic;

import com.intersult.ai.semantic.Semantics;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class Knots {
    private Semantics semantics;
    private List<Knot> knots = new ArrayList<Knot>();

    public Knots(Semantics semantics, String text) {
        this.semantics = semantics;
        this.parseText(text);
        this.initialize();
    }

    private void parseText(String text) {
        for (char c : text.toCharArray()) {
            Semantics.Semantic semantic = this.semantics.observe(Character.toString(c));
            Knot knot = new Knot(semantic, null, null);
            this.knots.add(knot);
        }
    }

    private void initialize() {
        int length = this.knots.size() - 1;
        for (int i = 0; i < length; ++i) {
            Knot left = this.knots.get(i);
            Knot right = this.knots.get(i + 1);
            this.semantics.observe(left, right);
        }
    }

    public void debug() {
        System.out.println("********** size: " + this.knots.size());
        for (Knot knot : this.knots) {
            if (knot.getSemantic().isTerminal()) {
                System.out.println(knot);
                continue;
            }
            System.out.println(knot + ": p(" + this.semantics.getGlobalCount() + ", " + knot.getSemantic().getLeft().getCount() + ", " + knot.getSemantic().getRight().getCount() + ", " + knot.getSemantic().getCount() + ") = " + NumberFormat.getNumberInstance().format(knot.getSemantic().getEvidence()));
        }
    }

    public boolean induce() {
        if (this.knots.size() < 2) {
            return false;
        }
        int length = this.knots.size() - 1;
        double p = -1.0;
        int pIndex = 0;
        Semantics.Semantic pSemantic = null;
        for (int i = 0; i < length; ++i) {
            Knot right;
            Knot left = this.knots.get(i);
            Semantics.Semantic semantic = this.semantics.test(left, right = this.knots.get(i + 1));
            double pT = semantic.getEvidence();
            if (!(pT > p)) continue;
            p = pT;
            pIndex = i;
            pSemantic = semantic;
        }
        Knot left = this.knots.remove(pIndex);
        Knot right = this.knots.remove(pIndex);
        Knot knot = new Knot(pSemantic, left, right);
        this.knots.add(pIndex, knot);
        if (pIndex > 0) {
            this.semantics.observe(this.knots.get(pIndex - 1), knot);
        }
        if (pIndex + 1 < this.knots.size()) {
            this.semantics.observe(knot, this.knots.get(pIndex + 1));
        }
        return true;
    }

    public class Knot {
        private Semantics.Semantic semantic;
        private List<Semantics.Semantic> loads = new ArrayList<Semantics.Semantic>();

        public Knot(Semantics.Semantic semantic, Knot left, Knot right) {
            if (left != null) {
                String symbol = Semantics.combineSymbol(left.getSemantic(), right.getSemantic());
                if (!semantic.getSymbol().equals(symbol)) {
                    throw new IllegalArgumentException("Illegal knots '" + left.getSemantic().getSymbol() + "' and '" + right.getSemantic().getSymbol() + "' to semantic '" + semantic.getSymbol() + "'");
                }
            }
            this.semantic = semantic;
            if (left != null) {
                this.loads.addAll(left.getLoads());
                this.loads.remove(semantic.getLeft());
            }
            this.loads.add(semantic);
            if (right != null) {
                this.loads.addAll(right.getLoads());
                this.loads.remove(semantic.getRight());
            }
        }

        public Semantics.Semantic getSemantic() {
            return this.semantic;
        }

        public List<Semantics.Semantic> getLoads() {
            return this.loads;
        }

        public String toString() {
            return this.semantic.toString();
        }
    }
}

