/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.semantic;

import com.intersult.ai.semantic.Knots;
import com.intersult.ai.util.Stats;
import java.util.HashMap;
import java.util.Map;

public class Semantics {
    public Map<String, Semantic> semantics = new HashMap<String, Semantic>();
    public int globalCount;

    public static String combineSymbol(Semantic left, Semantic right) {
        return left.symbol + right.symbol;
    }

    public int getGlobalCount() {
        return this.globalCount;
    }

    public Semantic observe(String symbol) {
        Semantic semantic = this.semantics.get(symbol);
        if (semantic == null) {
            semantic = new Semantic(symbol);
            this.semantics.put(symbol, semantic);
        }
        semantic.increase();
        return semantic;
    }

    public Semantic observe(Knots.Knot left, Knots.Knot right) {
        Semantic semantic = this.test(left, right);
        if (semantic == null) {
            semantic = new Semantic(left.getSemantic(), right.getSemantic());
            this.semantics.put(semantic.getSymbol(), semantic);
        }
        semantic.increase();
        return semantic;
    }

    public Semantic test(Knots.Knot left, Knots.Knot right) {
        String symbol = Semantics.combineSymbol(left.getSemantic(), right.getSemantic());
        return this.semantics.get(symbol);
    }

    public Knots parseText(String text) {
        return new Knots(this, text);
    }

    public class Semantic {
        private Semantic left;
        private Semantic right;
        private String symbol;
        private int count;

        public Semantic(String symbol) {
            this.symbol = symbol;
        }

        public Semantic(Semantic left, Semantic right) {
            this.left = left;
            this.right = right;
            this.symbol = Semantics.combineSymbol(left, right);
        }

        public Semantic getLeft() {
            return this.left;
        }

        public Semantic getRight() {
            return this.right;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public int getCount() {
            return this.count;
        }

        public void increase() {
            ++this.count;
            ++Semantics.this.globalCount;
        }

        public boolean isTerminal() {
            return this.left == null;
        }

        public double getEvidence() {
            double p = Stats.normalF(Semantics.this.globalCount / 2, this.count, this.left.count, this.right.count);
            return p;
        }

        public String toString() {
            return this.left == null ? this.symbol : "(" + this.left.toString() + this.right.toString() + ")";
        }
    }
}

