/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.transduction.bool;

import com.intersult.ai.transduction.bool.ProbabilisticSelectStrategy;
import com.intersult.ai.transduction.bool.SelectStrategy;

public abstract class Gate {
    private static SelectStrategy selectStrategy = new ProbabilisticSelectStrategy();

    public static void setSelectStrategy(SelectStrategy selectStrategy) {
        Gate.selectStrategy = selectStrategy;
    }

    public static int select(int[] values) {
        return selectStrategy.select(values);
    }

    public static int[] extract(int[][] values, int index) {
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i][index];
        }
        return result;
    }

    public abstract int size();

    public abstract boolean get(int var1);

    public abstract void set(int var1, boolean var2);

    public abstract boolean getLast(int var1);

    public abstract void setLast(int var1, boolean var2);

    public abstract void setGoal(int var1, boolean var2);

    public abstract boolean getGoal(int var1);

    public abstract void induce();

    public abstract void deduce();

    public int getInteger() {
        int integer = 0;
        for (int i = 0; i < this.size(); ++i) {
            integer = (integer << 1) + (this.get(i) ? 1 : 0);
        }
        return integer;
    }

    public void setInteger(int value) {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.set(i, (value & 1) == 1);
            value >>= 1;
        }
    }

    public int getLastInteger() {
        int integer = 0;
        for (int i = 0; i < this.size(); ++i) {
            integer = (integer << 1) + (this.getLast(i) ? 1 : 0);
        }
        return integer;
    }

    public void setLastInteger(int value) {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.setLast(i, (value & 1) == 1);
            value >>= 1;
        }
    }

    public int getGoalInteger() {
        int integer = 0;
        for (int i = 0; i < this.size(); ++i) {
            integer = (integer << 1) + (this.getGoal(i) ? 1 : 0);
        }
        return integer;
    }

    public void setGoalInteger(int value) {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.setGoal(i, (value & 1) == 1);
            value >>= 1;
        }
    }

    public int distance(Gate gate) {
        if (this.size() != gate.size()) {
            throw new IllegalArgumentException("Size does not match");
        }
        int distance = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == gate.get(i)) continue;
            ++distance;
        }
        return distance;
    }

    public void copy(Gate to) {
        if (this.size() != to.size()) {
            throw new IllegalArgumentException("Size does not match");
        }
        for (int i = 0; i < this.size(); ++i) {
            to.set(i, this.get(i));
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            buffer.append(this.get(i) ? (char)'1' : '0');
        }
        return buffer.toString();
    }

    public String toLastString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            buffer.append(this.getLast(i) ? (char)'1' : '0');
        }
        return buffer.toString();
    }

    public String toGoalString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            buffer.append(this.getGoal(i) ? (char)'1' : '0');
        }
        return buffer.toString();
    }
}

