/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.transduction.bool;

import com.intersult.ai.transduction.bool.Reference;
import com.intersult.ai.transduction.bool.Values;

public class Logic
extends Values {
    private Reference input;
    int[][] evidence;

    public Logic(int outputSize, int inputSize) {
        super(outputSize);
        this.input = new Reference(inputSize);
        this.evidence = new int[1 << inputSize][1 << outputSize];
    }

    public Reference getInput() {
        return this.input;
    }

    @Override
    public void induce() {
        int inputIndex = this.input.getLastInteger();
        int outputIndex = this.getGoalInteger();
        super.induce();
        this.input.setGoalInteger(Logic.select(Logic.extract(this.evidence, outputIndex)));
        int[] nArray = this.evidence[inputIndex];
        int n = outputIndex;
        nArray[n] = nArray[n] + 1;
    }

    @Override
    public void deduce() {
        super.deduce();
        int inputIndex = this.input.getInteger();
        int ouputIndex = Logic.select(this.evidence[inputIndex]);
        this.setInteger(ouputIndex);
        this.setGoalInteger(ouputIndex);
    }

    @Override
    public String toString() {
        return this.input.toLastString() + " -> " + super.toString();
    }

    @Override
    public String toGoalString() {
        return this.input.toLastString() + " -> " + super.toGoalString();
    }

    public void debug() {
        for (int i = 0; i < this.evidence.length; ++i) {
            for (int j = 0; j < this.evidence[i].length; ++j) {
                System.out.format("%3d ", this.evidence[i][j]);
            }
            System.out.println();
        }
    }
}

