/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.transduction.bool;

import com.intersult.ai.transduction.bool.Gate;

public class Reference
extends Gate {
    private Gate[] gates;
    private int[] indices;

    public Reference(int size) {
        this.gates = new Gate[size];
        this.indices = new int[size];
    }

    public void connect(int index, Gate gate, int gateIndex) {
        this.gates[index] = gate;
        this.indices[index] = gateIndex;
    }

    public void connectAll(Gate gate) {
        if (this.size() != gate.size()) {
            throw new IllegalArgumentException("Gate sizes must match");
        }
        for (int i = 0; i < this.size(); ++i) {
            this.connect(i, gate, i);
        }
    }

    @Override
    public boolean get(int index) {
        return this.gates[index].get(this.indices[index]);
    }

    @Override
    public void set(int index, boolean value) {
        this.gates[index].set(this.indices[index], value);
    }

    @Override
    public boolean getLast(int index) {
        return this.gates[index].getLast(this.indices[index]);
    }

    @Override
    public void setLast(int index, boolean value) {
        this.gates[index].setLast(this.indices[index], value);
    }

    @Override
    public boolean getGoal(int index) {
        return this.gates[index].getGoal(this.indices[index]);
    }

    @Override
    public void setGoal(int index, boolean value) {
        this.gates[index].setGoal(this.indices[index], value);
    }

    @Override
    public int size() {
        return this.gates.length;
    }

    @Override
    public void induce() {
        throw new IllegalArgumentException();
    }

    @Override
    public void deduce() {
        throw new IllegalArgumentException();
    }
}

