/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.transduction.number.basics;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public abstract class Gate {
    public static final NumberFormat FORMAT = new DecimalFormat("+#,##0.0000;-#,##0.0000");

    public abstract int size();

    public abstract double get(int var1);

    public abstract void set(int var1, double var2);

    public abstract void addResiduum(int var1, double var2);

    public abstract double getResiduum(int var1);

    public abstract void induce();

    public abstract void deduce();

    public void setGoal(int index, double goal) {
        this.addResiduum(index, goal - this.get(index));
    }

    public void copy(Gate to) {
        if (this.size() != to.size()) {
            throw new IllegalArgumentException("Size does not match");
        }
        for (int i = 0; i < this.size(); ++i) {
            to.set(i, this.get(i));
        }
    }

    public double scalar(Gate gate) {
        if (this.size() != gate.size()) {
            throw new IllegalArgumentException("Size does not match");
        }
        double sum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            sum += this.get(i) * gate.get(i);
        }
        return sum;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.toString(i));
        }
        return buffer.toString();
    }

    public String toString(int index) {
        return FORMAT.format(this.get(index)) + " [" + FORMAT.format(this.getResiduum(index)) + "]";
    }
}

