/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.transduction.number.basics;

import com.intersult.ai.transduction.number.basics.Gate;
import java.io.Serializable;

public class Reference
extends Gate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Gate[] gates;
    private int[] indices;

    public Reference(int size) {
        this.gates = new Gate[size];
        this.indices = new int[size];
    }

    public void connect(int index, Gate gate, int gateIndex) {
        this.gates[index] = gate;
        this.indices[index] = gateIndex;
    }

    public void connectAll(Gate gate) {
        if (this.size() != gate.size()) {
            throw new IllegalArgumentException("Gate sizes must match");
        }
        for (int i = 0; i < this.size(); ++i) {
            this.connect(i, gate, i);
        }
    }

    @Override
    public int size() {
        return this.gates.length;
    }

    @Override
    public double get(int index) {
        return this.gates[index].get(this.indices[index]);
    }

    @Override
    public void set(int index, double value) {
        this.gates[index].set(this.indices[index], value);
    }

    @Override
    public void addResiduum(int index, double value) {
        this.gates[index].addResiduum(this.indices[index], value);
    }

    @Override
    public double getResiduum(int index) {
        return this.gates[index].getResiduum(this.indices[index]);
    }

    @Override
    public void induce() {
        throw new IllegalArgumentException();
    }

    @Override
    public void deduce() {
        throw new IllegalArgumentException();
    }
}

