/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.transduction.number.basics;

import com.intersult.ai.transduction.number.basics.Gate;
import com.intersult.ai.transduction.number.initializer.GaussInitializer;
import com.intersult.ai.transduction.number.initializer.Initializer;
import java.io.Serializable;
import java.util.Arrays;

public class Values
extends Gate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Initializer initializer = new GaussInitializer();
    private double[] values;
    private transient double[] residua;
    private transient double[] lastResidua;
    private transient int[] parties;
    private transient int[] lastParties;

    public Values(int size) {
        this.values = new double[size];
        this.residua = new double[size];
        this.lastResidua = new double[size];
        this.parties = new int[size];
        this.lastParties = new int[size];
        initializer.initialize(this.values);
    }

    public static void setInitializer(Initializer initializer) {
        Values.initializer = initializer;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public double get(int index) {
        return this.values[index];
    }

    @Override
    public void set(int index, double value) {
        this.values[index] = value;
    }

    @Override
    public void addResiduum(int index, double residuum) {
        int n = index;
        this.residua[n] = this.residua[n] + residuum;
        int n2 = index;
        this.parties[n2] = this.parties[n2] + 1;
    }

    @Override
    public double getResiduum(int index) {
        int parties = this.lastParties[index];
        return parties == 0 ? 0.0 : this.lastResidua[index] / (double)parties;
    }

    @Override
    public void induce() {
        this.increment();
        this.integrate();
    }

    protected void increment() {
        System.arraycopy(this.residua, 0, this.lastResidua, 0, this.residua.length);
        System.arraycopy(this.parties, 0, this.lastParties, 0, this.parties.length);
        Arrays.fill(this.residua, 0.0);
        Arrays.fill(this.parties, 0);
    }

    protected void integrate() {
        for (int i = 0; i < this.values.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] + this.getResiduum(i);
        }
    }

    @Override
    public void deduce() {
    }
}

