/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.transduction.number.elements;

import com.intersult.ai.transduction.number.basics.Gate;
import com.intersult.ai.transduction.number.basics.Input;
import com.intersult.ai.transduction.number.basics.Reference;
import com.intersult.ai.transduction.number.factory.Factory;
import com.intersult.ai.transduction.number.factory.Linear2Factory;

public class Benes
extends Reference
implements Input {
    private static final long serialVersionUID = 1L;
    private static Factory factory = new Linear2Factory();
    private Reference input;
    private Gate[] in;
    private Gate[] hidden;
    private Gate[] out;

    public Benes(int size) {
        super(size);
        if (size < 4) {
            throw new IllegalArgumentException("Min size is 4");
        }
        this.input = new Reference(size);
        int inputSize = size >> 1;
        this.hidden = new Gate[2];
        if (size == 4) {
            this.hidden[0] = factory.create();
            this.hidden[1] = factory.create();
        } else {
            this.hidden[0] = new Benes(inputSize);
            this.hidden[1] = new Benes(inputSize);
        }
        this.in = new Gate[inputSize];
        this.out = new Gate[inputSize];
        for (int i = 0; i < inputSize; ++i) {
            this.in[i] = factory.create();
            ((Input)((Object)this.in[i])).getInput().connect(0, this.input, 2 * i);
            ((Input)((Object)this.in[i])).getInput().connect(1, this.input, 2 * i + 1);
            ((Input)((Object)this.hidden[0])).getInput().connect(i, this.in[i], 0);
            ((Input)((Object)this.hidden[1])).getInput().connect(i, this.in[i], 1);
            this.out[i] = factory.create();
            ((Input)((Object)this.out[i])).getInput().connect(0, this.hidden[0], i);
            ((Input)((Object)this.out[i])).getInput().connect(1, this.hidden[1], i);
            super.connect(2 * i, this.out[i], 0);
            super.connect(2 * i + 1, this.out[i], 1);
        }
    }

    public static void setFactory(Factory factory) {
        Benes.factory = factory;
    }

    @Override
    public Reference getInput() {
        return this.input;
    }

    @Override
    public void induce() {
        int i;
        for (i = 0; i < this.out.length; ++i) {
            this.out[i].induce();
        }
        this.hidden[0].deduce();
        this.hidden[1].deduce();
        for (i = 0; i < this.in.length; ++i) {
            this.in[i].induce();
        }
    }

    @Override
    public void deduce() {
        int i;
        for (i = 0; i < this.in.length; ++i) {
            this.in[i].deduce();
        }
        this.hidden[0].deduce();
        this.hidden[1].deduce();
        for (i = 0; i < this.out.length; ++i) {
            this.out[i].deduce();
        }
    }

    @Override
    public void connect(int index, Gate gate, int gateIndex) {
        throw new IllegalArgumentException("Reference is inherited");
    }
}

