/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.transduction.number.elements;

import com.intersult.ai.transduction.number.basics.Reference;
import com.intersult.ai.transduction.number.basics.Values;

public class Bilinear
extends Values {
    private static final long serialVersionUID = 1L;
    private Reference x;
    private Reference y;

    public Bilinear(int size) {
        super(1);
        this.x = new Reference(size);
        this.y = new Reference(size);
    }

    public Reference getX() {
        return this.x;
    }

    public Reference getY() {
        return this.y;
    }

    @Override
    public void induce() {
        this.increment();
        double rY = this.getResiduum(0) / (1.0 + this.x.scalar(this.x));
        double rX = this.getResiduum(0) / (1.0 + this.y.scalar(this.y));
        for (int i = 0; i < this.x.size(); ++i) {
            double correctX = rX * this.y.get(i);
            double correctY = rY * this.x.get(i);
            this.x.addResiduum(i, correctX);
            this.y.addResiduum(i, correctY);
        }
        this.integrate();
    }

    @Override
    public void deduce() {
        double z = this.x.scalar(this.y);
        this.set(0, z);
    }
}

