/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.transduction.number.elements;

import com.intersult.ai.transduction.number.basics.Reference;
import com.intersult.ai.transduction.number.basics.Values;

public class Exponential
extends Values {
    private static final long serialVersionUID = 1L;
    private Reference input = new Reference(1);
    private double lambda;

    public Exponential(int size, double lambda) {
        super(size);
        this.lambda = lambda;
    }

    public Reference getInput() {
        return this.input;
    }

    @Override
    public void induce() {
        this.increment();
        this.integrate();
    }

    @Override
    public void deduce() {
        for (int i = this.size() - 1; i > 0; --i) {
            double value = this.lambda * this.get(i) + (1.0 - this.lambda) * this.get(i - 1);
            this.set(i, value);
        }
        this.set(0, this.input.get(0));
    }
}

