/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.transduction.number.elements;

import com.intersult.ai.transduction.number.basics.Gate;
import com.intersult.ai.transduction.number.basics.Input;
import com.intersult.ai.transduction.number.basics.Reference;
import com.intersult.ai.transduction.number.basics.Values;
import com.intersult.ai.transduction.number.elements.Bilinear;

public class Linear
extends Reference
implements Input {
    private static final long serialVersionUID = 1L;
    private Reference input;
    private Gate[] y;
    private Bilinear[] bilinears;

    public Linear(int size) {
        this(size, size);
    }

    public Linear(int inputSize, int outputSize) {
        super(outputSize);
        int i;
        this.input = new Reference(inputSize);
        this.y = new Gate[outputSize];
        this.bilinears = new Bilinear[outputSize];
        for (i = 0; i < this.y.length; ++i) {
            this.y[i] = new Values(inputSize);
            this.bilinears[i] = new Bilinear(inputSize);
        }
        for (i = 0; i < this.bilinears.length; ++i) {
            for (int j = 0; j < inputSize; ++j) {
                this.bilinears[i].getX().connect(j, this.input, j);
                this.bilinears[i].getY().connect(j, this.y[i], j);
            }
            super.connect(i, this.bilinears[i], 0);
        }
    }

    @Override
    public Reference getInput() {
        return this.input;
    }

    @Override
    public void induce() {
        int i;
        for (i = 0; i < this.bilinears.length; ++i) {
            this.bilinears[i].induce();
        }
        for (i = 0; i < this.y.length; ++i) {
            this.y[i].induce();
        }
    }

    @Override
    public void deduce() {
        int i;
        for (i = 0; i < this.y.length; ++i) {
            this.y[i].deduce();
        }
        for (i = 0; i < this.bilinears.length; ++i) {
            this.bilinears[i].deduce();
        }
    }

    @Override
    public void connect(int index, Gate gate, int gateIndex) {
        throw new IllegalArgumentException("Reference is inherited");
    }
}

