/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.transduction.number.elements;

import com.intersult.ai.transduction.number.basics.Input;
import com.intersult.ai.transduction.number.basics.Reference;
import com.intersult.ai.transduction.number.basics.Values;

public class Linear2
extends Values
implements Input {
    private static final long serialVersionUID = 1L;
    private Reference input = new Reference(2);
    private Values[] hidden = new Values[2];

    public Linear2() {
        super(2);
        this.hidden[0] = new Values(2);
        this.hidden[1] = new Values(2);
    }

    @Override
    public Reference getInput() {
        return this.input;
    }

    @Override
    public void induce() {
        this.increment();
        double rYdiv = 1.0 + this.input.scalar(this.input);
        double rY0 = this.getResiduum(0) / rYdiv;
        double rY1 = this.getResiduum(1) / rYdiv;
        double rX0 = this.getResiduum(0) / (1.0 + this.hidden[0].scalar(this.hidden[0]));
        double rX1 = this.getResiduum(1) / (1.0 + this.hidden[1].scalar(this.hidden[1]));
        this.input.addResiduum(0, rX0 * this.hidden[0].get(0));
        this.input.addResiduum(0, rX1 * this.hidden[1].get(0));
        this.hidden[0].addResiduum(0, rY0 * this.input.get(0));
        this.hidden[1].addResiduum(0, rY1 * this.input.get(0));
        this.input.addResiduum(1, rX0 * this.hidden[0].get(1));
        this.input.addResiduum(1, rX1 * this.hidden[1].get(1));
        this.hidden[0].addResiduum(1, rY0 * this.input.get(1));
        this.hidden[1].addResiduum(1, rY1 * this.input.get(1));
        this.hidden[0].induce();
        this.hidden[1].induce();
        this.integrate();
    }

    @Override
    public void deduce() {
        this.hidden[0].deduce();
        this.hidden[1].deduce();
        this.set(0, this.input.get(0) * this.hidden[0].get(0) + this.input.get(1) * this.hidden[0].get(1));
        this.set(1, this.input.get(0) * this.hidden[0].get(0) + this.input.get(1) * this.hidden[1].get(1));
    }
}

