/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.util;

public class BoolMatrix {
    public boolean[][] values;

    public BoolMatrix(int height) {
        this(height, 1);
    }

    public BoolMatrix(int height, int width) {
        this.values = new boolean[height][width];
    }

    public static BoolMatrix unity(int size) {
        return BoolMatrix.unity(size, size);
    }

    public static BoolMatrix unity(int height, int width) {
        BoolMatrix matrix = new BoolMatrix(height, width);
        for (int i = 0; i < height && i < width; ++i) {
            matrix.values[i][i] = true;
        }
        return matrix;
    }

    public static BoolMatrix vector(boolean ... values) {
        BoolMatrix matrix = new BoolMatrix(values.length);
        for (int i = 0; i < values.length; ++i) {
            matrix.values[i][0] = values[i];
        }
        return matrix;
    }

    public int getHeight() {
        return this.values.length;
    }

    public int getWidth() {
        return this.values[0].length;
    }

    public BoolMatrix transpose() {
        BoolMatrix matrix = new BoolMatrix(this.getWidth(), this.getHeight());
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                matrix.values[j][i] = this.values[i][j];
            }
        }
        return matrix;
    }

    public BoolMatrix negate() {
        BoolMatrix matrix = new BoolMatrix(this.getHeight(), this.getWidth());
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                matrix.values[i][j] = !this.values[i][j];
            }
        }
        return matrix;
    }

    public BoolMatrix add(BoolMatrix matrix) {
        if (this.getHeight() != matrix.getHeight() || this.getWidth() != matrix.getWidth()) {
            throw new IllegalArgumentException("Size must match");
        }
        BoolMatrix result = new BoolMatrix(this.getHeight(), this.getWidth());
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                result.values[i][j] = this.values[i][j] || matrix.values[i][j];
            }
        }
        return result;
    }

    public BoolMatrix subtract(BoolMatrix matrix) {
        if (this.getHeight() != matrix.getHeight() || this.getWidth() != matrix.getWidth()) {
            throw new IllegalArgumentException("Size must match");
        }
        BoolMatrix result = new BoolMatrix(this.getHeight(), this.getWidth());
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                result.values[i][j] = this.values[i][j] && !matrix.values[i][j];
            }
        }
        return result;
    }

    public BoolMatrix multiply(BoolMatrix matrix) {
        if (this.getWidth() != matrix.getHeight()) {
            throw new IllegalArgumentException("Size must match");
        }
        BoolMatrix result = new BoolMatrix(this.getHeight(), matrix.getWidth());
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < matrix.values[0].length; ++j) {
                for (int k = 0; k < this.values[i].length; ++k) {
                    boolean[] blArray = result.values[i];
                    int n = j;
                    blArray[n] = blArray[n] | (this.values[i][k] && matrix.values[k][j]);
                }
            }
        }
        return result;
    }

    public boolean scalar(BoolMatrix matrix) {
        if (this.getWidth() != 1 || matrix.getWidth() != 1 || this.getHeight() != matrix.getHeight()) {
            throw new IllegalArgumentException("Vector size must match");
        }
        boolean result = false;
        for (int i = 0; i < this.values.length; ++i) {
            result |= this.values[i][0] && matrix.values[i][0];
        }
        return result;
    }

    public int getInteger() {
        int integer = 0;
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                integer <<= 1;
                integer += this.values[i][j] ? 1 : 0;
            }
        }
        return integer;
    }

    public void setInteger(int value) {
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                this.values[i][j] = (value & 1) == 1;
                value >>= 1;
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                buffer.append(this.values[i][j] ? (char)'1' : '0');
            }
            buffer.append("\r\n");
        }
        return buffer.toString();
    }
}

