/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.util;

import java.text.DecimalFormat;

public class Matrix {
    public static final DecimalFormat FORMAT = new DecimalFormat("+0.000");
    public double[][] values;

    public Matrix(int height) {
        this(height, 1);
    }

    public Matrix(int height, int width) {
        this.values = new double[height][width];
    }

    public static Matrix unity(int size) {
        return Matrix.unity(size, size);
    }

    public static Matrix unity(int height, int width) {
        Matrix matrix = new Matrix(height, width);
        for (int i = 0; i < height && i < width; ++i) {
            matrix.values[i][i] = 1.0;
        }
        return matrix;
    }

    public static Matrix vector(double ... values) {
        Matrix matrix = new Matrix(values.length);
        for (int i = 0; i < values.length; ++i) {
            matrix.values[i][0] = values[i];
        }
        return matrix;
    }

    public int getHeight() {
        return this.values.length;
    }

    public int getWidth() {
        return this.values[0].length;
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.getWidth(), this.getHeight());
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                matrix.values[j][i] = this.values[i][j];
            }
        }
        return matrix;
    }

    public Matrix negate() {
        Matrix matrix = new Matrix(this.getHeight(), this.getWidth());
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                matrix.values[i][j] = -this.values[i][j];
            }
        }
        return matrix;
    }

    public Matrix add(Matrix matrix) {
        if (this.getHeight() != matrix.getHeight() || this.getWidth() != matrix.getWidth()) {
            throw new IllegalArgumentException("Size must match");
        }
        Matrix result = new Matrix(this.getHeight(), this.getWidth());
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                result.values[i][j] = this.values[i][j] + matrix.values[i][j];
            }
        }
        return result;
    }

    public Matrix subtract(Matrix matrix) {
        if (this.getHeight() != matrix.getHeight() || this.getWidth() != matrix.getWidth()) {
            throw new IllegalArgumentException("Size must match");
        }
        Matrix result = new Matrix(this.getHeight(), this.getWidth());
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                result.values[i][j] = this.values[i][j] - matrix.values[i][j];
            }
        }
        return result;
    }

    public Matrix multiply(double value) {
        Matrix matrix = new Matrix(this.getHeight(), this.getWidth());
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < matrix.values[i].length; ++j) {
                matrix.values[i][j] = value * this.values[i][j];
            }
        }
        return matrix;
    }

    public Matrix multiply(Matrix matrix) {
        if (this.getWidth() != matrix.getHeight()) {
            throw new IllegalArgumentException("Size must match");
        }
        Matrix result = new Matrix(this.getHeight(), matrix.getWidth());
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < matrix.values[0].length; ++j) {
                for (int k = 0; k < this.values[i].length; ++k) {
                    double[] dArray = result.values[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.values[i][k] * matrix.values[k][j];
                }
            }
        }
        return result;
    }

    public double scalar(Matrix matrix) {
        if (this.getWidth() != 1 || matrix.getWidth() != 1 || this.getHeight() != matrix.getHeight()) {
            throw new IllegalArgumentException("Vector size must match");
        }
        double result = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            result += this.values[i][0] * matrix.values[i][0];
        }
        return result;
    }

    public Matrix diagonale() {
        Matrix diagonale = new Matrix(Math.min(this.getHeight(), this.getWidth()));
        for (int i = 0; i < diagonale.values.length; ++i) {
            diagonale.values[i][0] = this.values[i][i];
        }
        return diagonale;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                buffer.append(FORMAT.format(this.values[i][j]));
                buffer.append(" ");
            }
            buffer.append("\r\n");
        }
        return buffer.toString();
    }
}

