/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.util;

import com.intersult.util.string.StringUtils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Random;

public final class Num {
    public static final Random random = new Random();
    public static final double LOG2 = Math.log(2.0);
    public static final double PI_2 = Math.PI * 2;
    public static final double SQRT_PI_2 = Math.sqrt(Math.PI * 2);

    public static long combine(long x, long y) {
        long z = 0L;
        long i = 0L;
        while (x > 0L || y > 0L) {
            z |= (x & 1L) << (int)i++;
            z |= (y & 1L) << (int)i++;
            x >>= 1;
            y >>= 1;
        }
        return z;
    }

    public static long splitX(long z) {
        long x = 0L;
        long i = 0L;
        while (z > 0L) {
            x |= (z & 1L) << (int)i++;
            z >>= 2;
        }
        return x;
    }

    public static long splitY(long z) {
        return Num.splitX(z >> 1);
    }

    public static long toNumber(String string) {
        long x = 0L;
        for (int i = 0; i < string.length(); ++i) {
            x <<= 8;
            x += (long)string.charAt(i);
        }
        return x;
    }

    public static String toString(long number) {
        String string = "";
        while (number > 0L) {
            string = (char)(number & 0xFFL) + string;
            number >>= 8;
        }
        return string;
    }

    public static String toBinaryString(BigInteger number, int bits) {
        String string = number.toString(2);
        if (bits > 0 && string.length() < bits) {
            string = StringUtils.pow((String)"0", (int)(bits - string.length())) + string;
        }
        return string;
    }

    public static double significance(long a, long b, long k, long n) {
        double lambda = (double)a * (double)b / (double)n;
        return (double)k * (Math.log(k) + Math.log(lambda) - 1.0) / Math.log(n);
    }

    public static double scalar(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Array sizes must be identical");
        }
        double z = 0.0;
        for (int i = 0; i < x.length; ++i) {
            z += x[i] * y[i];
        }
        return z;
    }

    public static double[] multiply(double[] x, double y) {
        double[] z = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            z[i] = x[i] * y;
        }
        return z;
    }

    public static double[] subtract(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Array sizes must be identical");
        }
        double[] z = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            z[i] = x[i] - y[i];
        }
        return z;
    }

    public static String toString(double[] values) {
        StringBuffer buffer = new StringBuffer("[");
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(values[i]);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static void randomizeGauss(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = random.nextGaussian();
        }
    }

    public static void randomizeFactor(double[] array) {
        Num.randomizeFactor(array, 0, array.length, 1.0);
    }

    public static void randomizeFactor(double[] array, int startIndex, int endIndex, double product) {
        double factor;
        int size = endIndex - startIndex;
        array[startIndex] = factor = Math.pow(product, 1.0 / (double)size);
        int i = startIndex + 1;
        while (i < endIndex) {
            array[i] = factor;
            double shift = random.nextDouble();
            int n = i - 1;
            array[n] = array[n] / shift;
            int n2 = i++;
            array[n2] = array[n2] * shift;
        }
    }

    public static void randomizeRot(double[] array) {
        Arrays.fill(array, Math.sqrt(1.0 / (double)array.length));
        for (int i = 1; i < array.length; ++i) {
            double phi = random.nextDouble() * Math.PI * 2.0;
            Num.rotatePhi(array, i - 1, i, phi);
        }
    }

    public static void rotatePhi(double[] array, int x, int y, double phi) {
        double sin = Math.sin(phi);
        double cos = Math.cos(phi);
        double temp = sin * array[x] + cos * array[y];
        array[y] = cos * array[x] - sin * array[y];
        array[x] = temp;
    }

    public static void rotate(double[] array, int index, double sin) {
        double cos = Math.sqrt(1.0 - sin * sin);
        double x = sin * array[index] + cos * array[index + 1];
        array[index + 1] = cos * array[index] - sin * array[index + 1];
        array[index] = x;
    }

    public static double nextPoisson() {
        return -Math.log(random.nextDouble());
    }

    public static double quad(double value) {
        return value * value;
    }

    public static double sgnSqrt(double value) {
        return value < 0.0 ? Math.sqrt(-value) : Math.sqrt(value);
    }

    public static void index(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = i;
        }
    }

    public static double factorial(int n) {
        double y = 1.0;
        for (int i = 2; i <= n; ++i) {
            y *= (double)i;
        }
        return y;
    }

    public static int factorialInt(int n) {
        int y = 1;
        for (int i = 2; i <= n; ++i) {
            y *= i;
        }
        return y;
    }

    public static int simpleBinomial(int n, int k) {
        int i;
        int y = 1;
        for (i = k + 1; i <= n; ++i) {
            y *= i;
        }
        for (i = 2; i <= n - k; ++i) {
            y /= i;
        }
        return y;
    }

    public static long binomial(int n, int k) {
        if (2 * k > n) {
            k = n - k;
        }
        long z = 1L;
        for (int i = 1; i <= k; ++i) {
            z *= (long)(n + 1 - i);
            z /= (long)i;
        }
        return z;
    }

    public static double ld(BigInteger x) {
        return Num.log(x) / LOG2;
    }

    public static double log(BigInteger x) {
        int i = x.bitLength() - 1000;
        if (i > 0) {
            BigInteger y = x.shiftRight(i);
            return Math.log(y.doubleValue()) + (double)i * Math.log(2.0);
        }
        return Math.log(x.doubleValue());
    }

    public static long log2(long x) {
        long n = 0L;
        while (x > 1L) {
            x >>= 1;
            ++n;
        }
        return n;
    }

    public static double gamma(double x) {
        return Math.sqrt(Math.PI / x * (2.0 + 1.0 / (3.0 * x))) * Math.pow(x / Math.E, x);
    }

    public static double hypervolume(double r, double n) {
        double n2 = 0.5 * n;
        return Math.pow(Math.PI, n2) / Num.gamma(n2 + 1.0) * Math.pow(r, n);
    }

    public static int getInteger(boolean[] bool) {
        int integer = 0;
        for (int i = 0; i < bool.length; ++i) {
            integer = (integer << 1) + (bool[i] ? 1 : 0);
        }
        return integer;
    }

    public static void setInteger(boolean[] bool, int value) {
        for (int i = bool.length - 1; i >= 0; --i) {
            bool[i] = (value & 1) == 1;
            value >>= 1;
        }
    }

    public static int sqr4(int x) {
        return Num.sqr(Num.sqr(x));
    }

    public static int sqr(int x) {
        if (x == 0) {
            return 0;
        }
        int y = 0;
        int ty = x;
        while ((ty = ((y = ty) + x / y) / 2) < y) {
        }
        return y;
    }
}

