/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.ai.util;

import com.intersult.util.Quantor;
import java.util.Arrays;
import java.util.Random;

public class Stats {
    public static final double gaussFactor = 1.0 / Math.sqrt(Math.PI * 2);
    public static Random random = new Random();

    public static Random getRandom() {
        return random;
    }

    public static void setRandom(Random random) {
        Stats.random = random;
    }

    public static double hypergeometricF(int n, int nA, int nB, int nAB) {
        double p = 0.0;
        for (int i = 0; i <= nAB; ++i) {
            p += Stats.hypergeometric(n, nA, nB, i);
        }
        return p;
    }

    public static double hypergeometric(int n, int nA, int nB, int nAB) {
        return (double)(Stats.binomial(nA, nAB) * Stats.binomial(n - nA, nB - nAB)) / (double)Stats.binomial(n, nB);
    }

    public static long binomial(int n, int k) {
        return Stats.factorial(n) / (Stats.factorial(k) * Stats.factorial(n - k));
    }

    public static long factorial(int n) {
        long z = 1L;
        for (int i = 2; i <= n; ++i) {
            z *= (long)i;
        }
        return z;
    }

    public static double normal(int N, int n, int ... nX) {
        double mu = N;
        int sigmaQ = 1;
        for (int i = 0; i < nX.length; ++i) {
            mu *= (double)nX[i] / (double)N;
            sigmaQ *= N - nX[i];
        }
        double sigma = Math.sqrt(mu * (double)sigmaQ) / (double)N;
        return Stats.normal(mu, sigma, (double)n);
    }

    public static double normal(double mu, double sigma, double x) {
        return Stats.normal((x - mu) / sigma) / sigma;
    }

    public static double normal(double x) {
        return gaussFactor * Math.exp(-0.5 * Stats.quad(x));
    }

    public static double quad(double x) {
        return x * x;
    }

    public static int nextInt(int min, int max) {
        return min == max ? min : min + random.nextInt(max - min);
    }

    public static long nextLong(long max) {
        long n = random.nextLong() % max;
        if (n < 0L) {
            n += max;
        }
        return n;
    }

    public static double normalF(int N, int n, int ... nX) {
        double mu = N;
        int sigmaQ = 1;
        for (int i = 0; i < nX.length; ++i) {
            mu *= (double)nX[i] / (double)N;
            sigmaQ *= N - nX[i];
        }
        double sigma = Math.sqrt(mu * (double)sigmaQ) / (double)N;
        return Stats.normalF(mu, sigma, (double)n + 0.5);
    }

    public static double normalF(double mu, double sigma, double x) {
        return Stats.normalF((x - mu) / sigma);
    }

    public static double normalF(double x) {
        double t = 1.0 / (1.0 + 0.33267 * Math.abs(x));
        double u = t * (0.3480242 + t * (-0.0958798 + t * 0.7478556));
        double z = 0.5 * u * Math.exp(-0.5 * x * x);
        return x < 0.0 ? z : 1.0 - z;
    }

    public static double erf(double x) {
        double t = 1.0 / (1.0 + 0.47047 * Math.abs(x));
        double u = t * (0.3480242 + t * (-0.0958798 + t * 0.7478556));
        double z = 0.5 * u * Math.exp(-x * x);
        return x < 0.0 ? z : 1.0 - z;
    }

    public static int select(double ... y) {
        double sum = Quantor.sum((double[])y);
        double x = random.nextDouble() * sum;
        return Stats.selectValue(x, y);
    }

    public static int selectValue(double x, double ... y) {
        for (int i = 0; i < y.length; ++i) {
            if (!((x -= y[i]) <= 0.0)) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    public static int selectQuad(double ... y) {
        double sum = Quantor.quadSum((double[])y);
        double x = random.nextDouble() * sum;
        return Stats.selectQuadValue(x, y);
    }

    public static int selectQuadValue(double xq, double ... y) {
        for (int i = 0; i < y.length; ++i) {
            if (!((xq -= y[i] * y[i]) <= 0.0)) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    public static int selectQube(double ... y) {
        double sum = Quantor.qubeSum((double[])y);
        double x = random.nextDouble() * sum;
        return Stats.selectQubeValue(x, y);
    }

    public static int selectQubeValue(double xq, double ... y) {
        for (int i = 0; i < y.length; ++i) {
            if (!((xq -= y[i] * y[i] * y[i]) <= 0.0)) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    public static int select(int ... y) {
        int sum = Quantor.sum((int[])y);
        int x = random.nextInt(sum);
        return Stats.selectValue(x, y);
    }

    public static int selectValue(int x, int ... y) {
        for (int i = 0; i < y.length; ++i) {
            if ((x -= y[i]) > 0) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    public static int select(long ... y) {
        long sum = Quantor.sum((long[])y);
        long x = Stats.nextLong(sum);
        return Stats.selectValue(x, y);
    }

    public static int selectValue(long x, long ... y) {
        for (int i = 0; i < y.length; ++i) {
            if ((x -= y[i]) > 0L) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    public static void main(String[] args) {
        int N = 24;
        int[] nX = new int[]{8, 8, 8, 8};
        for (int nAB = 0; nAB <= Quantor.min((int[])nX); ++nAB) {
            System.out.println(N + ", " + Arrays.toString(nX) + ", " + nAB + ": " + Stats.normalF(N, nAB, nX));
        }
    }
}

