/*
 * Decompiled with CFR 0.152.
 */
package com.intersult;

import com.intersult.model.ChartData;
import com.intersult.utils.ChartUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class ChartListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void beforePhase(PhaseEvent phaseEvent) {
    }

    public void afterPhase(PhaseEvent phaseEvent) {
        String chartId = (String)phaseEvent.getFacesContext().getExternalContext().getRequestParameterMap().get("chartId");
        if (chartId != null) {
            this.handleChartRequest(phaseEvent, chartId);
        }
    }

    private void handleChartRequest(PhaseEvent phaseEvent, String id) {
        FacesContext facesContext = phaseEvent.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map sessionMap = externalContext.getSessionMap();
        ChartData chartData = (ChartData)sessionMap.get(id);
        if (chartData == null) {
            throw new NullPointerException("Missing chart data for '" + id + "'");
        }
        JFreeChart chart = ChartUtils.createChartWithType(chartData);
        ChartUtils.setGeneralChartProperties(chart, chartData);
        try {
            if (externalContext.getResponse() instanceof HttpServletResponse) {
                this.writeChartWithServletResponse((HttpServletResponse)externalContext.getResponse(), chart, chartData);
            }
        }
        catch (Exception exception) {
            throw new FacesException((Throwable)exception);
        }
        finally {
            this.emptySession(sessionMap, id);
            facesContext.responseComplete();
        }
    }

    private void writeChartWithServletResponse(HttpServletResponse response, JFreeChart chart, ChartData chartData) throws IOException {
        ServletOutputStream stream = response.getOutputStream();
        response.setContentType(ChartUtils.resolveContentType(chartData.getOutput()));
        this.writeChart((OutputStream)stream, chart, chartData);
    }

    private void writeChart(OutputStream stream, JFreeChart chart, ChartData chartData) throws IOException {
        if (chartData.getOutput().equalsIgnoreCase("png")) {
            ChartUtilities.writeChartAsPNG((OutputStream)stream, (JFreeChart)chart, (int)chartData.getWidth(), (int)chartData.getHeight());
        } else if (chartData.getOutput().equalsIgnoreCase("jpeg")) {
            ChartUtilities.writeChartAsJPEG((OutputStream)stream, (JFreeChart)chart, (int)chartData.getWidth(), (int)chartData.getHeight());
        }
        stream.flush();
        stream.close();
    }

    private void emptySession(Map<String, Object> sessionMap, String id) {
        sessionMap.remove(id);
    }
}

