/*
 * Decompiled with CFR 0.152.
 */
package com.intersult;

import com.intersult.model.ChartData;
import com.intersult.utils.ChartUtils;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class Chartlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        String id = request.getParameter("chartId");
        ChartData chartData = (ChartData)request.getSession().getAttribute(id);
        JFreeChart chart = ChartUtils.createChartWithType(chartData);
        ChartUtils.setGeneralChartProperties(chart, chartData);
        try {
            this.writeChart(response, chart, chartData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.emptySession(request, id);
        }
    }

    private void writeChart(HttpServletResponse response, JFreeChart chart, ChartData chartData) throws IOException {
        ServletOutputStream stream = response.getOutputStream();
        response.setContentType(ChartUtils.resolveContentType(chartData.getOutput()));
        if (chartData.getOutput().equalsIgnoreCase("png")) {
            ChartUtilities.writeChartAsPNG((OutputStream)stream, (JFreeChart)chart, (int)chartData.getWidth(), (int)chartData.getHeight());
        } else if (chartData.getOutput().equalsIgnoreCase("jpeg")) {
            ChartUtilities.writeChartAsJPEG((OutputStream)stream, (JFreeChart)chart, (int)chartData.getWidth(), (int)chartData.getHeight());
        }
        stream.flush();
        stream.close();
    }

    private void emptySession(HttpServletRequest request, String id) {
        request.getSession().removeAttribute(id);
    }
}

