/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.renderkit;

import com.intersult.component.UIChart;
import com.intersult.model.ChartData;
import com.intersult.renderkit.URLTagFragmentGenerator;
import com.intersult.utils.ChartUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryLabelEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;

public class ChartRenderer
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIChart chart = (UIChart)component;
        this.setChartDataAtSession(context, chart);
        String clientId = chart.getClientId(context);
        writer.startElement("img", (UIComponent)chart);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("width", (Object)String.valueOf(chart.getWidth()), null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("height", (Object)String.valueOf(chart.getHeight()), null);
        String viewId = context.getViewRoot().getViewId();
        String actionURL = context.getApplication().getViewHandler().getActionURL(context, viewId);
        writer.writeAttribute("src", (Object)(actionURL + "?ts=" + System.currentTimeMillis() + "&chartId=" + clientId), null);
        ChartUtils.renderPassThruImgAttributes(writer, (UIComponent)chart);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIChart chart = (UIChart)component;
        writer.endElement("img");
        if (chart.getGenerateMap() != null) {
            this.writeImageMap(context, chart);
        }
    }

    private void setChartDataAtSession(FacesContext facesContext, UIChart chart) {
        Map session = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        String clientId = chart.getClientId(facesContext);
        ChartData data = new ChartData(chart);
        session.put(clientId, data);
    }

    private void renderImageMapSupport(FacesContext context, UIChart uichart, ChartRenderingInfo chartRenderingInfo) {
        ResponseWriter writer = context.getResponseWriter();
        try {
            for (ChartEntity entity : chartRenderingInfo.getEntityCollection()) {
                CategoryLabelEntity categoryEntity;
                if (!(entity instanceof CategoryLabelEntity) || (categoryEntity = (CategoryLabelEntity)entity).getKey() == null) continue;
                categoryEntity.setToolTipText(categoryEntity.getKey().toString());
                categoryEntity.setURLText("?category=" + categoryEntity.getKey().toString());
            }
            writer.write("<script>");
            writer.write("function chart" + uichart.getId() + "Click(data) {");
            if (uichart.getOngeneratedimagemapclick() != null) {
                writer.write("  " + uichart.getOngeneratedimagemapclick() + "(data);");
            }
            writer.write("}");
            writer.write("</script>");
        }
        catch (IOException error) {
            error.printStackTrace();
        }
    }

    private void writeImageMap(FacesContext context, UIChart uichart) {
        ResponseWriter writer = context.getResponseWriter();
        ExternalContext externalContext = context.getExternalContext();
        Map sessionMap = externalContext.getSessionMap();
        String clientId = uichart.getClientId(context);
        ChartData data = (ChartData)sessionMap.get(clientId);
        JFreeChart chart = ChartUtils.createChartWithType(data);
        ChartUtils.setGeneralChartProperties(chart, data);
        ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (data.getOutput().equalsIgnoreCase("png")) {
                ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)data.getWidth(), (int)data.getHeight(), (ChartRenderingInfo)chartRenderingInfo);
            } else if (data.getOutput().equalsIgnoreCase("jpeg")) {
                ChartUtilities.writeChartAsJPEG((OutputStream)out, (JFreeChart)chart, (int)data.getWidth(), (int)data.getHeight(), (ChartRenderingInfo)chartRenderingInfo);
            }
            this.renderImageMapSupport(context, uichart, chartRenderingInfo);
            writer.write(ChartUtilities.getImageMap((String)uichart.getGenerateMap(), (ChartRenderingInfo)chartRenderingInfo, (ToolTipTagFragmentGenerator)new StandardToolTipTagFragmentGenerator(), (org.jfree.chart.imagemap.URLTagFragmentGenerator)new URLTagFragmentGenerator(uichart.getId())));
        }
        catch (IOException error) {
            error.printStackTrace();
        }
    }
}

