/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.utils;

import com.intersult.model.ChartAxisData;
import com.intersult.utils.ChartUtils;
import java.awt.Font;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;

public class ChartAxisUtils {
    public static ValueAxis createDateAxis(JFreeChart chart, ChartAxisData chartAxisData) {
        DateAxis dateAxis = new DateAxis(chartAxisData.getLabel());
        if (chartAxisData.getFormat() != null) {
            dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat(chartAxisData.getFormat()));
        }
        dateAxis.setTickUnit(DateAxis.DEFAULT_DATE_TICK_UNIT);
        return dateAxis;
    }

    public static ValueAxis createNumberAxis(JFreeChart chart, ChartAxisData chartAxisData) {
        NumberAxis numberAxis = new NumberAxis(chartAxisData.getLabel());
        if (chartAxisData.getFormat() != null) {
            numberAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(chartAxisData.getFormat()));
        }
        return numberAxis;
    }

    public static void createXYSeriesAxis(JFreeChart chart, ChartAxisData chartAxisData, int axisIndex) {
        ValueAxis axis = null;
        if (chartAxisData.getType() != null) {
            if (chartAxisData.getType().equals("number")) {
                axis = ChartAxisUtils.createNumberAxis(chart, chartAxisData);
            } else if (chartAxisData.getType().equals("date")) {
                axis = ChartAxisUtils.createDateAxis(chart, chartAxisData);
            }
            if (chartAxisData.getTickLabelFontSize() > 0.0f) {
                Font tickFont = CategoryAxis.DEFAULT_TICK_LABEL_FONT.deriveFont(chartAxisData.getTickLabelFontSize());
                axis.setTickLabelFont(tickFont);
            }
            axis.setTickLabelsVisible(chartAxisData.isTickLabels());
            axis.setTickMarksVisible(chartAxisData.isTickMarks());
            axis.setVerticalTickLabels(chartAxisData.isVerticalTickLabels());
        }
        XYPlot plot = chart.getXYPlot();
        if (chartAxisData.isDomain()) {
            plot.setDomainAxis(plot.getDomainAxisCount() - 1, axis);
        } else {
            plot.setRangeAxis(axisIndex, axis);
            XYDataset dataset = (XYDataset)chartAxisData.getDatasource();
            plot.setRenderer(axisIndex, (XYItemRenderer)new StandardXYItemRenderer());
            plot.setDataset(axisIndex, dataset);
            plot.mapDatasetToRangeAxis(axisIndex, axisIndex);
        }
        ChartAxisUtils.setXYSeriesAxisColors(chartAxisData, plot.getRenderer(axisIndex));
    }

    public static void setXYSeriesAxisColors(ChartAxisData chartAxisData, XYItemRenderer axisRenderer) {
        if (chartAxisData.getColors() != null) {
            String[] colors = chartAxisData.getColors().split(",");
            for (int i = 0; i < colors.length; ++i) {
                axisRenderer.setSeriesPaint(i, (Paint)ChartUtils.getColor(colors[i].trim()));
            }
        }
    }

    public static void createCategorySeriesAxis(JFreeChart chart, ChartAxisData chartAxisData, int axisIndex) {
        CategoryPlot plot = chart.getCategoryPlot();
        if (chartAxisData.isDomain()) {
            CategoryAxis axis = new CategoryAxis(chartAxisData.getLabel());
            axis.setTickLabelsVisible(chartAxisData.isTickLabels());
            axis.setTickMarksVisible(chartAxisData.isTickMarks());
            if (chartAxisData.getTickLabelFontSize() > 0.0f) {
                Font tickFont = CategoryAxis.DEFAULT_TICK_LABEL_FONT.deriveFont(chartAxisData.getTickLabelFontSize());
                axis.setTickLabelFont(tickFont);
            }
            if (chartAxisData.isVerticalTickLabels()) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            }
            plot.setDomainAxis(plot.getDomainAxisCount() - 1, axis);
        } else {
            ValueAxis axis = ChartAxisUtils.createNumberAxis(chart, chartAxisData);
            axis.setTickLabelsVisible(chartAxisData.isTickLabels());
            axis.setTickMarksVisible(chartAxisData.isTickMarks());
            if (chartAxisData.getTickLabelFontSize() > 0.0f) {
                Font tickFont = CategoryAxis.DEFAULT_TICK_LABEL_FONT.deriveFont(chartAxisData.getTickLabelFontSize());
                axis.setTickLabelFont(tickFont);
            }
            plot.setRangeAxis(axis);
        }
    }
}

