/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.utils;

import com.intersult.model.ChartAxisData;
import com.intersult.model.ChartData;
import com.intersult.utils.ChartAxisUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.WindDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;

public class ChartUtils {
    private static String[] passthruImgAttributes = new String[]{"alt", "styleClass", "onclick", "ondblclick", "onmousedown", "onmouseup", "onmouseover", "onmousemove", "onmouseout", "onkeypress", "onkeydown", "onkeyup", "usemap"};

    public static void renderPassThruImgAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        for (int i = 0; i < passthruImgAttributes.length; ++i) {
            Object value = component.getAttributes().get(passthruImgAttributes[i]);
            if (value == null) continue;
            writer.writeAttribute(passthruImgAttributes[i], value, null);
        }
        if (component.getAttributes().get("imgTitle") != null) {
            writer.writeAttribute("title", component.getAttributes().get("imgTitle"), null);
        }
    }

    public static PlotOrientation getPlotOrientation(String orientation) {
        if (orientation.equalsIgnoreCase("horizontal")) {
            return PlotOrientation.HORIZONTAL;
        }
        if (orientation.equalsIgnoreCase("vertical")) {
            return PlotOrientation.VERTICAL;
        }
        throw new RuntimeException("Unsupported plot orientation:" + orientation);
    }

    public static Color getColor(String color) {
        if (color.startsWith("#")) {
            return new Color(Integer.parseInt(color.substring(1), 16));
        }
        if (color.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (color.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (color.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (color.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (color.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (color.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (color.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (color.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (color.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (color.equalsIgnoreCase("darkgray")) {
            return Color.darkGray;
        }
        if (color.equalsIgnoreCase("lightgray")) {
            return Color.lightGray;
        }
        if (color.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (color.equalsIgnoreCase("white")) {
            return Color.white;
        }
        throw new RuntimeException("Unsupported chart color:" + color);
    }

    public static String resolveContentType(String output) {
        if (output.equalsIgnoreCase("png")) {
            return "img/png";
        }
        if (output.equalsIgnoreCase("jpeg")) {
            return "img/jpeg";
        }
        throw new RuntimeException("Unsupported output format:" + output);
    }

    public static JFreeChart createChartWithType(ChartData chartData) {
        JFreeChart chart = null;
        Object datasource = chartData.getDatasource();
        if (datasource instanceof PieDataset) {
            chart = ChartUtils.createChartWithPieDataSet(chartData);
        } else if (datasource instanceof CategoryDataset) {
            chart = ChartUtils.createChartWithCategoryDataSet(chartData);
        } else if (datasource instanceof XYDataset) {
            chart = ChartUtils.createChartWithXYDataSet(chartData);
        } else {
            throw new RuntimeException("Unsupported chart data type '" + chartData.getClass().getName() + "'");
        }
        if (chartData.getLegendFontSize() > 0.0f) {
            chart.getLegend().setItemFont(LegendTitle.DEFAULT_ITEM_FONT.deriveFont(chartData.getLegendFontSize()));
        }
        if (!chartData.isLegendBorder()) {
            chart.getLegend().setBorder(0.0, 0.0, 0.0, 0.0);
        }
        return chart;
    }

    public static void setGeneralChartProperties(JFreeChart chart, ChartData chartData) {
        chart.setBackgroundPaint((Paint)ChartUtils.getColor(chartData.getBackground()));
        chart.getPlot().setBackgroundPaint((Paint)ChartUtils.getColor(chartData.getForeground()));
        chart.setTitle(chartData.getTitle());
        chart.setAntiAlias(chartData.isAntialias());
        if (chartData.getAlpha() < 100) {
            chart.getPlot().setForegroundAlpha((float)chartData.getAlpha() / 100.0f);
        }
    }

    public static JFreeChart createChartWithCategoryDataSet(ChartData chartData) {
        JFreeChart chart = null;
        PlotOrientation plotOrientation = ChartUtils.getPlotOrientation(chartData.getOrientation());
        CategoryDataset dataset = (CategoryDataset)chartData.getDatasource();
        String type = chartData.getType();
        String xAxis = chartData.getXlabel();
        String yAxis = chartData.getYlabel();
        boolean is3d = chartData.isChart3d();
        boolean legend = chartData.isLegend();
        if (type.equalsIgnoreCase("bar")) {
            chart = is3d ? ChartFactory.createBarChart3D((String)"", (String)xAxis, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false) : ChartFactory.createBarChart((String)"", (String)xAxis, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false);
            ChartUtils.setBarOutline(chart, chartData);
        } else if (type.equalsIgnoreCase("stackedbar")) {
            chart = is3d ? ChartFactory.createStackedBarChart3D((String)"", (String)xAxis, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false) : ChartFactory.createStackedBarChart((String)"", (String)xAxis, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false);
            ChartUtils.setBarOutline(chart, chartData);
        } else if (type.equalsIgnoreCase("line")) {
            chart = is3d ? ChartFactory.createLineChart3D((String)"", (String)xAxis, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false) : ChartFactory.createLineChart((String)"", (String)xAxis, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false);
        } else if (type.equalsIgnoreCase("area")) {
            chart = ChartFactory.createAreaChart((String)"", (String)xAxis, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false);
        } else if (type.equalsIgnoreCase("stackedarea")) {
            chart = ChartFactory.createStackedAreaChart((String)"", (String)xAxis, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false);
        } else if (type.equalsIgnoreCase("waterfall")) {
            chart = ChartFactory.createWaterfallChart((String)"", (String)xAxis, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false);
        } else if (type.equalsIgnoreCase("gantt")) {
            chart = ChartFactory.createGanttChart((String)"", (String)xAxis, (String)yAxis, (IntervalCategoryDataset)((IntervalCategoryDataset)dataset), (boolean)legend, (boolean)true, (boolean)false);
        }
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setDomainGridlinesVisible(chartData.isDomainGridLines());
        plot.setRangeGridlinesVisible(chartData.isRangeGridLines());
        if (chartData.getGenerateMap() != null) {
            plot.getRenderer().setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator(""));
        }
        int seriesCount = plot.getDataset().getColumnCount();
        if (chartData.getLineStokeWidth() > 0.0f) {
            for (int index = 0; index <= seriesCount; ++index) {
                plot.getRenderer().setSeriesStroke(index, (Stroke)new BasicStroke(chartData.getLineStokeWidth()));
            }
        }
        ChartUtils.setCategorySeriesColors(chart, chartData);
        ChartUtils.setCategoryExtensions(chart, chartData);
        return chart;
    }

    public static JFreeChart createChartWithPieDataSet(ChartData chartData) {
        PiePlot plot;
        PieDataset dataset = (PieDataset)chartData.getDatasource();
        String type = chartData.getType();
        boolean legend = chartData.isLegend();
        JFreeChart chart = null;
        if (type.equalsIgnoreCase("pie")) {
            if (chartData.isChart3d()) {
                chart = ChartFactory.createPieChart3D((String)"", (PieDataset)dataset, (boolean)legend, (boolean)true, (boolean)false);
                plot = (PiePlot3D)chart.getPlot();
                plot.setDepthFactor((double)((float)chartData.getDepth() / 100.0f));
            } else {
                chart = ChartFactory.createPieChart((String)"", (PieDataset)dataset, (boolean)legend, (boolean)true, (boolean)false);
            }
        } else if (type.equalsIgnoreCase("ring")) {
            chart = ChartFactory.createRingChart((String)"", (PieDataset)dataset, (boolean)legend, (boolean)true, (boolean)false);
        }
        plot = (PiePlot)chart.getPlot();
        plot.setStartAngle((double)chartData.getStartAngle());
        if (chartData.getGenerateMap() != null) {
            plot.setURLGenerator((PieURLGenerator)new StandardPieURLGenerator(""));
        }
        ChartUtils.setPieSectionColors(chart, chartData);
        return chart;
    }

    public static JFreeChart createChartWithXYDataSet(ChartData chartData) {
        XYDataset dataset = (XYDataset)chartData.getDatasource();
        String type = chartData.getType();
        String xAxis = chartData.getXlabel();
        String yAxis = chartData.getYlabel();
        boolean legend = chartData.isLegend();
        JFreeChart chart = null;
        PlotOrientation plotOrientation = ChartUtils.getPlotOrientation(chartData.getOrientation());
        if (type.equalsIgnoreCase("timeseries")) {
            chart = ChartFactory.createTimeSeriesChart((String)"", (String)xAxis, (String)yAxis, (XYDataset)dataset, (boolean)legend, (boolean)true, (boolean)false);
        } else if (type.equalsIgnoreCase("xyline")) {
            chart = ChartFactory.createXYLineChart((String)"", (String)xAxis, (String)yAxis, (XYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false);
        } else if (type.equalsIgnoreCase("polar")) {
            chart = ChartFactory.createPolarChart((String)"", (XYDataset)dataset, (boolean)legend, (boolean)true, (boolean)false);
        } else if (type.equalsIgnoreCase("scatter")) {
            chart = ChartFactory.createScatterPlot((String)"", (String)xAxis, (String)yAxis, (XYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false);
        } else if (type.equalsIgnoreCase("xyarea")) {
            chart = ChartFactory.createXYAreaChart((String)"", (String)xAxis, (String)yAxis, (XYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false);
        } else if (type.equalsIgnoreCase("xysteparea")) {
            chart = ChartFactory.createXYStepAreaChart((String)"", (String)xAxis, (String)yAxis, (XYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false);
        } else if (type.equalsIgnoreCase("xystep")) {
            chart = ChartFactory.createXYStepChart((String)"", (String)xAxis, (String)yAxis, (XYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false);
        } else if (type.equalsIgnoreCase("bubble")) {
            chart = ChartFactory.createBubbleChart((String)"", (String)xAxis, (String)yAxis, (XYZDataset)((XYZDataset)dataset), (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false);
        } else if (type.equalsIgnoreCase("candlestick")) {
            chart = ChartFactory.createCandlestickChart((String)"", (String)xAxis, (String)yAxis, (OHLCDataset)((OHLCDataset)dataset), (boolean)legend);
        } else if (type.equalsIgnoreCase("boxandwhisker")) {
            chart = ChartFactory.createBoxAndWhiskerChart((String)"", (String)xAxis, (String)yAxis, (BoxAndWhiskerXYDataset)((BoxAndWhiskerXYDataset)dataset), (boolean)legend);
        } else if (type.equalsIgnoreCase("highlow")) {
            chart = ChartFactory.createHighLowChart((String)"", (String)xAxis, (String)yAxis, (OHLCDataset)((OHLCDataset)dataset), (boolean)legend);
        } else if (type.equalsIgnoreCase("histogram")) {
            chart = ChartFactory.createHistogram((String)"", (String)xAxis, (String)yAxis, (IntervalXYDataset)((IntervalXYDataset)dataset), (PlotOrientation)plotOrientation, (boolean)legend, (boolean)true, (boolean)false);
        } else if (type.equalsIgnoreCase("wind")) {
            chart = ChartFactory.createWindPlot((String)"", (String)xAxis, (String)yAxis, (WindDataset)((WindDataset)dataset), (boolean)legend, (boolean)true, (boolean)false);
        } else {
            throw new IllegalArgumentException("Unknown charttype '" + type + "' for XYDataSet");
        }
        if (chart.getPlot() instanceof XYPlot) {
            chart.getXYPlot().setDomainGridlinesVisible(chartData.isDomainGridLines());
            chart.getXYPlot().setRangeGridlinesVisible(chartData.isRangeGridLines());
            if (chartData.getGenerateMap() != null) {
                chart.getXYPlot().getRenderer().setURLGenerator((XYURLGenerator)new StandardXYURLGenerator(""));
            }
        }
        ChartUtils.setXYSeriesColors(chart, chartData);
        ChartUtils.setXYExtensions(chart, chartData);
        return chart;
    }

    public static void setCategorySeriesColors(JFreeChart chart, ChartData chartData) {
        if (chart.getPlot() instanceof CategoryPlot) {
            CategoryPlot plot = (CategoryPlot)chart.getPlot();
            if (chartData.getColors() != null) {
                String[] colors = chartData.getColors().split(",");
                for (int i = 0; i < colors.length; ++i) {
                    plot.getRenderer().setSeriesPaint(i, (Paint)ChartUtils.getColor(colors[i].trim()));
                }
            }
        }
    }

    public static void setXYSeriesColors(JFreeChart chart, ChartData chartData) {
        if (chart.getPlot() instanceof XYPlot && chartData.getColors() != null) {
            XYPlot plot = (XYPlot)chart.getPlot();
            String[] colors = chartData.getColors().split(",");
            for (int i = 0; i < colors.length; ++i) {
                plot.getRenderer().setSeriesPaint(i, (Paint)ChartUtils.getColor(colors[i].trim()));
            }
        }
    }

    public static void setPieSectionColors(JFreeChart chart, ChartData chartData) {
        if (chartData.getColors() != null) {
            String[] colors = chartData.getColors().split(",");
            for (int i = 0; i < colors.length; ++i) {
                ((PiePlot)chart.getPlot()).setSectionPaint(i, (Paint)ChartUtils.getColor(colors[i].trim()));
            }
        }
    }

    public static void setBarOutline(JFreeChart chart, ChartData chartData) {
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        BarRenderer barrenderer = (BarRenderer)plot.getRenderer();
        barrenderer.setDrawBarOutline(chartData.isOutline());
    }

    public static void setXYExtensions(JFreeChart chart, ChartData chartData) {
        int axisIndex = 1;
        for (Object extension : chartData.getExtensions()) {
            if (!(extension instanceof ChartAxisData)) continue;
            ChartAxisData chartAxisData = (ChartAxisData)extension;
            ChartAxisUtils.createXYSeriesAxis(chart, chartAxisData, axisIndex);
            ++axisIndex;
        }
    }

    public static void setCategoryExtensions(JFreeChart chart, ChartData chartData) {
        int axisIndex = 1;
        for (Object extension : chartData.getExtensions()) {
            if (!(extension instanceof ChartAxisData)) continue;
            ChartAxisData chartAxisData = (ChartAxisData)extension;
            ChartAxisUtils.createCategorySeriesAxis(chart, chartAxisData, axisIndex);
            ++axisIndex;
        }
    }
}

