/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.maven.war;

import java.io.File;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.install.AbstractInstallMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public class WarMojo
extends AbstractInstallMojo {
    protected MavenProject project;
    private ArchiverManager archiverManager;
    protected File workDirectory;
    protected File artifactFile;
    protected Map<String, Artifact> artifactMap;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Creating WAR " + this.workDirectory.getName()));
        this.workDirectory.mkdirs();
        this.pack(this.workDirectory, this.artifactFile);
        this.project.getArtifact().setFile(this.artifactFile);
    }

    public void pack(File sourceDir, File dest) throws MojoExecutionException {
        try {
            Archiver archiver = this.archiverManager.getArchiver("zip");
            archiver.setDestFile(dest);
            archiver.addDirectory(sourceDir);
            this.addDependencies(archiver);
            archiver.createArchive();
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Error packing " + dest.getAbsolutePath(), exception);
        }
    }

    public void addDependencies(Archiver archiver) {
        for (Artifact dependency : this.project.getArtifacts()) {
            if (!"jar".equals(dependency.getType()) || !"compile".equals(dependency.getScope())) continue;
            String fileName = "WEB-INF/lib/" + dependency.getArtifactId() + "-" + dependency.getVersion() + "." + dependency.getType();
            if (dependency.getFile().isDirectory()) {
                archiver.addDirectory(dependency.getFile(), fileName);
                continue;
            }
            archiver.addFile(dependency.getFile(), fileName);
        }
    }
}

