/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.gateway;

import com.intersystems.gateway.ClassLoader;
import com.intersystems.gateway.JavaGateway;
import com.intersystems.jdbc.IRIS;
import com.intersystems.jdbc.IRISConnection;
import java.sql.SQLException;

public class GatewayContext {
    private static ThreadLocal<IRISConnection> connection = new ThreadLocal<IRISConnection>(){

        @Override
        protected IRISConnection initialValue() {
            return null;
        }
    };

    public static IRISConnection getConnection() throws SQLException {
        return GatewayContext.getConnection(true);
    }

    static IRISConnection getConnection(boolean initializeXDBC) throws SQLException {
        if (initializeXDBC && connection.get() != null && GatewayContext.connection.get().initializationRequiredForXDBC) {
            connection.get().initXDBCforGateway();
            GatewayContext.connection.get().initializationRequiredForXDBC = false;
        }
        return connection.get();
    }

    public static void setConnection(IRISConnection conn) {
        connection.set(conn);
    }

    public static ClassLoader getClassLoader() {
        try {
            return GatewayContext.getConnection(false).getGateway().getClassLoader();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static JavaGateway getGateway() {
        JavaGateway gateway = null;
        try {
            gateway = GatewayContext.getConnection(false).getGateway();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gateway;
    }

    public static IRIS getIRIS() {
        IRIS iris = null;
        try {
            iris = IRIS.createIRIS(connection.get());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return iris;
    }
}

