/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.gateway;

import com.intersystems.gateway.GatewayProcessExitHandler;
import com.intersystems.gateway.GatewayThreadExitHandler;
import java.util.Stack;

public class GatewayEvent {
    private static Stack<GatewayProcessExitHandler> process_exit_handlers = null;
    private static ThreadLocal<Stack<GatewayThreadExitHandler>> thread_exit_handlers = new ThreadLocal<Stack<GatewayThreadExitHandler>>(){

        @Override
        protected Stack<GatewayThreadExitHandler> initialValue() {
            return null;
        }
    };

    public static void registerHandler(GatewayProcessExitHandler handler) {
        if (process_exit_handlers == null) {
            process_exit_handlers = new Stack();
        }
        process_exit_handlers.push(handler);
    }

    public static void registerHandler(GatewayThreadExitHandler handler) {
        if (thread_exit_handlers.get() == null) {
            thread_exit_handlers.set(new Stack());
        }
        thread_exit_handlers.get().push(handler);
    }

    static void invokeGatewayProcessExitHandlers() {
        if (process_exit_handlers != null) {
            while (!process_exit_handlers.isEmpty()) {
                try {
                    GatewayProcessExitHandler handler = process_exit_handlers.pop();
                    handler.onProcessExit();
                }
                catch (Exception exception) {}
            }
        }
    }

    static void invokeGatewayThreadExitHandlers() {
        Stack<GatewayThreadExitHandler> this_thread_exit_handlers = thread_exit_handlers.get();
        if (this_thread_exit_handlers != null) {
            while (!this_thread_exit_handlers.isEmpty()) {
                try {
                    GatewayThreadExitHandler handler = this_thread_exit_handlers.pop();
                    handler.onThreadExit();
                }
                catch (Exception exception) {}
            }
        }
    }
}

