/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.gateway;

import com.intersystems.gateway.JavaGateway;
import com.intersystems.gateway.TypeMap;
import com.intersystems.util.XMLClassGenerator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Generator {
    public static final int MAX_METHOD_LENGTH = 200;
    private JavaGateway gateway;
    private XMLClassGenerator classGenerator;
    private Map<String, String> irisTypes;

    public Generator(JavaGateway g) {
        this.gateway = g;
        this.irisTypes = TypeMap.getIRISTypes();
        this.classGenerator = new XMLClassGenerator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean generate(String className, int sequenceNumber) throws Exception {
        String unqualifiedClassName;
        String packageName;
        int i;
        if (this.gateway.alreadyGenerated.containsKey(className)) {
            return false;
        }
        if (this.gateway.exclude(className)) {
            return false;
        }
        Class<?> clazz = this.gateway.loadClass(className);
        int modifier = clazz.getModifiers();
        if (!Modifier.isPublic(modifier) || className.indexOf("$") != -1 && clazz.getDeclaringClass() != null && !Modifier.isStatic(modifier)) {
            return false;
        }
        this.gateway.alreadyGenerated.put(className, className);
        this.gateway.log(" <<>> Generating: " + className);
        Constructor<?>[] allConstructors = clazz.getDeclaredConstructors();
        Field[] allProperties = clazz.getDeclaredFields();
        ArrayList<Field> properties = new ArrayList<Field>();
        ArrayList<Member> constructors = new ArrayList<Member>();
        ArrayList<Field> constants = new ArrayList<Field>();
        HashMap<String, String> addedMethods = new HashMap<String, String>();
        Object classDef = null;
        Class<?> superClass = clazz.getSuperclass();
        String superClassName = null;
        if (superClass != null) {
            superClassName = superClass.getName();
            if (!this.gateway.exclude(superClassName) && Modifier.isPublic(superClass.getModifiers())) {
                this.generate(superClassName, sequenceNumber);
            } else {
                superClassName = null;
            }
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        ArrayList<String> superInterfaceNames = new ArrayList<String>();
        for (i = 0; i < interfaces.length; ++i) {
            String current = interfaces[i].getName();
            if (!Modifier.isPublic(interfaces[i].getModifiers()) || current.equals("java.lang.Runnable") || this.gateway.exclude(current)) continue;
            this.generate(current, sequenceNumber);
            superInterfaceNames.add(current);
            if (superClass == null || !superClass.isAssignableFrom(interfaces[i])) continue;
            superClassName = null;
        }
        Package pack = clazz.getPackage();
        if (pack != null) {
            packageName = pack.getName();
            unqualifiedClassName = className.substring(packageName.length() + 1);
        } else {
            packageName = null;
            unqualifiedClassName = className;
        }
        List<String> dependentTypes = this.gateway.getDependencies(clazz);
        for (i = 0; i < dependentTypes.size(); ++i) {
            String dt = dependentTypes.get(i);
            if (this.irisTypes.containsKey(dt)) continue;
            this.irisTypes.put(dt, dt);
        }
        for (i = 0; i < dependentTypes.size(); ++i) {
            this.generate(dependentTypes.get(i), sequenceNumber);
        }
        ArrayList superInterfaceClasses = new ArrayList();
        for (int si = 0; si < superInterfaceNames.size(); ++si) {
            superInterfaceClasses.add(this.gateway.loadClass((String)superInterfaceNames.get(si)));
        }
        for (i = 0; i < allProperties.length; ++i) {
            modifier = allProperties[i].getModifiers();
            if (!Modifier.isPublic(modifier) || !Modifier.isPublic(allProperties[i].getType().getModifiers())) continue;
            if (Modifier.isFinal(modifier) && Modifier.isStatic(modifier)) {
                constants.add(allProperties[i]);
                continue;
            }
            properties.add(allProperties[i]);
        }
        for (i = 0; i < allConstructors.length; ++i) {
            modifier = allConstructors[i].getModifiers();
            if (!Modifier.isPublic(modifier)) continue;
            constructors.add(allConstructors[i]);
        }
        String timestamp = this.gateway.upToDate(className, unqualifiedClassName, sequenceNumber);
        if (timestamp == null) {
            return false;
        }
        classDef = this.classGenerator.createEmptyClass(TypeMap.getIRISClassName(className));
        this.classGenerator.useProcedureBlock(classDef, true);
        this.classGenerator.createParameter(classDef, "IMPORTTIMESTAMP", timestamp);
        XMLClassGenerator xMLClassGenerator = this.classGenerator;
        synchronized (xMLClassGenerator) {
            String name;
            Field property;
            if (classDef != null) {
                this.generateSuper(superClassName, superInterfaceNames, classDef);
                if (!constructors.isEmpty()) {
                    this.generateConstructorCode(classDef, constructors, className);
                }
                this.gateway.log(" <<>> Imported constructor: " + unqualifiedClassName);
            }
            Method[] allMethods = clazz.getMethods();
            Method[] allDeclaredMethods = clazz.getDeclaredMethods();
            HashSet<String> methodSet = new HashSet<String>();
            for (i = 0; i < allDeclaredMethods.length; ++i) {
                if (!Modifier.isPublic(allDeclaredMethods[i].getModifiers())) continue;
                boolean skipMethod = false;
                Class<?>[] parameterTypes = allDeclaredMethods[i].getParameterTypes();
                for (int p = 0; p < parameterTypes.length; ++p) {
                    if (Modifier.isPublic(parameterTypes[p].getModifiers())) continue;
                    skipMethod = true;
                    break;
                }
                if (skipMethod) continue;
                methodSet.add(allDeclaredMethods[i].getName());
            }
            Object[] mArray = methodSet.toArray();
            for (i = 0; i < mArray.length; ++i) {
                Method mostGeneric;
                String cosProxyMethodName;
                String methodName = (String)mArray[i];
                List<Method> overloads = this.getAllOverloads(methodName, allMethods);
                if (overloads.size() == 1) {
                    cosProxyMethodName = this.resolveName(addedMethods, methodName, clazz);
                    if (cosProxyMethodName == null || classDef == null) continue;
                    this.generateMethod(classDef, cosProxyMethodName, overloads.get(0), className);
                    this.gateway.log(" <<>> Imported: " + methodName + " as " + cosProxyMethodName);
                    addedMethods.put(methodName, cosProxyMethodName);
                    continue;
                }
                boolean returns = !overloads.get(0).getReturnType().getName().equals("void");
                boolean staticOverload = Modifier.isStatic(overloads.get(0).getModifiers());
                boolean skipOverload = false;
                for (int k = 1; k < overloads.size(); ++k) {
                    Method currentOverload = overloads.get(k);
                    if (!returns) {
                        boolean bl = returns = !currentOverload.getReturnType().getName().equals("void");
                    }
                    if (Modifier.isStatic(currentOverload.getModifiers()) == staticOverload) continue;
                    this.gateway.log(" <<>> WARNING: Unable to import method: " + currentOverload.getName() + ". Unable tooverride an instance method with a class method (or viceversa)");
                    skipOverload = true;
                    break;
                }
                if (skipOverload || (mostGeneric = this.getMostGeneric(overloads, clazz)) == null) continue;
                for (int j = 0; j < allMethods.length; ++j) {
                    if (!mostGeneric.equals(allMethods[j]) || (cosProxyMethodName = this.resolveName(addedMethods, methodName, clazz)) == null) continue;
                    this.generateOverloadedMethod(classDef, className, mostGeneric, cosProxyMethodName, returns);
                    this.gateway.log(" <<>> Imported: " + methodName + " as " + cosProxyMethodName);
                    addedMethods.put(methodName, cosProxyMethodName);
                }
            }
            for (i = 0; i < properties.size(); ++i) {
                property = (Field)properties.get(i);
                boolean isStatic = Modifier.isStatic(property.getModifiers());
                String propertyName = property.getName();
                name = TypeMap.getIRISPropertyName(propertyName);
                boolean skipProperty = false;
                for (int j = 0; j < properties.size(); ++j) {
                    if (i == j || !name.equalsIgnoreCase(TypeMap.getIRISPropertyName(((Field)properties.get(j)).getName()))) continue;
                    skipProperty = true;
                }
                if (skipProperty) continue;
                String type = this.getIRISType(TypeMap.getIRISPropertyName(property.getType().getName()));
                if (this.noGetSetterDefined(addedMethods, "set" + name)) {
                    if (classDef != null) {
                        this.generateSetter(classDef, name, property.getType(), isStatic, className, propertyName);
                    }
                    this.gateway.log(" <<>> Generated setter for: " + propertyName);
                } else {
                    this.gateway.log(" <<>> Skipped setter for: " + propertyName);
                }
                if (this.noGetSetterDefined(addedMethods, "get" + name)) {
                    if (classDef != null) {
                        this.generateGetter(classDef, name, type, isStatic, className, propertyName);
                    }
                    this.gateway.log(" <<>> Generated getter for: " + propertyName);
                    continue;
                }
                this.gateway.log(" <<>> Skipped getter for: " + propertyName);
            }
            for (i = 0; i < constants.size(); ++i) {
                property = (Field)constants.get(i);
                name = property.getName();
                name = TypeMap.getIRISPropertyName(name);
                boolean skipConstant = false;
                for (int j = 0; j < constants.size(); ++j) {
                    if (i == j || !name.equalsIgnoreCase(TypeMap.getIRISPropertyName(((Field)constants.get(j)).getName()))) continue;
                    skipConstant = true;
                    break;
                }
                if (skipConstant) {
                    this.gateway.log(" <<>> WARNING: Unable to import property: " + property.getName() + ". Property with the same name but  different case sensitivity already exists");
                    continue;
                }
                if (name.length() > 197) {
                    this.gateway.log(" <<>> WARNING: Unable to import property: " + property.getName() + ". Property name is longer than " + 197 + " characters");
                    continue;
                }
                Object pValue = property.get(clazz);
                if (pValue instanceof Character && !Character.isDefined(((Character)pValue).charValue())) {
                    this.gateway.log(" <<>> WARNING: Unable to import constant: " + property.getName() + ". Contains illegal characters ");
                    continue;
                }
                String constValue = pValue == null ? "" : pValue.toString();
                String constantType = property.getType().getName();
                if (classDef == null) continue;
                if (constantType.equals("int") || constantType.equals("short")) {
                    this.classGenerator.createParameter(classDef, name, new Integer(constValue));
                    continue;
                }
                if (constantType.equals("boolean")) {
                    if (constValue.equals("true")) {
                        this.classGenerator.createParameter(classDef, name, true);
                        continue;
                    }
                    this.classGenerator.createParameter(classDef, name, false);
                    continue;
                }
                if (constValue == null || constValue.equals("")) {
                    constValue = null;
                }
                this.classGenerator.createParameter(classDef, name, constValue);
            }
            if (classDef != null) {
                this.gateway.loadCOSClass(className, TypeMap.getIRISClassName(className), this.classGenerator.saveAsString(classDef));
            }
        }
        return true;
    }

    private Method getMostGeneric(List<Method> overloads, Class<?> currentClass) {
        if (overloads.size() == 2) {
            Method method1 = overloads.get(0);
            Method method2 = overloads.get(1);
            if (method1.getDeclaringClass() != method2.getDeclaringClass()) {
                if (method1.getParameterTypes().length > method1.getParameterTypes().length) {
                    return method1;
                }
                return method2;
            }
        }
        Method most = overloads.get(0);
        int mostParameterCount = most.getParameterTypes().length;
        String mostReturnType = most.getReturnType().getName();
        for (int i = 1; i < overloads.size(); ++i) {
            Method current = overloads.get(i);
            int currentParameterCount = current.getParameterTypes().length;
            String currentReturnType = current.getReturnType().getName();
            if (currentParameterCount > mostParameterCount || currentParameterCount == mostParameterCount && mostReturnType.equals("void") && !currentReturnType.equals("void")) {
                most = current;
                mostReturnType = currentReturnType;
                mostParameterCount = currentParameterCount;
                continue;
            }
            if (currentParameterCount != mostParameterCount || (!mostReturnType.equals("void") || !currentReturnType.equals("void")) && (mostReturnType.equals("void") || currentReturnType.equals("void")) || most.getDeclaringClass() == currentClass && current.getDeclaringClass() == currentClass) continue;
            return null;
        }
        return most;
    }

    private List<Method> getAllOverloads(String methodName, Method[] methods) {
        ArrayList<Method> overloads = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            overloads.add(methods[i]);
        }
        return overloads;
    }

    private void generateSuper(String superClassName, List<String> superInterfaceNames, Object classDef) throws Exception {
        if (superClassName == null && superInterfaceNames.isEmpty()) {
            this.classGenerator.addSuper(classDef, "%Net.Remote.Proxy");
        } else {
            String supers = "";
            if (superClassName != null) {
                supers = TypeMap.getIRISClassName(superClassName);
            }
            for (int i = 0; i < superInterfaceNames.size(); ++i) {
                if (!supers.equals("")) {
                    supers = supers + ",";
                }
                supers = supers + TypeMap.getIRISClassName(superInterfaceNames.get(i));
            }
            this.classGenerator.addSuper(classDef, supers);
        }
    }

    private void getAllConstructors(String className, List<Member> constructors) throws Exception {
        Class<?> superClass = this.gateway.loadClass(className);
        if (superClass == null) {
            return;
        }
        Constructor<?>[] cons = superClass.getConstructors();
        constructors.addAll(Arrays.asList(cons));
        if (superClass.getName().equals("java.lang.Object")) {
            return;
        }
        this.getAllConstructors(superClass.getSuperclass().getName(), constructors);
    }

    private void generateConstructorCode(Object classDef, List<Member> constructors, String className) throws Exception {
        Object mth = this.classGenerator.createMethod(classDef, "%OnNew");
        this.classGenerator.defineReturnType(mth, "%Status");
        this.getAllConstructors(className, constructors);
        Constructor constructor = (Constructor)constructors.get(0);
        int cardinality = 0;
        for (int i = 0; i < constructors.size(); ++i) {
            int car = ((Constructor)constructors.get(i)).getParameterTypes().length;
            if (cardinality >= car) continue;
            cardinality = car;
            constructor = (Constructor)constructors.get(i);
        }
        Class<?>[] params = constructor.getParameterTypes();
        this.generateParameters(mth, params.length + 1);
        this.classGenerator.defineBody(mth, this.generateConstructorBody(className, cardinality));
    }

    private void generateOverloadedMethod(Object classDef, String className, Method method, String name, boolean returns) throws Exception {
        Object mth = this.classGenerator.createMethod(classDef, name);
        boolean isStatic = false;
        if (Modifier.isStatic(method.getModifiers())) {
            isStatic = true;
            this.classGenerator.defineIsStatic(mth, true);
        }
        String irisReturnType = null;
        if (returns) {
            irisReturnType = "%ObjectHandle";
            this.classGenerator.defineReturnType(mth, "%ObjectHandle");
        }
        int cardinality = method.getParameterTypes().length;
        if (isStatic) {
            ++cardinality;
        }
        this.generateParameters(mth, cardinality);
        this.classGenerator.defineBody(mth, this.generateOverloadedBody(isStatic, false, cardinality, irisReturnType, className, method.getName()));
    }

    private void generateMethod(Object classDef, String cosName, Method method, String className) throws Exception {
        ArrayList<String> commentText = new ArrayList<String>();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            commentText.add("p" + i + ": " + method.getParameterTypes()[i]);
        }
        if (commentText.size() > 0) {
            classDef = this.classGenerator.createComment(classDef, commentText);
        }
        Object mth = this.classGenerator.createMethod(classDef, cosName);
        boolean isStatic = false;
        if (Modifier.isStatic(method.getModifiers())) {
            isStatic = true;
            this.classGenerator.defineIsStatic(mth, true);
        }
        String returnType = method.getReturnType().getName();
        String irisReturnType = null;
        if (!returnType.equals("void")) {
            irisReturnType = "%ObjectHandle";
            this.classGenerator.defineReturnType(mth, "%ObjectHandle");
        }
        if (isStatic) {
            this.generateParameters(mth, method.getParameterTypes().length + 1);
        } else {
            this.generateParameters(mth, method.getParameterTypes().length);
        }
        this.classGenerator.defineBody(mth, this.generateBody(isStatic, irisReturnType, method.getParameterTypes(), className, method.getName()));
    }

    private String resolveName(Map<String, String> methodMap, String methodName, Class<?> clazz) throws Exception {
        Method[] allMethods = clazz.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            if (!methodName.equalsIgnoreCase(allMethods[i].getName()) || methodName.equals(allMethods[i].getName())) continue;
            this.gateway.log(" <<>> WARNING: Unable to import method: " + methodName + ". Method name is longer than " + 200 + " characters and the same prefix (first " + 200 + " characters) is already used");
            return null;
        }
        String name = TypeMap.getIRISPropertyName(methodName);
        if (name.length() > 200) {
            this.gateway.log(" <<>> WARNING: method " + name + " name will be truncated");
            name = name.substring(0, 200);
            if (methodMap.containsValue(name)) {
                this.gateway.log(" <<>> WARNING: Unable to import method: " + methodName + ". Method name is longer than " + 200 + " characters and the same prefix (first " + 200 + " characters) is already used");
                return null;
            }
            return name;
        }
        for (String key : methodMap.keySet()) {
            String currentName = methodMap.get(key);
            if (!currentName.equalsIgnoreCase(name)) continue;
            if (!currentName.equals(name)) {
                this.gateway.log(" <<>> WARNING: Unable to import method: " + methodName + " method with the same name, but different  case-sensitivity already exists: " + currentName);
            }
            return null;
        }
        return name;
    }

    private boolean noGetSetterDefined(Map<String, String> methods, String etter) {
        for (String key : methods.keySet()) {
            if (!etter.equalsIgnoreCase(methods.get(key)) && etter.length() <= 200) continue;
            return false;
        }
        return true;
    }

    private void generateSetter(Object classDef, String propertyName, Class<?> javaType, boolean isStatic, String className, String originalName) throws Exception {
        String body;
        String[] names;
        String[] types;
        Object mth = this.classGenerator.createMethod(classDef, "set" + propertyName);
        if (isStatic) {
            types = new String[]{"%ObjectHandle", "%ObjectHandle"};
            names = new String[]{"p0", "p1"};
            this.classGenerator.defineIsStatic(mth, true);
            body = "\tDo ..%SetStatic(p0,\"set" + originalName + "\",p1,\"" + className + "\"";
        } else {
            types = new String[]{"%ObjectHandle"};
            names = new String[]{"p1"};
            body = "\tDo ..%Set(\"set" + originalName + "\",p1";
        }
        body = javaType.isArray() ? body + ",\"" + javaType.getName() + "\")\r\n" : body + ")\r\n";
        this.classGenerator.defineArguments(mth, types, names);
        this.classGenerator.defineBody(mth, body);
    }

    private void generateGetter(Object classDef, String propertyName, String propertyType, boolean isStatic, String className, String originalName) throws Exception {
        String body;
        Object mth = this.classGenerator.createMethod(classDef, "get" + propertyName);
        this.classGenerator.defineReturnType(mth, propertyType);
        if (isStatic) {
            String[] types = new String[]{"%ObjectHandle"};
            String[] names = new String[]{"p"};
            this.classGenerator.defineArguments(mth, types, names);
            this.classGenerator.defineIsStatic(mth, true);
            body = "\tQuit ..%GetStatic(p,\"get" + originalName + "\",\"" + className + "\")\r\n";
        } else {
            body = "\tQuit ..%Get(\"get" + originalName + "\")\r\n";
        }
        this.classGenerator.defineBody(mth, body);
    }

    private void generateParameters(Object mth, int count) throws Exception {
        String[] parameterTypes = new String[count];
        String[] parameterNames = new String[count];
        boolean[] byRef = new boolean[count];
        if (count != 0) {
            for (int i = 0; i < count; ++i) {
                parameterTypes[i] = "%ObjectHandle";
                parameterNames[i] = "p" + i;
                byRef[i] = true;
            }
            this.classGenerator.defineArguments(mth, parameterTypes, parameterNames, byRef, null);
        }
    }

    private String generateOverloadedBody(boolean isStatic, boolean isConstructor, int cardinality, String returnType, String javaType, String methodName) {
        String device;
        int k;
        if (isConstructor) {
            return this.generateConstructorBody(methodName, cardinality);
        }
        StringBuffer buf = new StringBuffer();
        if (isStatic && cardinality <= 5) {
            return this.generateOverloadBodyTemplate(buf, true, returnType != null, cardinality - 1, javaType, methodName);
        }
        if (!isStatic && cardinality <= 4) {
            return this.generateOverloadBodyTemplate(buf, false, returnType != null, cardinality, javaType, methodName);
        }
        int firstParameterIndex = 0;
        if (isStatic) {
            firstParameterIndex = 1;
        }
        String x = "";
        for (k = firstParameterIndex; k < cardinality; ++k) {
            x = x + "$D(p" + k + ")+";
        }
        x = cardinality - firstParameterIndex != 0 ? x.substring(0, x.length() - 1) : "0";
        if (isStatic) {
            device = "p0";
            buf.append("\tDo ..%PreInvokeStatic(p0,\"").append(javaType).append("\")\r\n");
        } else {
            device = "..Gateway";
            buf.append("\tDo ..%PreInvoke()\r\n");
        }
        buf.append("\tSet x=$zobjexport(\"").append(methodName).append("\",18)\r\n");
        buf.append("\tSet x=$zobjexport(").append(x).append(",18)\r\n");
        for (k = firstParameterIndex; k < cardinality; ++k) {
            buf.append("\tDo:$D(p").append(k).append(") ..%OverloadWrite(").append(device).append(",p").append(k).append(")\r\n");
        }
        if (returnType == null) {
            buf.append("\tSet x=$zobjexport(\"Y1\",8)\r\n");
            buf.append("\tSet id=$zobjexport(9),fun=$zobjexport(15)\r\n");
            if (isStatic) {
                buf.append("\tDo:fun'=\"Y1\" ..%ProcessErrorStatic(p0,fun,id)\r\n");
            } else {
                buf.append("\tDo:fun'=\"Y1\" ..%ProcessError(fun,id)\r\n");
            }
            for (k = firstParameterIndex; k < cardinality; ++k) {
                buf.append("\tIf $D(p").append(k).append(") Set:$zobjexport(17) p").append(k).append("=..%ReadArrayArgument(").append(device).append(")\r\n");
            }
            if (isStatic) {
                buf.append("\tDo:fun'=\"Y5\" ..%PostInvokeStatic(p0)\r\n");
            } else {
                buf.append("\tDo:fun'=\"Y5\" ..%PostInvoke()\r\n");
            }
        } else {
            buf.append("\tSet x=..%GetObject(").append(device).append(")\r\n");
            for (k = firstParameterIndex; k < cardinality; ++k) {
                buf.append("\tIf $D(p").append(k).append(") Set:$zobjexport(17) p").append(k).append("=..%ReadArrayArgument(").append(device).append(")\r\n");
            }
            if (isStatic) {
                buf.append("\tDo ..%PostInvokeStatic(p0)\r\n");
            } else {
                buf.append("\tDo ..%PostInvoke()\r\n");
            }
            buf.append("\tQuit x\r\n");
        }
        return buf.toString();
    }

    private String generateConstructorBody(String name, int cardinality) {
        String buf = "\tQuit:'$D(p0) $$$OK\r\n";
        for (int i = cardinality; i >= 1; --i) {
            buf = buf + "\tQuit:$D(p" + i + ") ..%Constructor(p0,\"" + name + "\"," + i;
            for (int j = 1; j <= i; ++j) {
                buf = buf + ",p" + j;
            }
            buf = buf + ")\r\n";
        }
        buf = buf + "\tQuit ..%Constructor(p0,\"" + name + "\",0)";
        return buf;
    }

    private String generateBody(boolean isStatic, String returnType, Class<?>[] paramTypes, String javaType, String originalName) {
        String device;
        int j;
        StringBuffer buf = new StringBuffer();
        if (paramTypes.length <= 5) {
            boolean useTemplate = true;
            for (j = 0; j < paramTypes.length; ++j) {
                if (!paramTypes[j].isArray()) continue;
                useTemplate = false;
                break;
            }
            if (useTemplate) {
                if (!isStatic) {
                    return this.generateBodyTemplateInstance(buf, returnType != null, paramTypes.length, originalName);
                }
                return this.generateBodyTemplateStatic(buf, returnType != null, paramTypes.length, javaType, originalName);
            }
        }
        int fpi = 0;
        if (isStatic) {
            fpi = 1;
            device = "p0";
            buf.append("\tDo ..%PreInvokeStatic(p0,\"").append(javaType).append("\")\r\n");
        } else {
            device = "..Gateway";
            buf.append("\tDo ..%PreInvoke()\r\n");
        }
        buf.append("\tSet x=$zobjexport(\"").append(originalName).append("\",18)\r\n");
        buf.append("\tSet x=$zobjexport(-1,18)\r\n");
        for (j = 0; j < paramTypes.length; ++j) {
            if (paramTypes[j].isArray()) {
                buf.append("\tDo ..%WriteArray(").append(device).append(",\"").append(paramTypes[j].getName()).append("\",p").append(j + fpi).append(")\r\n");
                continue;
            }
            buf.append("\tSet x=$zobjexport(p").append(j + fpi).append(",18)\r\n");
        }
        if (returnType == null) {
            buf.append("\tSet x=$zobjexport(\"Y1\",8)\r\n");
            buf.append("\tSet id=$zobjexport(9),fun=$zobjexport(15)\r\n");
            if (isStatic) {
                buf.append("\tDo:fun'=\"Y1\" ..%ProcessErrorStatic(p0,fun,id)\r\n");
            } else {
                buf.append("\tDo:fun'=\"Y1\" ..%ProcessError(fun,id)\r\n");
            }
            for (j = 0; j < paramTypes.length; ++j) {
                buf.append("\tSet:$zobjexport(17) p").append(j + fpi).append("=..%ReadArrayArgument(").append(device).append(")\r\n");
            }
            if (isStatic) {
                buf.append("\tDo:fun'=\"Y5\" ..%PostInvokeStatic(p0)\r\n");
            } else {
                buf.append("\tDo:fun'=\"Y5\" ..%PostInvoke()\r\n");
            }
        } else {
            buf.append("\tSet x=..%GetObject(").append(device).append(")\r\n");
            for (j = 0; j < paramTypes.length; ++j) {
                buf.append("\tSet:$zobjexport(17) p").append(j + fpi).append("=..%ReadArrayArgument(").append(device).append(")\r\n");
            }
            if (isStatic) {
                buf.append("\tDo ..%PostInvokeStatic(p0)\r\n");
            } else {
                buf.append("\tDo ..%PostInvoke()\r\n");
            }
            buf.append("\tQuit x\r\n");
        }
        return buf.toString();
    }

    private String generateBodyTemplateInstance(StringBuffer buf, boolean returns, int paramCount, String name) {
        if (returns) {
            buf.append("\tQuit ..%IR(\"").append(name).append("\"");
        } else {
            buf.append("\tDo ..%I(\"").append(name).append("\"");
        }
        switch (paramCount) {
            case 1: {
                buf.append(",.p0");
                break;
            }
            case 2: {
                buf.append(",.p0,.p1");
                break;
            }
            case 3: {
                buf.append(",.p0,.p1,.p2");
                break;
            }
            case 4: {
                buf.append(",.p0,.p1,.p2,.p3");
                break;
            }
            case 5: {
                buf.append(",.p0,.p1,.p2,.p3,.p4");
                break;
            }
        }
        buf.append(")\r\n");
        return buf.toString();
    }

    private String generateBodyTemplateStatic(StringBuffer buf, boolean returns, int paramCount, String javaType, String name) {
        if (returns) {
            buf.append("\tQuit ..%SR(p0,\"").append(name).append("\",\"").append(javaType).append("\"");
        } else {
            buf.append("\tDo ..%S(p0,\"").append(name).append("\",\"").append(javaType).append("\"");
        }
        switch (paramCount) {
            case 1: {
                buf.append(",.p1");
                break;
            }
            case 2: {
                buf.append(",.p1,.p2");
                break;
            }
            case 3: {
                buf.append(",.p1,.p2,.p3");
                break;
            }
            case 4: {
                buf.append(",.p1,.p2,.p3,.p4");
                break;
            }
            case 5: {
                buf.append(",.p1,.p2,.p3,.p4,.p5");
                break;
            }
        }
        buf.append(")\r\n");
        return buf.toString();
    }

    private String generateOverloadBodyTemplate(StringBuffer buf, boolean isStatic, boolean returns, int paramCount, String javaType, String name) {
        String staticS;
        String par5;
        String par4;
        String par3;
        String par2;
        String par1;
        String temp;
        if (isStatic) {
            temp = "(p0,\"" + name + "\",\"" + javaType + "\"";
            par1 = "p1";
            par2 = "p2";
            par3 = "p3";
            par4 = "p4";
            par5 = "p5";
            staticS = "SOL";
        } else {
            temp = "(\"" + name + "\"";
            par1 = "p0";
            par2 = "p1";
            par3 = "p2";
            par4 = "p3";
            par5 = "p4";
            staticS = "IOL";
        }
        if (returns) {
            staticS = staticS + "R";
        }
        temp = staticS + temp;
        if (paramCount == 5) {
            if (returns) {
                buf.append("\tQuit:$D(").append(par4).append(") ..%").append(temp).append(",.").append(par1).append(",.").append(par2).append(",.").append(par3).append(",.").append(par4).append(",.").append(par5).append(")\r\n");
            } else {
                buf.append("\tIf $D(").append(par4).append(") Do ..%").append(temp).append(",.").append(par1).append(",.").append(par2).append(",.").append(par3).append(",.").append(par4).append(",.").append(par5).append(") Quit\r\n");
            }
        }
        if (paramCount >= 4) {
            if (returns) {
                buf.append("\tQuit:$D(").append(par4).append(") ..%").append(temp).append(",.").append(par1).append(",.").append(par2).append(",.").append(par3).append(",.").append(par4).append(")\r\n");
            } else {
                buf.append("\tIf $D(").append(par4).append(") Do ..%").append(temp).append(",.").append(par1).append(",").append(par2).append(",.").append(par3).append(",.").append(par4).append(") Quit\r\n");
            }
        }
        if (paramCount >= 3) {
            if (returns) {
                buf.append("\tQuit:$D(").append(par3).append(") ..%").append(temp).append(",.").append(par1).append(",.").append(par2).append(",.").append(par3).append(")\r\n");
            } else {
                buf.append("\tIf $D(").append(par3).append(") Do ..%").append(temp).append(",.").append(par1).append(",.").append(par2).append(",.").append(par3).append(") Quit\r\n");
            }
        }
        if (paramCount >= 2) {
            if (returns) {
                buf.append("\tQuit:$D(").append(par2).append(") ..%").append(temp).append(",.").append(par1).append(",.").append(par2).append(")\r\n");
            } else {
                buf.append("\tIf $D(").append(par2).append(") Do ..%").append(temp).append(",.").append(par1).append(",.").append(par2).append(") Quit\r\n");
            }
        }
        if (paramCount >= 1) {
            if (returns) {
                buf.append("\tQuit:$D(").append(par1).append(") ..%").append(temp).append(",.").append(par1).append(")\r\n");
            } else {
                buf.append("\tIf $D(").append(par1).append(") Do ..%").append(temp).append(",.").append(par1).append(") Quit\r\n");
            }
        }
        if (returns) {
            buf.append("\tQuit ..%").append(temp).append(")\r\n");
        } else {
            buf.append("\tDo ..%").append(temp).append(") Quit\r\n");
        }
        return buf.toString();
    }

    private String getIRISType(String javaType) {
        if (javaType.startsWith("[[")) {
            return "%ListOfObjects";
        }
        String t = this.irisTypes.get(javaType);
        if (t == null) {
            return "%ObjectHandle";
        }
        return t;
    }
}

