/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.gateway;

import com.intersystems.gateway.GatewayContext;
import com.intersystems.jdbc.IRIS;
import java.io.PrintStream;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

class JGPrintStream
extends PrintStream {
    public static ConcurrentHashMap<Long, StringBuffer> hmap = new ConcurrentHashMap();

    public void register() {
        Long threadNo = Thread.currentThread().getId();
        StringBuffer out = new StringBuffer();
        hmap.put(threadNo, out);
    }

    public StringBuffer getOutBuffer() {
        Long threadNo = Thread.currentThread().getId();
        StringBuffer pOut = hmap.get(threadNo);
        return pOut;
    }

    JGPrintStream(PrintStream p) {
        super(p);
    }

    protected boolean wasWrittenTo() {
        StringBuffer outputBuffer = this.getOutBuffer();
        if (outputBuffer != null) {
            return outputBuffer.length() != 0;
        }
        return false;
    }

    protected String getBufferContents() {
        StringBuffer outputBuffer = this.getOutBuffer();
        String str = outputBuffer.toString();
        this.emptyBuffer();
        return str;
    }

    protected void emptyBuffer() {
        Long threadNo = Thread.currentThread().getId();
        hmap.remove(threadNo);
        this.register();
    }

    @Override
    public void print(String s) {
        this._print(String.valueOf(s), false);
    }

    @Override
    public void println(String s) {
        this._print(String.valueOf(s), true);
    }

    @Override
    public void print(boolean b) {
        this._print(String.valueOf(b), false);
    }

    @Override
    public void println(boolean b) {
        this._print(String.valueOf(b), true);
    }

    @Override
    public void print(char c) {
        this._print(String.valueOf(c), false);
    }

    @Override
    public void println(char c) {
        this._print(String.valueOf(c), true);
    }

    @Override
    public void print(char[] s) {
        this._print(String.valueOf(s), false);
    }

    @Override
    public void println(char[] s) {
        this._print(String.valueOf(s), true);
    }

    @Override
    public void print(double d) {
        this._print(String.valueOf(d), false);
    }

    @Override
    public void println(double d) {
        this._print(String.valueOf(d), true);
    }

    @Override
    public void print(float f) {
        this._print(String.valueOf(f), false);
    }

    @Override
    public void println(float f) {
        this._print(String.valueOf(f), true);
    }

    @Override
    public void print(int i) {
        this._print(String.valueOf(i), false);
    }

    @Override
    public void println(int i) {
        this._print(String.valueOf(i), true);
    }

    @Override
    public void print(long l) {
        this._print(String.valueOf(l), false);
    }

    @Override
    public void println(long l) {
        this._print(String.valueOf(l), true);
    }

    @Override
    public void print(Object obj) {
        this._print(String.valueOf(obj), false);
    }

    @Override
    public void println(Object obj) {
        this._print(String.valueOf(obj), true);
    }

    @Override
    public void println() {
        this._print("", true);
    }

    public void _print(String str, boolean addCRLF) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(str);
        StringBuffer outputBuffer = this.getOutBuffer();
        if (outputBuffer == null) {
            PrintStream originalOutputStream = (PrintStream)this.out;
            if (addCRLF) {
                originalOutputStream.println(str);
            } else {
                originalOutputStream.print(str);
            }
            return;
        }
        try {
            IRIS iris = GatewayContext.getIRIS();
            if (addCRLF) {
                iris.classMethodVoid("%Net.Remote.Gateway", "%WriteOutput", buffer.toString(), "\r\n");
            } else {
                iris.classMethodVoid("%Net.Remote.Gateway", "%WriteOutput", buffer.toString());
            }
            return;
        }
        catch (Exception exception) {
            outputBuffer.append(str);
            if (addCRLF) {
                outputBuffer.append('\r');
                outputBuffer.append('\n');
            }
            return;
        }
    }

    public void unregister() {
        Long threadNo = Thread.currentThread().getId();
        hmap.remove(threadNo);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        byte[] b = new byte[len];
        System.arraycopy(buf, off, b, 0, len);
        this.print(new String(b));
    }

    @Override
    public void write(int b) {
        byte[] ba = new byte[]{(byte)b};
        this.print(new String(ba));
    }

    @Override
    public PrintStream append(char c) {
        StringBuffer outputBuffer = this.getOutBuffer();
        if (outputBuffer == null) {
            PrintStream originalOutputStream = (PrintStream)this.out;
            return originalOutputStream.append(c);
        }
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq) {
        StringBuffer outputBuffer = this.getOutBuffer();
        if (outputBuffer == null) {
            PrintStream originalOutputStream = (PrintStream)this.out;
            return originalOutputStream.append(csq);
        }
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        StringBuffer outputBuffer = this.getOutBuffer();
        if (outputBuffer == null) {
            PrintStream originalOutputStream = (PrintStream)this.out;
            return originalOutputStream.append(csq, start, end);
        }
        return this;
    }

    @Override
    public boolean checkError() {
        StringBuffer outputBuffer = this.getOutBuffer();
        if (outputBuffer == null) {
            PrintStream originalOutputStream = (PrintStream)this.out;
            return originalOutputStream.checkError();
        }
        return false;
    }

    @Override
    public PrintStream format(Locale locale, String format, Object ... args) {
        this._print(String.format(locale, format, args), false);
        return this;
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        this._print(String.format(format, args), false);
        return this;
    }

    @Override
    public void close() {
        StringBuffer outputBuffer = this.getOutBuffer();
        if (outputBuffer == null) {
            PrintStream originalOutputStream = (PrintStream)this.out;
            originalOutputStream.close();
        }
    }

    @Override
    public void flush() {
        StringBuffer outputBuffer = this.getOutBuffer();
        if (outputBuffer == null) {
            PrintStream originalOutputStream = (PrintStream)this.out;
            originalOutputStream.flush();
        }
    }
}

