/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.gateway;

import com.intersystems.gateway.ClassLoader;
import com.intersystems.gateway.GatewayContext;
import com.intersystems.gateway.GatewayEvent;
import com.intersystems.gateway.GatewayException;
import com.intersystems.gateway.Generator;
import com.intersystems.gateway.IRISRemoteException;
import com.intersystems.gateway.JGPrintStream;
import com.intersystems.gateway.TypeMap;
import com.intersystems.jdbc.BufferWrite;
import com.intersystems.jdbc.Device;
import com.intersystems.jdbc.IRIS;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.IRISList;
import com.intersystems.jdbc.IRISOREF;
import com.intersystems.jdbc.IRISObject;
import com.intersystems.jdbc.InStream;
import com.intersystems.jdbc.LogFileStream;
import com.intersystems.jdbc.OutStream;
import com.intersystems.jdbcgateway.JDBCGateway;
import com.intersystems.jdbcgateway.JDBCGatewayHelper;
import com.intersystems.util.MachineInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JavaGateway
extends Thread {
    static final byte[] MESSAGE_CONNECT = new byte[]{89, 48};
    static final byte[] MESSAGE_EXECUTE_METHOD = new byte[]{89, 49};
    static final byte[] MESSAGE_GENERATE_CLASSES = new byte[]{89, 50};
    static final byte[] MESSAGE_GET_JAVA_PROXY = new byte[]{89, 51};
    static final byte[] MESSAGE_DISCONNECT = new byte[]{89, 52};
    static final byte[] MESSAGE_EXCEPTION_RAISED = new byte[]{89, 53};
    static final byte[] MESSAGE_SHUTDOWN = new byte[]{89, 54};
    static final byte[] MESSAGE_JAVA_OBJECT_CREATED = new byte[]{89, 57};
    static final byte[] MESSAGE_GET_AVAILABLE_CLASSES = new byte[]{89, 67};
    static final byte[] MESSAGE_LOAD_COS_CLASS = new byte[]{89, 76};
    static final byte[] MESSAGE_GET_TIMESTAMP = new byte[]{89, 84};
    static final byte[] MESSAGE_LOAD_JAVA_CLASS = new byte[]{89, 90};
    static final byte[] MESSAGE_LOAD_JAVA_CLASS_SYNCH = new byte[]{89, 87};
    static final byte[] MESSAGE_ADD_TO_CURRENT_CLASSPATH = new byte[]{89, 80};
    static final byte[] MESSAGE_PING = new byte[]{89, 81};
    static final byte[] MESSAGE_FETCH_OBJECT = new byte[]{89, 70};
    static final byte[] MESSAGE_SEND_OBJECT = new byte[]{89, 83};
    static final byte[] MESSAGE_SERVICE_CALL = new byte[]{89, 75};
    static final byte[] MESSAGE_REGISTER_ON_DESTRUCT_CALLBACK = new byte[]{89, 82};
    public static final byte[] MESSAGE_JDBC_GATEWAY = new byte[]{89, 77};
    static final byte[] MESSAGE_DYNAMIC_EXECUTE_CONSTRUCTOR = new byte[]{89, 65};
    static final byte[] MESSAGE_DYNAMIC_EXECUTE_METHOD = new byte[]{89, 85};
    static final byte[] MESSAGE_DYNAMIC_EXECUTE_GET = new byte[]{89, 86};
    static final byte[] MESSAGE_DYNAMIC_EXECUTE_SET = new byte[]{89, 66};
    static final byte[] MESSAGE_RECAST_EXECUTE_CONSTRUCTOR = new byte[]{89, 68};
    static final byte[] MESSAGE_RECAST_EXECUTE_METHOD = new byte[]{89, 69};
    static final byte[] MESSAGE_RECAST_GET_LIST = new byte[]{89, 71};
    static final byte[] MESSAGE_RECAST_GET_STREAM = new byte[]{89, 72};
    static final byte[] MESSAGE_BENCHMARK_ECHO = new byte[]{89, 89};
    public static final byte[] MESSAGE_XSLT2_REQUEST = new byte[]{89, 88};
    public static final byte[] MESSAGE_XSLT3_REQUEST = new byte[]{89, 48};
    protected static final int PASSPHRASE = -48;
    protected static final int CONNECT = 0;
    static final int EXECUTE_METHOD = 1;
    static final int GENERATE_CLASSES = 2;
    static final int GET_JAVA_PROXY = 3;
    protected static final int DISCONNECT = 4;
    static final int EXCEPTION_RAISED = 5;
    protected static final int SHUTDOWN = 6;
    static final int JAVA_OBJECT_CREATED = 9;
    static final int GET_AVAILABLE_CLASSES = 19;
    static final int FETCH_OBJECT = 22;
    static final int GET_TIMESTAMP = 36;
    static final int LOAD_JAVA_CLASS = 42;
    static final int LOAD_JAVA_CLASS_SYNCH = 39;
    static final int ADD_TO_CURRENT_CLASSPATH = 32;
    protected static final int PING = 33;
    static final int SERVICE_CALL = 27;
    static final int LOAD_COS_CLASS = 28;
    static final int JDBC_GATEWAY_MESSAGE = 29;
    static final int REGISTER_ON_DESTRUCT_CALLBACK = 34;
    static final int SEND_OBJECT = 35;
    static final int DYNAMIC_EXECUTE_CONSTRUCTOR = 17;
    static final int DYNAMIC_EXECUTE_METHOD = 37;
    static final int DYNAMIC_EXECUTE_GET = 38;
    static final int DYNAMIC_EXECUTE_SET = 18;
    static final int RECAST_EXECUTE_CONSTRUCTOR = 20;
    static final int RECAST_EXECUTE_METHOD = 21;
    static final int BENCHMARK_ECHO = 41;
    static final int XSLT2_REQUEST = 40;
    static final int XSLT3_REQUEST = 31;
    static final int FIND_ANY = 0;
    static final int FIND_CONSTRUCTOR = 1;
    Map<String, String> irisType = TypeMap.getIRISTypes();
    Map<String, Map<String, Object>> calledCache = new HashMap<String, Map<String, Object>>();
    Map<String, Method[]> allMethods = new HashMap<String, Method[]>();
    Map<String, Constructor<?>[]> allConstructors = new HashMap<String, Constructor<?>[]>();
    protected static String serverName = "";
    private static JGPrintStream outputRedirect;
    private static JGPrintStream errorRedirect;
    private boolean overloadHasReturnValue = false;
    private List<String> exclusions;
    public IRISConnection connection;
    Map<String, String> alreadyGenerated;
    Map<String, Method> serviceMethods = new HashMap<String, Method>();
    Map<String, Object> services = new HashMap<String, Object>();
    Map<String, Constructor<?>> cachedConstructors = new HashMap();
    Map<String, Method> cachedMethods = new HashMap<String, Method>();
    private JDBCGateway jdbcGateway = null;
    private Object xslt_instance = null;
    private Method xslt_handler2 = null;
    private Method xslt_handler3 = null;
    private boolean rundown = false;
    protected InStream gateway_inMessage;
    protected OutStream gateway_outMessage;
    protected int outMessage_sequenceNumber;
    private ClassLoader classLoader;
    protected static ConcurrentHashMap<Long, Boolean> activeThreadStatus;
    private static Map<Long, JavaGateway> activeThreadObject;
    private static boolean terminate_listener;
    private static boolean update_thread_map;

    protected JavaGateway(Socket sock, int p, LogFileStream log, byte[] hash) throws Exception {
        this.alreadyGenerated = new HashMap<String, String>();
        this.connection = new IRISConnection();
        this.connection.conParams.setPortNumber(p);
        this.connection.setLogFile(log);
        new Device(this.connection, sock);
        this.connection.connectionInfo.protocolVersion = 69;
        this.gateway_inMessage = new InStream(this.connection);
        this.gateway_outMessage = new OutStream(this.connection);
        this.classLoader = new ClassLoader(new URL[0], Thread.currentThread().getContextClassLoader());
        this.connection.inMessage = new InStream(this.connection);
        this.connection.outMessage = new OutStream(this.connection);
        this.connection.disableOutputRedirect = false;
        this.connection.isGateway = true;
        this.connection.skipDC = true;
        if (hash != null) {
            try {
                if (!this.gateway_inMessage.checkSHeader(hash, sock)) {
                    this.rundown = true;
                    this.log(" >> Bad Passphrase used!");
                }
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message.contentEquals("Server closed communication device") || message.contentEquals("Communication error: Server closed communication device") || message.contentEquals("Connection reset")) {
                    this.rundown = true;
                    this.log(" >> Bad Passphrase used! Remote disconnect");
                    return;
                }
                throw new GatewayException(message);
            }
        }
    }

    protected JavaGateway(Socket sock, int p, LogFileStream log) throws Exception {
        this(sock, p, log, null);
    }

    protected JavaGateway() throws Exception {
        this.alreadyGenerated = new HashMap<String, String>();
    }

    public JavaGateway(IRISConnection existing_connection) {
        this.alreadyGenerated = new HashMap<String, String>();
        this.connection = existing_connection;
        this.gateway_inMessage = new InStream(this.connection);
        this.gateway_outMessage = new OutStream(this.connection);
        this.classLoader = new ClassLoader(new URL[0], Thread.currentThread().getContextClassLoader());
    }

    void cleanUp() throws Exception {
        if (this.jdbcGateway != null) {
            this.jdbcGateway.closeAll();
        }
        if (this.alreadyGenerated != null) {
            this.alreadyGenerated.clear();
            this.alreadyGenerated = null;
        }
        if (this.exclusions != null) {
            this.exclusions.clear();
            this.exclusions = null;
        }
        if (outputRedirect != null) {
            outputRedirect.unregister();
        }
        if (errorRedirect != null) {
            errorRedirect.unregister();
        }
        this.connection.close();
        this.connection = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        ServerSocket serverSocket;
        int port = JavaGateway.getPortNumber(args);
        LogFileStream logFile = JavaGateway.getLogFile(args);
        serverName = JavaGateway.getServerName(args);
        if (logFile != null) {
            logFile.dumpHeader();
        }
        String host = JavaGateway.getHost(args);
        String sslconfig = null;
        byte[] secretHash = null;
        Document doc = null;
        String certificateFile = null;
        String caFile = null;
        String privateKeyFile = null;
        String cipherSuites = null;
        String password = null;
        sslconfig = JavaGateway.getSSL(args, logFile);
        if (sslconfig != null) {
            doc = JavaGateway.getDoc(sslconfig);
            if (doc != null) {
                certificateFile = JavaGateway.getCertificateFile(doc);
                caFile = JavaGateway.getCAFile(doc);
                privateKeyFile = JavaGateway.getPrivateKeyFile(doc);
                cipherSuites = JavaGateway.getCipherSuites(doc);
            }
            password = JavaGateway.getPassword(sslconfig);
        }
        if (sslconfig == null) {
            secretHash = JavaGateway.getSecret(args, logFile);
        }
        try {
            System.out.println("Gateway Server: listening on port " + port);
            JavaGateway.initializeOutputRedirection();
            serverSocket = JavaGateway.setupServerSocket(host, port, sslconfig, certificateFile, privateKeyFile, caFile, password, cipherSuites);
            serverSocket.setSoTimeout(1000);
            while (true) {
                try {}
                catch (SocketTimeoutException e) {
                    if (terminate_listener) {
                        serverSocket.close();
                        Iterator<Long> e2 = activeThreadObject.keySet().iterator();
                        while (true) {
                            if (!e2.hasNext()) {
                                GatewayEvent.invokeGatewayProcessExitHandlers();
                                return;
                            }
                            Long key = e2.next();
                            activeThreadObject.get(key).join();
                        }
                    }
                    if (!update_thread_map) continue;
                    Iterator<Map.Entry<Long, Boolean>> iterator = activeThreadStatus.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Long, Boolean> entry = iterator.next();
                        if (entry.getValue().booleanValue()) continue;
                        Long key = entry.getKey();
                        activeThreadObject.get(key).join();
                        activeThreadObject.remove(key);
                        iterator.remove();
                    }
                    update_thread_map = false;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GatewayException("[Java Gateway] Communication link failure: " + e.getMessage());
        }
        while (true) {
            Socket sock = serverSocket.accept();
            sock.setTcpNoDelay(true);
            try {
                JavaGateway gateway = new JavaGateway(sock, port, logFile, secretHash);
                activeThreadStatus.put(gateway.getId(), true);
                activeThreadObject.put(gateway.getId(), gateway);
                gateway.start();
            }
            catch (Exception e2) {
                LogFileStream.log(logFile, "[JavaGateway] Error in creating Gateway class or starting the thread!\n" + e2.getMessage());
                return;
            }
        }
    }

    public static IRISConnection getConnection(String url) throws SQLException {
        IRISConnection connection = (IRISConnection)DriverManager.getConnection(url);
        return connection;
    }

    public static IRISConnection getConnection(String url, Properties info) throws SQLException {
        IRISConnection connection = (IRISConnection)DriverManager.getConnection(url, info);
        return connection;
    }

    public static IRISConnection getConnection(String url, String username, String password) throws SQLException {
        IRISConnection connection = (IRISConnection)DriverManager.getConnection(url, username, password);
        return connection;
    }

    public void dispatchReentrancy(InStream dispatching_inMessage, int messageType) throws SQLException {
        try {
            messageType = ((0xFF00 & messageType) >> 8) - 48;
            IRISConnection previousConnection = GatewayContext.getConnection(false);
            GatewayContext.setConnection(this.connection);
            this.gateway_inMessage.wire = dispatching_inMessage.wire;
            boolean disconnect = this.processMessage(messageType, false);
            this.gateway_outMessage.send(this.outMessage_sequenceNumber);
            if (disconnect) {
                this.log(" << GatewayException: Connection closed inside reentrancy");
                this.cleanUp();
                throw new SQLException("Communication link failure");
            }
            GatewayContext.setConnection(previousConnection);
        }
        catch (Throwable e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    protected static void initializeOutputRedirection() {
        outputRedirect = new JGPrintStream(System.out);
        System.setOut(outputRedirect);
        errorRedirect = new JGPrintStream(System.err);
        System.setErr(errorRedirect);
    }

    protected static ServerSocket setupServerSocket(String host, int port) throws Exception {
        return JavaGateway.setupServerSocket(host, port, null, "", "", "", "", "");
    }

    protected static ServerSocket setupServerSocket(String host, int port, String sslconfig, String certificateFile, String privateKeyFile, String caFile, String password, String cipherSuites) throws Exception {
        ServerSocket serverSocket = new ServerSocket();
        if (sslconfig != null) {
            PKCS8EncodedKeySpec keySpec;
            boolean isCaFileProvided = true;
            char[] pass = null;
            if (password != null && !password.equals("")) {
                pass = new String(Base64.getDecoder().decode(password)).toCharArray();
            }
            if (certificateFile == null || certificateFile.equals("")) {
                throw new FileNotFoundException("Certificate file is not found");
            }
            if (privateKeyFile == null || privateKeyFile.equals("")) {
                throw new FileNotFoundException("PrivateKey File file is not found");
            }
            if (caFile == null || caFile.equals("")) {
                isCaFileProvided = false;
            }
            FileInputStream fisCertificate = new FileInputStream(certificateFile);
            FileInputStream fisCAFile = null;
            if (isCaFileProvided) {
                fisCAFile = new FileInputStream(caFile);
            }
            String keyContent = new String(Files.readAllBytes(Paths.get(privateKeyFile, new String[0])));
            if (pass != null) {
                keyContent = keyContent.replaceAll("-----BEGIN ENCRYPTED PRIVATE KEY-----", "").replaceAll(System.lineSeparator(), "");
                keyContent = keyContent.replaceAll("-----END ENCRYPTED PRIVATE KEY-----", "").replaceAll("\\s+", "");
            } else {
                keyContent = keyContent.replaceAll("-----BEGIN PRIVATE KEY-----", "").replaceAll(System.lineSeparator(), "");
                keyContent = keyContent.replaceAll("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
            }
            keyContent = keyContent.trim();
            byte[] decodedKey = Base64.getDecoder().decode(keyContent);
            if (pass != null) {
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(decodedKey);
                String algorithmParameters = encryptedPrivateKeyInfo.getAlgParameters().toString();
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithmParameters);
                SecretKey skey = secretKeyFactory.generateSecret(new PBEKeySpec(pass));
                Cipher ciph = Cipher.getInstance(algorithmParameters);
                ciph.init(2, (Key)skey, encryptedPrivateKeyInfo.getAlgParameters());
                keySpec = encryptedPrivateKeyInfo.getKeySpec(ciph);
            } else {
                keySpec = new PKCS8EncodedKeySpec(decodedKey);
            }
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certificateFactory.generateCertificate(fisCertificate);
            Certificate caCertificate = null;
            if (fisCAFile != null) {
                caCertificate = CertificateFactory.getInstance("X.509").generateCertificate(fisCAFile);
            }
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, pass);
            keyStore.setKeyEntry("private", privateKey, pass, new Certificate[]{certificate});
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, pass);
            if (caCertificate != null) {
                trustStore.setCertificateEntry("CA_Certificate", caCertificate);
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, pass);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(trustStore);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            SSLServerSocketFactory factory = context.getServerSocketFactory();
            serverSocket = factory.createServerSocket();
            ArrayList<String> cipherSuitesList = new ArrayList<String>();
            if (cipherSuites != null) {
                StringTokenizer st = new StringTokenizer(cipherSuites, ":");
                List<String> supported = Arrays.asList(((SSLServerSocket)serverSocket).getSupportedCipherSuites());
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (!supported.contains(tok)) continue;
                    cipherSuitesList.add(tok);
                }
                if (!cipherSuitesList.isEmpty()) {
                    ((SSLServerSocket)serverSocket).setEnabledCipherSuites(cipherSuitesList.toArray(new String[0]));
                }
            }
        }
        if (MachineInfo.getOSName().startsWith("WINDOWS")) {
            serverSocket.setReuseAddress(false);
        } else {
            serverSocket.setReuseAddress(true);
        }
        DriverManager.getLoginTimeout();
        serverSocket.bind(new InetSocketAddress(InetAddress.getByName(host), port), 50);
        return serverSocket;
    }

    protected static int getPortNumber(String[] args) throws GatewayException {
        if (args.length == 0) {
            throw new GatewayException("Port number must be supplied as the first command line argument");
        }
        return Integer.parseInt(args[0]);
    }

    protected static LogFileStream getLogFile(String[] args) throws Exception {
        if (args.length > 1 && args[1].length() > 0) {
            return new LogFileStream(args[1]);
        }
        return null;
    }

    protected static String getServerName(String[] args) throws GatewayException {
        if (args.length > 2) {
            return args[2];
        }
        return null;
    }

    protected static String getHost(String[] args) {
        if (args.length > 3 && args[3].length() > 0) {
            return args[3];
        }
        return "127.0.0.1";
    }

    private static byte[] parseHexBinary(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + s);
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = JavaGateway.hexToBin(s.charAt(i));
            int l = JavaGateway.hexToBin(s.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + s);
            }
            out[i / 2] = (byte)(h * 16 + l);
        }
        return out;
    }

    private static int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }

    protected static byte[] getSecret(String[] args) throws GatewayException {
        return JavaGateway.getSecret(args, null);
    }

    protected static byte[] getSecret(String[] args, LogFileStream logFile) throws GatewayException {
        String secureStr = null;
        int NumberChars = 0;
        if (args.length > 4) {
            secureStr = args[4];
            NumberChars = secureStr.length();
        }
        if (NumberChars == 0) {
            secureStr = System.getenv("IRIS_GATEWAY_PASSPHRASE");
            NumberChars = secureStr != null ? secureStr.length() : 0;
        }
        LogFileStream.log(logFile, "Passphrase: " + secureStr);
        if (NumberChars > 0) {
            if (NumberChars > 16) {
                NumberChars = 16;
            }
            byte[] bytes = JavaGateway.parseHexBinary(secureStr.substring(0, NumberChars));
            byte[] eightbytes = new byte[8];
            for (int i = 0; i < NumberChars / 2; ++i) {
                eightbytes[i] = bytes[i];
            }
            try {
                InStream.class.getMethod("checkSHeader", byte[].class, Socket.class);
                return MessageDigest.getInstance("SHA-256").digest(eightbytes);
            }
            catch (NoSuchAlgorithmException e) {
                throw new GatewayException("Secure password cannot be supported, missing MessageDigest for SHA-256");
            }
            catch (NoSuchMethodException e) {
                throw new GatewayException("Secure password cannot be supported, need newer version of jdbc driver!");
            }
            catch (SecurityException e) {
                throw new GatewayException("Secure password cannot be supported, need newer version of jdbc driver!");
            }
        }
        return null;
    }

    protected static String getSSL(String[] args, LogFileStream logFile) throws GatewayException {
        if (args.length > 4 && args[4].startsWith("ssl:")) {
            return args[4].substring(4);
        }
        return null;
    }

    protected static Document getDoc(String sslConfig) throws Exception {
        Document doc;
        if (sslConfig.trim().isEmpty()) {
            throw new IllegalArgumentException("Input sslConfig cannot be empty.");
        }
        int xmlIndex = sslConfig.indexOf(".xml");
        if (xmlIndex == -1) {
            throw new IllegalArgumentException("Command does not contain XML file name ended with '.xml'.");
        }
        String fileLocation = sslConfig.substring(0, xmlIndex) + ".xml";
        File file = new File(fileLocation);
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + fileLocation);
        }
        file.setReadable(true);
        if (!file.canRead()) {
            throw new IOException("File cannot be read: " + fileLocation);
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(file);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error configuring XML parser.", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Error parsing XML.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO error reading XML.", e);
        }
        if (doc.getDocumentElement() == null) {
            throw new RuntimeException("XML does not have a root element.");
        }
        doc.getDocumentElement().normalize();
        return doc;
    }

    protected static String getPassword(String sslConfig) throws Exception {
        if (sslConfig.trim().isEmpty()) {
            throw new IllegalArgumentException("Input sslConfig cannot be empty.");
        }
        int xmlIndex = sslConfig.indexOf(".xml");
        if (xmlIndex == -1) {
            throw new IllegalArgumentException("Command does not contain XML file name ended with '.xml'.");
        }
        String password = sslConfig.substring(sslConfig.indexOf(".xml") + 5);
        return password;
    }

    protected static String getCertificateFile(Document doc) throws Exception {
        NodeList nodeList = doc.getElementsByTagName("CertificateFile");
        if (nodeList.getLength() == 0) {
            throw new NoSuchElementException("No CerficateFile field found in configuration file");
        }
        Node node = nodeList.item(0);
        if (!(node instanceof Element)) {
            return null;
        }
        Element eElement = (Element)node;
        String certificateFile = eElement.getTextContent();
        return certificateFile;
    }

    protected static String getCAFile(Document doc) throws Exception {
        NodeList nodeList = doc.getElementsByTagName("CAFile");
        if (nodeList.getLength() == 0) {
            return null;
        }
        Node node = nodeList.item(0);
        if (!(node instanceof Element)) {
            return null;
        }
        Element eElement = (Element)node;
        String CAFile = eElement.getTextContent();
        return CAFile;
    }

    protected static String getPrivateKeyFile(Document doc) throws Exception {
        NodeList nodeList = doc.getElementsByTagName("PrivateKeyFile");
        if (nodeList.getLength() == 0) {
            throw new NoSuchElementException("No Private Key File field found in configuration file");
        }
        Node node = nodeList.item(0);
        if (!(node instanceof Element)) {
            return null;
        }
        Element element = (Element)node;
        String privateKeyFile = element.getTextContent();
        return privateKeyFile;
    }

    protected static String getCipherSuites(Document doc) throws Exception {
        NodeList nodeList = doc.getElementsByTagName("Ciphersuites");
        if (nodeList.getLength() == 0) {
            return null;
        }
        Node node = nodeList.item(0);
        if (!(node instanceof Element)) {
            return null;
        }
        Element element = (Element)node;
        String cipherSuites = element.getTextContent();
        return cipherSuites;
    }

    @Override
    public synchronized void run() {
        this.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run(boolean allowUnknownMessage) {
        try {
            this.connection.setGateway(this);
            boolean sendResponse = false;
            boolean disconnect = false;
            java.lang.ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            while (true) {
                int x;
                if (this.rundown) {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                    this.classLoader.close();
                    this.cleanUp();
                    break;
                }
                IRISConnection.MessageCount messageCount = this.connection.messageCount;
                synchronized (messageCount) {
                    if (sendResponse) {
                        this.gateway_outMessage.send(this.outMessage_sequenceNumber);
                    }
                    if (disconnect) {
                        Thread.currentThread().setContextClassLoader(originalClassLoader);
                        this.classLoader.close();
                        this.cleanUp();
                        break;
                    }
                    x = this.gateway_inMessage.readMessage();
                }
                disconnect = this.processMessage(x, allowUnknownMessage);
                sendResponse = x != 0 && x != -48;
            }
        }
        catch (Throwable t) {
            try {
                this.log("<< GatewayException: " + t.getMessage() + " >>");
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                String exceptionAsString = sw.toString();
                this.log(exceptionAsString);
                this.cleanUp();
                t.printStackTrace();
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
        GatewayEvent.invokeGatewayThreadExitHandlers();
        activeThreadStatus.put(this.getId(), false);
        update_thread_map = true;
    }

    public boolean processMessage(int x, boolean allowUnknownMessage) throws Throwable {
        switch (x) {
            case 41: {
                this.benchmarkEcho();
                break;
            }
            case 27: {
                this.serviceCall();
                break;
            }
            case 17: {
                this.dynamicExecuteConstructor();
                break;
            }
            case 37: {
                this.dynamicExecuteMethod();
                break;
            }
            case 38: {
                this.dynamicExecuteGet();
                break;
            }
            case 18: {
                this.dynamicExecuteSet();
                break;
            }
            case 20: {
                this.recastExecuteConstructor();
                break;
            }
            case 21: {
                this.recastExecuteMethod();
                break;
            }
            case 1: {
                this.executeMethod();
                break;
            }
            case 3: {
                this.callConstructor();
                break;
            }
            case 2: {
                this.generateClasses();
                break;
            }
            case 0: {
                this.connect();
                break;
            }
            case 19: {
                this.getAvailableClasses();
                break;
            }
            case 39: {
                this.loadJavaClassSynch();
                break;
            }
            case 42: {
                this.loadJavaClass();
                break;
            }
            case 29: {
                this.getJDBCGatewayMessage();
                break;
            }
            case 22: {
                this.fetchObject();
                break;
            }
            case 35: {
                this.sendObject();
                break;
            }
            case 4: {
                this.disconnect();
                return true;
            }
            case 6: {
                this.shutdown();
                break;
            }
            case 32: {
                this.addToCurrentClasspath();
                break;
            }
            case 34: {
                this.registerOnDestructCallback();
                break;
            }
            case 33: {
                this.ping();
                break;
            }
            case 40: {
                this.xslt_request(2);
                break;
            }
            case 31: {
                this.xslt_request(3);
                break;
            }
            case -48: {
                break;
            }
            default: {
                if (allowUnknownMessage) {
                    return true;
                }
                this.log(" << GatewayException: Unknown Message: " + x + " >>");
                throw new GatewayException("Unknown Message: " + x);
            }
        }
        return false;
    }

    protected void shutdown() throws Exception {
        boolean is_soft;
        this.log(" >> SHUTDOWN << ");
        boolean bl = is_soft = this.gateway_inMessage.wire.isEnd() ? false : this.gateway_inMessage.wire.getBoolean();
        if (is_soft) {
            terminate_listener = true;
            this.outMessage_sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            this.gateway_outMessage.wire.writeHeader(MESSAGE_SHUTDOWN);
        } else {
            this.connection.close();
            GatewayEvent.invokeGatewayProcessExitHandlers();
            System.exit(0);
        }
    }

    private void logSkip(String msg) {
        LogFileStream lf = this.connection.getLogFile();
        if (lf != null && !lf.bSkipLogging) {
            lf.logApi(msg);
        }
    }

    protected void log(String msg) {
        this.connection.writeToLog(msg);
    }

    protected void disconnect() throws Exception {
        this.logSkip(" >> DISCONNECT");
        try {
            this.getClassLoader().close();
            int sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            this.gateway_outMessage.wire.writeHeader(MESSAGE_DISCONNECT);
            this.outMessage_sequenceNumber = sequenceNumber;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logSkip(" << DISCONNECT");
    }

    protected void connect() throws Exception {
        int sequenceNumber = 0;
        try {
            String shmConnectStr;
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            this.gateway_inMessage.wire.getInt();
            this.connection.connectionInfo.isUnicodeServer = this.gateway_inMessage.wire.getInt() == 1;
            this.connection.connectionInfo.setServerLocale(this.gateway_inMessage.wire.getString());
            this.connection.connectionInfo.srvJobNumber = this.gateway_inMessage.wire.getString();
            this.connection.conParams.setDatabaseName(this.gateway_inMessage.wire.getString());
            this.setAdditionalClassPath(null);
            this.connection.disableOutputRedirect = this.gateway_inMessage.wire.getBoolean();
            this.setRedirect();
            this.gateway_inMessage.wire.getBoolean();
            int dbsrvProtocolVersion = this.gateway_inMessage.wire.getInt();
            int negotiatedProtocolVersion = 69 > dbsrvProtocolVersion ? dbsrvProtocolVersion : 69;
            this.connection.connectionInfo.irisInstallDir = this.gateway_inMessage.wire.isEnd() ? null : this.gateway_inMessage.wire.getString();
            this.connection.conParams.setSharedMemory(this.connection.connectionInfo.irisInstallDir != null);
            String string = shmConnectStr = this.gateway_inMessage.wire.isEnd() ? null : this.gateway_inMessage.wire.getString();
            if (shmConnectStr != null && shmConnectStr.startsWith("SHM|")) {
                this.connection.conParams.setServerName(shmConnectStr);
                this.connection.conParams.setSharedMemory(true);
            }
            boolean compactDouble = this.gateway_inMessage.wire.isEnd() ? false : this.gateway_inMessage.wire.getBoolean();
            this.log(" >> CONNECT");
            this.connection.connectionInfo.protocolVersion = negotiatedProtocolVersion;
            if (negotiatedProtocolVersion >= 65 && compactDouble) {
                this.gateway_outMessage.wire.setCompactDoubleEnabled(compactDouble);
                this.connection.connectionInfo.compactDoubleEnabled = compactDouble;
            }
            this.gateway_inMessage.setLocale(this.connection.connectionInfo);
            this.gateway_outMessage.wire.setConnectionInfo(this.connection.connectionInfo);
            this.gateway_outMessage.wire.writeHeader(MESSAGE_CONNECT);
            this.gateway_outMessage.wire.set(this.connection.connectionInfo.protocolVersion);
            this.gateway_outMessage.wire.set(this.connection.connectionInfo.protocolVersion);
            if (this.connection.getProtocolVersion() <= 61) {
                if (this.connection.conParams.getSharedMemory().booleanValue()) {
                    this.gateway_outMessage.wire.set(1);
                }
            } else {
                this.gateway_outMessage.wire.set(this.connection.conParams.getSharedMemory());
                this.gateway_outMessage.wire.set(serverName);
            }
            this.gateway_outMessage.send(sequenceNumber);
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
            this.gateway_outMessage.send(sequenceNumber);
        }
        this.log(" << CONNECT");
        try {
            if (this.connection.conParams.getSharedMemory().booleanValue()) {
                try {
                    this.connection.device.establishSHMSocket();
                    if (this.connection.isUsingSharedMemory()) {
                        this.gateway_inMessage.setDevInStream(this.connection.device.getInputStream());
                        this.gateway_outMessage.setDevOutStream(this.connection.device.getOutputStream());
                        this.connection.inMessage.setDevInStream(this.connection.device.getInputStream());
                        this.connection.outMessage.setDevOutStream(this.connection.device.getOutputStream());
                    }
                }
                catch (Throwable exOrEr) {
                    this.log(exOrEr.getMessage());
                }
            }
            this.connection.initializationRequiredForXDBC = true;
            GatewayContext.setConnection(this.connection);
        }
        catch (Throwable e) {
            this.log(e.getMessage());
        }
    }

    private void registerOnDestructCallback() throws Exception {
        int sequenceNumber = 0;
        try {
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            String oref = this.gateway_inMessage.wire.getString();
            String methodName = this.gateway_inMessage.wire.getString();
            this.log(" >> REGISTER_ON_DESTRUCT_CALLBACK");
            Object jo = this.connection.registry_NetRemoteObject_get_object_from_oref(oref);
            if (jo == null) {
                throw new GatewayException("Unable to register destruct callback - no matching object was found");
            }
            Method method = jo.getClass().getMethod(methodName, null);
            if (this.connection.onDestructRegistry == null) {
                this.connection.onDestructRegistry = new HashMap<Object, Method>();
            }
            this.connection.onDestructRegistry.put(jo, method);
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << REGISTER_ON_DESTRUCT_CALLBACK");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private void clearDestructRegistry() throws Exception {
        for (Object object : this.connection.onDestructRegistry.keySet()) {
            Method method = this.connection.onDestructRegistry.get(object);
            method.invoke(object, (Object[])null);
        }
    }

    private void setAdditionalClassPath(String currentJarFile) throws Exception {
        int pathCount;
        String pathCountString = this.gateway_inMessage.wire.getString();
        boolean useSystemLoader = false;
        if (pathCountString.endsWith(":system")) {
            useSystemLoader = true;
            pathCountString = pathCountString.substring(0, pathCountString.length() - 7);
        }
        if ((pathCount = Integer.parseInt(pathCountString)) == 0 && currentJarFile == null) {
            return;
        }
        for (int i = 0; i < pathCount; ++i) {
            this.addToClassLoader(this.gateway_inMessage.wire.getString(), useSystemLoader);
        }
        if (currentJarFile != null) {
            this.addToClassLoader(currentJarFile, false);
        }
    }

    private synchronized void getAvailableClasses() throws Exception {
        int sequenceNumber = 0;
        try {
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            String name = this.gateway_inMessage.wire.getString();
            String iface = null;
            if (!this.gateway_inMessage.wire.isEnd()) {
                iface = this.gateway_inMessage.wire.getString();
            }
            this.log(" >> GET_AVAILABLE_CLASSES: " + name);
            String[] classes = null;
            if (name != null && !name.equals("")) {
                classes = this.getClassNamesFromJar(name, iface);
            }
            this.gateway_outMessage.wire.writeHeader(MESSAGE_GET_AVAILABLE_CLASSES);
            this.gateway_outMessage.wire.set(classes.length);
            for (int i = 0; i < classes.length; ++i) {
                this.gateway_outMessage.wire.set(classes[i]);
            }
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << GET_AVAILABLE_CLASSES");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private synchronized void generateClasses() throws Exception {
        int sequenceNumber = 0;
        try {
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            String className = this.gateway_inMessage.wire.getString();
            if (className.endsWith(".jar")) {
                this.setAdditionalClassPath(className);
            } else {
                this.setAdditionalClassPath(null);
            }
            this.exclusions = TypeMap.getInitialExclusions();
            int ceCount = this.gateway_inMessage.wire.getInt();
            for (int i = 0; i < ceCount; ++i) {
                this.exclusions.add(this.gateway_inMessage.wire.getString());
            }
            this.log(" >> GENERATE_CLASSES: " + className);
            if (className.endsWith(".jar")) {
                this.generateJar(className, sequenceNumber);
            } else {
                new Generator(this).generate(className, sequenceNumber);
            }
            this.gateway_outMessage.wire.writeHeader(MESSAGE_GENERATE_CLASSES);
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << GENERATE_CLASSES");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private void generateJar(String jarFileName, int sequenceNumber) throws Throwable {
        String[] classes = this.getClassNamesFromJar(jarFileName, null);
        Generator generator = new Generator(this);
        for (String classe : classes) {
            generator.generate(classe, sequenceNumber);
        }
    }

    void updateOrefRegistry(int count) throws Throwable {
        for (int i = 0; i < count; ++i) {
            String oref = this.gateway_inMessage.wire.getString();
            if (this.connection.onDestructRegistry != null && this.connection.onDestructRegistry.size() > 0) {
                Object obj = this.connection.registry_NetRemoteObject_get_object_from_oref(oref);
                Method method = this.connection.onDestructRegistry.get(obj);
                method.invoke(obj, (Object[])null);
            }
            this.connection.registry_NetRemoteObject_remove_by_oref(oref);
        }
    }

    private Object findMember(String className, String methodName, int whatToLookFor) throws Throwable {
        Map<String, Object> methodMap = this.calledCache.get(className);
        if (methodMap != null) {
            Object member = methodMap.get(methodName);
            if (member != null) {
                return member;
            }
        } else {
            methodMap = new HashMap<String, Object>();
            this.calledCache.put(className, methodMap);
        }
        Class<?> clazz = this.loadClass(className);
        if (clazz == null) {
            throw new GatewayException("Class not found: " + className);
        }
        if (whatToLookFor == 1 || className.equals(methodName)) {
            Constructor<?>[] constructors = this.allConstructors.get(className);
            if (constructors == null) {
                constructors = clazz.getConstructors();
                this.allConstructors.put(className, constructors);
            }
            if (constructors == null || constructors.length == 0) {
                throw new GatewayException("Constructor not found: " + className);
            }
            if (constructors.length == 1) {
                methodMap.put(methodName, constructors[0]);
                return constructors[0];
            }
            ArrayList constructorList = new ArrayList(constructors.length);
            for (int i = 0; i < constructors.length; ++i) {
                constructorList.add(constructors[i]);
            }
            methodMap.put(methodName, constructorList);
            return constructorList;
        }
        Method[] methods = this.allMethods.get(className);
        if (methods == null) {
            methods = clazz.getMethods();
            this.allMethods.put(className, methods);
        }
        ArrayList<Method> methodArray = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            methodArray.add(methods[i]);
        }
        if (methodArray.size() == 1) {
            methodMap.put(methodName, methodArray.get(0));
            return methodArray.get(0);
        }
        if (methodArray.size() > 1) {
            methodMap.put(methodName, methodArray);
            return methodArray;
        }
        if (!methodName.startsWith("get") && !methodName.startsWith("set")) {
            throw new GatewayException("Member not found: " + methodName);
        }
        Field field = clazz.getField(methodName.substring(3, methodName.length()));
        methodMap.put(methodName, field);
        return field;
    }

    private void executeMethod() throws Throwable {
        int sequenceNumber = 0;
        try {
            Object member;
            String className;
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            int closedProxyCount = this.gateway_inMessage.wire.getInt();
            if (closedProxyCount > 0) {
                this.updateOrefRegistry(closedProxyCount);
            }
            String oref = this.gateway_inMessage.wire.getString();
            String methodName = this.gateway_inMessage.wire.getString();
            this.log(" >> EXECUTE_METHOD: " + methodName);
            Type type = this.connection.registry_NetRemoteObject_get_type_from_oref(oref);
            String string = className = type != null ? type.getTypeName() : null;
            if (className == null) {
                className = oref;
            }
            Object jo = this.connection.registry_NetRemoteObject_get_object_from_oref(oref);
            Class<?> loadedClass = this.loadClass(className);
            Class<?> joClass = null;
            String joClassName = null;
            if (jo != null) {
                joClass = jo.getClass();
                joClassName = joClass.getName();
            }
            if ((member = jo == null || className.equals(joClassName) || joClassName.indexOf("$") != -1 || !Modifier.isPublic(joClass.getModifiers()) || joClass.isAssignableFrom(loadedClass) || loadedClass.isAssignableFrom(joClass) ? this.findMember(className, methodName, 0) : this.findMember(joClassName, methodName, 0)) instanceof Method) {
                this.executeInstanceMethod((Method)member, methodName, oref, jo, sequenceNumber);
            } else if (member instanceof Constructor) {
                this.executeConstructor((Constructor)member, oref, joClassName);
            } else if (member instanceof Field) {
                Object javaObject = this.connection.registry_NetRemoteObject_get_object_from_oref(oref);
                this.gateway_outMessage.wire.writeHeader(MESSAGE_EXECUTE_METHOD);
                if (methodName.startsWith("get")) {
                    this.marshalReturnValue(((Field)member).getType(), ((Field)member).get(javaObject), sequenceNumber);
                } else if (methodName.startsWith("set")) {
                    this.executeSetter((Field)member, javaObject);
                }
            } else if (member instanceof ArrayList) {
                this.executeOverloadedMethod(className, methodName, oref, sequenceNumber);
            }
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << EXECUTE_METHOD");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    void executeInstanceMethod(Method method, String methodName, String oref, Object javaObject, int sequenceNumber) throws Throwable {
        Object ret;
        if (javaObject == null && !Modifier.isStatic(method.getModifiers())) {
            throw new Exception("Corresponding Java object not found: make sure you called a constructor");
        }
        int cardinality = this.gateway_inMessage.wire.getInt();
        Class<?>[] parameterTypes = null;
        if (cardinality == -1) {
            parameterTypes = method.getParameterTypes();
            cardinality = parameterTypes.length;
        }
        Object[] args = null;
        if (cardinality == 0) {
            try {
                ret = method.invoke(javaObject, (Object[])null);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        args = this.unmarshalParameters(cardinality, parameterTypes);
        try {
            ret = method.invoke(javaObject, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        this.gateway_outMessage.wire.writeHeader(MESSAGE_EXECUTE_METHOD);
        Class<?> returnType = method.getReturnType();
        if (ret != null && returnType == Object.class && !Proxy.isProxyClass(ret.getClass())) {
            returnType = ret.getClass();
        }
        if (!returnType.getName().equals("void")) {
            this.marshalReturnValue(returnType, ret, sequenceNumber);
        }
        if (args != null) {
            this.marshalArguments(args, sequenceNumber);
        }
        this.redirectOutput();
    }

    private void marshalArguments(Object[] args, int sequenceNumber) throws Throwable {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null && args[i].getClass().isArray()) {
                String componentType = args[i].getClass().getComponentType().getName();
                if (TypeMap.isJavaDataType(componentType)) {
                    this.marshalArray(this.gateway_outMessage.wire, args[i], args[i].getClass().getComponentType().getName(), sequenceNumber);
                    continue;
                }
                this.gateway_outMessage.wire.setUndefined();
                continue;
            }
            this.gateway_outMessage.wire.setUndefined();
        }
    }

    private void executeOverloadedMethod(String className, String methodName, String oref, int sequenceNumber) throws Throwable {
        Class[] parameterTypes;
        Object javaObject = this.connection.registry_NetRemoteObject_get_object_from_oref(oref);
        if (className == null) {
            className = oref;
        }
        Class<?> clazz = this.loadClass(className);
        int cardinality = this.gateway_inMessage.wire.getInt();
        Object[] args = null;
        if (cardinality == -1) {
            throw new Exception("Method not found: " + methodName);
        }
        if (cardinality == 0) {
            parameterTypes = null;
        } else {
            parameterTypes = new Class[cardinality];
            args = this.unmarshalOverloadParameters(cardinality, parameterTypes);
        }
        if (methodName.equals(className)) {
            Constructor<?> constructor = this.findConstructor(clazz, parameterTypes, args);
            if (constructor == null) {
                if (parameterTypes == null) {
                    try {
                        javaObject = clazz.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw e.getCause();
                    }
                }
                throw new Exception("No mathching constructor found");
            }
            try {
                javaObject = constructor.newInstance(args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            if (oref != null && !oref.contains("@%Library")) {
                this.connection.registry_NetRemoteObject_insert(oref, javaObject, clazz);
            }
            this.gateway_outMessage.wire.writeHeader(MESSAGE_GET_JAVA_PROXY);
        } else {
            Object ret;
            this.gateway_outMessage.wire.writeHeader(MESSAGE_EXECUTE_METHOD);
            this.overloadHasReturnValue = false;
            Method method = this.findMethod(clazz, methodName, parameterTypes, args);
            if (method == null) {
                throw new Exception("Method not found: " + methodName);
            }
            if (javaObject == null && !Modifier.isStatic(method.getModifiers())) {
                throw new Exception("Corresponding Java object not found: make sure you called a constructor");
            }
            try {
                ret = method.invoke(javaObject, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            Class<?> returnType = method.getReturnType();
            if (ret != null && returnType == Object.class && !Proxy.isProxyClass(ret.getClass())) {
                returnType = ret.getClass();
            }
            if (!returnType.getName().equals("void")) {
                this.marshalReturnValue(returnType, ret, sequenceNumber);
            } else if (this.overloadHasReturnValue) {
                this.gateway_outMessage.wire.setUndefined();
            }
            if (args != null) {
                this.marshalArguments(args, sequenceNumber);
            }
        }
        this.redirectOutput();
    }

    private Constructor<?> findConstructor(Class<?> clazz, Class<?>[] parameterTypes, Object[] args) throws Exception {
        try {
            if (parameterTypes == null) {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                return constructor;
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(parameterTypes);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            Class<?>[] types;
            int i;
            Constructor<?>[] constructors = this.allConstructors.get(clazz.getName());
            if (constructors == null) {
                constructors = clazz.getConstructors();
                this.allConstructors.put(clazz.getName(), constructors);
            }
            ArrayList allMatchingConstructors = new ArrayList();
            for (i = 0; i < constructors.length; ++i) {
                int matches = 0;
                types = constructors[i].getParameterTypes();
                if (types.length != parameterTypes.length) continue;
                for (int j = 0; j < parameterTypes.length; ++j) {
                    if (!this.compareTypes(parameterTypes[j], types[j])) continue;
                    ++matches;
                }
                if (matches != parameterTypes.length) continue;
                allMatchingConstructors.add(constructors[i]);
            }
            if (allMatchingConstructors.isEmpty()) {
                return null;
            }
            if (allMatchingConstructors.size() == 1) {
                Constructor constructor = (Constructor)allMatchingConstructors.get(0);
                types = constructor.getParameterTypes();
                for (i = 0; i < types.length; ++i) {
                    if (args[i].getClass() == types[i]) continue;
                    args[i] = this.recastArgument(args[i], types[i]);
                }
                return constructor;
            }
            throw new Exception("Constructor not found: ambiguous parameter types");
        }
    }

    private Method findMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object[] args) throws Exception {
        Class<?>[] types;
        int i;
        Method[] methods;
        Method method = null;
        try {
            method = clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        int parameterCount = 0;
        if (parameterTypes != null) {
            parameterCount = parameterTypes.length;
        }
        if ((methods = this.allMethods.get(clazz.getName())) == null) {
            methods = clazz.getMethods();
            this.allMethods.put(clazz.getName(), methods);
        }
        ArrayList<Method> possibleMatches = new ArrayList<Method>();
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            if (!methods[i].getReturnType().getName().equals("void")) {
                this.overloadHasReturnValue = true;
            }
            if (methods[i].getParameterTypes().length != parameterCount) continue;
            possibleMatches.add(methods[i]);
        }
        if (method != null) {
            return method;
        }
        if (possibleMatches.isEmpty()) {
            return null;
        }
        ArrayList allMatchingMethods = new ArrayList();
        for (i = 0; i < possibleMatches.size(); ++i) {
            int matches = 0;
            types = ((Method)possibleMatches.get(i)).getParameterTypes();
            for (int j = 0; j < parameterCount; ++j) {
                if (!this.compareTypes(parameterTypes[j], types[j])) continue;
                ++matches;
            }
            if (matches != parameterCount) continue;
            allMatchingMethods.add(possibleMatches.get(i));
        }
        possibleMatches.clear();
        if (allMatchingMethods.isEmpty()) {
            return null;
        }
        if (allMatchingMethods.size() == 1) {
            method = (Method)allMatchingMethods.get(0);
            types = method.getParameterTypes();
            for (i = 0; i < types.length; ++i) {
                if (types[i] == Object.class || args[i].getClass() == types[i]) continue;
                args[i] = this.recastArgument(args[i], types[i]);
            }
            return method;
        }
        throw new Exception("Multiple matches found for overloaded method: " + methodName);
    }

    private Object recastArgument(Object arg, Class<?> type) throws Exception {
        Class<?> argClass = arg.getClass();
        if (type.isAssignableFrom(argClass)) {
            return arg;
        }
        if (arg.getClass() == Integer.class) {
            int i = (Integer)arg;
            if (type == Short.class || type == Short.TYPE) {
                return (short)i;
            }
            if (type == Long.class || type == Long.TYPE) {
                return (long)i;
            }
            if (type == Float.class || type == Float.TYPE) {
                return Float.valueOf(i);
            }
            if (type == Double.class || type == Double.TYPE) {
                return (double)i;
            }
            if (type == String.class) {
                return arg.toString();
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                return i != 0;
            }
        } else if (type == Class.class) {
            return this.loadClass((String)arg);
        }
        return arg;
    }

    private boolean compareTypes(Class<?> guessedType, Class<?> actualType) {
        if (actualType.isAssignableFrom(guessedType)) {
            return true;
        }
        if (guessedType == Integer.TYPE && (actualType == Long.TYPE || actualType == Float.TYPE || actualType == Double.TYPE || actualType == Integer.class || actualType == Short.TYPE || actualType == Short.class || actualType == Long.class || actualType == Float.class || actualType == Double.class || actualType == String.class || actualType == Boolean.TYPE || actualType == Boolean.class || actualType == Object.class)) {
            return true;
        }
        return guessedType == String.class && actualType == Class.class;
    }

    private void executeConstructor(Constructor<?> constructor, String oref, String className) throws Throwable {
        Object javaObject;
        Object[] args;
        int cardinality = this.gateway_inMessage.wire.getInt();
        if (cardinality == -1) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            cardinality = parameterTypes.length;
            args = this.unmarshalParameters(cardinality, parameterTypes);
        } else {
            Class[] parameterTypes = new Class[cardinality];
            args = this.unmarshalOverloadParameters(cardinality, parameterTypes);
        }
        try {
            javaObject = constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        this.gateway_outMessage.wire.writeHeader(MESSAGE_GET_JAVA_PROXY);
        if (oref != null && !oref.contains("@%Library")) {
            Class<?> clazz = this.loadClass(className);
            this.connection.registry_NetRemoteObject_insert(oref, javaObject, clazz);
        }
        this.redirectOutput();
    }

    private void executeSetter(Field field, Object javaObject) throws Exception {
        field.set(javaObject, this.unmarshalParameter(field.getType()));
    }

    private void callConstructor() throws Throwable {
        int sequenceNumber = 0;
        try {
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            int closedProxyCount = this.gateway_inMessage.wire.getInt();
            if (closedProxyCount > 0) {
                this.updateOrefRegistry(closedProxyCount);
            }
            String oref = this.gateway_inMessage.wire.getString();
            String className = this.gateway_inMessage.wire.getString();
            this.log(" >> CALL_JAVA_CONSTRUCTOR");
            Object member = this.findMember(className, className, 1);
            if (member instanceof Constructor) {
                this.executeConstructor((Constructor)member, oref, className);
            } else if (member instanceof ArrayList) {
                this.executeOverloadedMethod(className, className, oref, sequenceNumber);
            } else {
                throw new GatewayException("Constructor not found");
            }
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << CALL_JAVA_CONSTRUCTOR");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className, true, this.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            if (className.equals("%GlobalBinaryStream") || className.equals("%Library.GlobalBinaryStream")) {
                return Class.forName("[B", true, this.getClassLoader());
            }
            if (className.equals("%GlobalCharacterStream") || className.equals("%Library.GlobalCharacterStream")) {
                return Class.forName("[C", true, this.getClassLoader());
            }
            ClassNotFoundException cnfe = ex;
            int i = className.lastIndexOf(46);
            if (i == -1) {
                throw cnfe;
            }
            className = className.substring(0, i) + "$" + className.substring(i + 1, className.length());
            try {
                return Class.forName(className, true, this.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw cnfe;
            }
        }
    }

    protected void ping() throws Throwable {
        int sequenceNumber = 0;
        try {
            this.logSkip(" >> PING");
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            this.gateway_outMessage.wire.writeHeader(MESSAGE_PING);
            this.gateway_outMessage.wire.set(serverName);
            this.outMessage_sequenceNumber = sequenceNumber;
            this.logSkip(" << PING");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private void addToCurrentClasspath() throws Throwable {
        int sequenceNumber = 0;
        try {
            this.logSkip(" >> ADD_TO_CURRENT_CLASSPATH");
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            this.setAdditionalClassPath(null);
            this.gateway_outMessage.wire.writeHeader(MESSAGE_ADD_TO_CURRENT_CLASSPATH);
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << ADD_TO_CURRENT_CLASSPATH");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJavaClassSynch() throws Throwable {
        int sequenceNumber = 0;
        try {
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            String className = this.gateway_inMessage.wire.getString();
            this.log(" >> LOAD_JAVA_CLASS_SYNCH: " + className);
            Class<DriverManager> clazz = DriverManager.class;
            synchronized (DriverManager.class) {
                Class.forName(className, true, this.getClassLoader());
                // ** MonitorExit[var3_4] (shouldn't be in output)
                this.gateway_outMessage.wire.writeHeader(MESSAGE_LOAD_JAVA_CLASS_SYNCH);
                this.outMessage_sequenceNumber = sequenceNumber;
                this.log(" << LOAD_JAVA_CLASS_SYNCH");
            }
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private void loadJavaClass() throws Throwable {
        int sequenceNumber = 0;
        try {
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            String className = this.gateway_inMessage.wire.getString();
            this.log(" >> LOAD_JAVA_CLASS: " + className);
            Class.forName(className, true, this.getClassLoader());
            this.gateway_outMessage.wire.writeHeader(MESSAGE_LOAD_JAVA_CLASS);
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << LOAD_JAVA_CLASS");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private void marshalArray(BufferWrite wire, Object ret, String javaType, int sequenceNumber) throws Exception {
        if (ret == null) {
            wire.set("%ListOfDataTypes");
            wire.set(-1);
            return;
        }
        int length = Array.getLength(ret);
        String componentType = ret.getClass().getComponentType().getName();
        if (!componentType.equals("java.lang.Object")) {
            javaType = componentType;
        }
        if (TypeMap.isJavaDataType(javaType)) {
            if (javaType.equals("byte")) {
                wire.set("%GlobalBinaryStream");
            } else if (javaType.equals("char")) {
                wire.set("%GlobalCharacterStream");
            } else {
                wire.set("%ListOfDataTypes");
            }
            wire.set(length);
        }
        if (javaType.equals("java.lang.String")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((String[])ret)[i]);
            }
        } else if (javaType.equals("int")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((int[])ret)[i]);
            }
        } else if (javaType.equals("java.lang.Integer")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((Integer[])ret)[i]);
            }
        } else if (javaType.equals("double")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((double[])ret)[i]);
            }
        } else if (javaType.equals("java.lang.Double")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((Double[])ret)[i]);
            }
        } else if (javaType.equals("float")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((float[])ret)[i]);
            }
        } else if (javaType.equals("java.lang.Float")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((Float[])ret)[i]);
            }
        } else if (javaType.equals("boolean")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((boolean[])ret)[i]);
            }
        } else if (javaType.equals("java.lang.Boolean")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((Boolean[])ret)[i]);
            }
        } else if (javaType.equals("long")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((long[])ret)[i]);
            }
        } else if (javaType.equals("java.lang.Long")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((Long[])ret)[i]);
            }
        } else if (javaType.equals("short")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((short[])ret)[i]);
            }
        } else if (javaType.equals("java.lang.Short")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((Short[])ret)[i]);
            }
        } else if (javaType.equals("java.sql.Date")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((Date[])ret)[i]);
            }
        } else if (javaType.equals("java.sql.Time")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((Time[])ret)[i]);
            }
        } else if (javaType.equals("java.sql.Timestamp")) {
            for (int i = 0; i < length; ++i) {
                wire.set(((Timestamp[])ret)[i]);
            }
        } else if (javaType.equals("byte")) {
            wire.append((byte[])ret);
        } else if (javaType.equals("char")) {
            wire.append(new String((char[])ret).getBytes("UTF-8"));
        } else if (!TypeMap.isJavaDataType(javaType)) {
            String[] orefs = this.getOrefs(javaType, ret, length, sequenceNumber);
            wire.writeHeader(MESSAGE_EXECUTE_METHOD);
            wire.set("%ListOfObjects");
            wire.set(length);
            for (int i = 0; i < length; ++i) {
                wire.set(orefs[i]);
            }
        } else {
            throw new GatewayException("Unsupported base array type: " + javaType);
        }
    }

    private Object unmarshalArray(Class<?> baseClass) throws Exception {
        int len;
        String javaType = this.gateway_inMessage.wire.getString();
        if (javaType.equals("other")) {
            javaType = baseClass.getName();
        }
        if ((len = this.gateway_inMessage.wire.getInt()) == -1) {
            return null;
        }
        if (!javaType.equals("byte") && !javaType.equals("char")) {
            javaType = this.loadClass(javaType).getComponentType().getName();
        }
        if (javaType.equals("java.lang.String")) {
            String[] x = new String[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getString();
            }
            return x;
        }
        if (javaType.equals("int")) {
            int[] x = new int[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getInt();
            }
            return x;
        }
        if (javaType.equals("java.lang.Integer")) {
            Integer[] x = new Integer[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getInt();
            }
            return x;
        }
        if (javaType.equals("double")) {
            double[] x = new double[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getDouble();
            }
            return x;
        }
        if (javaType.equals("java.lang.Double")) {
            Double[] x = new Double[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getDouble();
            }
            return x;
        }
        if (javaType.equals("float")) {
            float[] x = new float[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getFloat();
            }
            return x;
        }
        if (javaType.equals("java.lang.Float")) {
            Float[] x = new Float[len];
            for (int i = 0; i < len; ++i) {
                x[i] = Float.valueOf(this.gateway_inMessage.wire.getFloat());
            }
            return x;
        }
        if (javaType.equals("boolean")) {
            boolean[] x = new boolean[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getBoolean();
            }
            return x;
        }
        if (javaType.equals("java.lang.Boolean")) {
            Boolean[] x = new Boolean[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getBoolean();
            }
            return x;
        }
        if (javaType.equals("long")) {
            long[] x = new long[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getLong();
            }
            return x;
        }
        if (javaType.equals("java.lang.Long")) {
            Long[] x = new Long[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getLong();
            }
            return x;
        }
        if (javaType.equals("short")) {
            short[] x = new short[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getShort();
            }
            return x;
        }
        if (javaType.equals("java.lang.Short")) {
            Short[] x = new Short[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getShort();
            }
            return x;
        }
        if (javaType.equals("java.sql.Date")) {
            Date[] x = new Date[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getDate();
            }
            return x;
        }
        if (javaType.equals("java.sql.Time")) {
            Time[] x = new Time[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getTime();
            }
            return x;
        }
        if (javaType.equals("java.sql.Timestamp")) {
            Timestamp[] x = new Timestamp[len];
            for (int i = 0; i < len; ++i) {
                x[i] = this.gateway_inMessage.wire.getTimestamp();
            }
            return x;
        }
        if (javaType.equals("byte")) {
            if (len == 0) {
                return null;
            }
            return this.gateway_inMessage.wire.getRawBytes(len);
        }
        if (javaType.equals("char")) {
            if (len == 0) {
                return null;
            }
            return new String(this.gateway_inMessage.wire.getRawBytes(len)).toCharArray();
        }
        if (!TypeMap.isJavaDataType(javaType)) {
            Object x = Array.newInstance(this.loadClass(javaType), len);
            for (int i = 0; i < len; ++i) {
                Array.set(x, i, this.connection.registry_NetRemoteObject_get_object_from_oref(this.gateway_inMessage.wire.getString()));
            }
            return x;
        }
        throw new GatewayException("Unsupported base array type: " + javaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getOrefs(String javaType, Object ret, int length, int sequenceNumber) throws Exception {
        String oref;
        int i;
        int j = 0;
        String[] orefs = new String[length];
        ArrayList<Object> tempList = new ArrayList<Object>();
        for (i = 0; i < length; ++i) {
            Object javaObject = Array.get(ret, i);
            oref = this.connection.registry_NetRemoteObject_get_oref_from_object(javaObject);
            if (oref != null) {
                orefs[j] = oref;
                ++j;
                continue;
            }
            tempList.add(javaObject);
        }
        if (tempList.isEmpty()) {
            return orefs;
        }
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.gateway_outMessage.wire.writeHeader(MESSAGE_JAVA_OBJECT_CREATED);
            this.gateway_outMessage.wire.set(tempList.size());
            this.gateway_outMessage.wire.set(TypeMap.getIRISClassName(javaType));
            this.gateway_outMessage.send(sequenceNumber);
            this.gateway_inMessage.readMessage();
            for (i = 0; i < tempList.size(); ++i) {
                oref = this.gateway_inMessage.wire.getString();
                if (oref == null || oref.contains("@%Library")) continue;
                Class<?> clazz = this.loadClass(javaType);
                this.connection.registry_NetRemoteObject_insert(oref, tempList.get(i), clazz);
                orefs[j] = oref;
                ++j;
            }
        }
        return orefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOref(String javaType, Object javaObject, int sequenceNumber) throws Exception {
        String oref = this.connection.registry_NetRemoteObject_get_oref_from_object(javaObject);
        if (oref != null) {
            return oref;
        }
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.gateway_outMessage.wire.writeHeader(MESSAGE_JAVA_OBJECT_CREATED);
            this.gateway_outMessage.wire.set(1);
            this.gateway_outMessage.wire.set(TypeMap.getIRISClassName(javaType));
            this.gateway_outMessage.send(sequenceNumber);
            this.gateway_inMessage.readMessage();
            oref = this.gateway_inMessage.wire.getString();
        }
        if (oref != null && !oref.contains("@%Library")) {
            Class<?> clazz = this.loadClass(javaType);
            this.connection.registry_NetRemoteObject_insert(oref, javaObject, clazz);
        }
        this.gateway_outMessage.wire.writeHeader(MESSAGE_EXECUTE_METHOD);
        this.gateway_outMessage.wire.set(javaType);
        return oref;
    }

    void processException(Throwable e) throws Exception {
        this.processException(e, 0);
    }

    void processException(Throwable e, int sequenceNumber) throws Exception {
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bs));
            this.gateway_outMessage.wire.writeHeader(MESSAGE_EXCEPTION_RAISED);
            this.gateway_outMessage.wire.set(bs.toString());
            this.outMessage_sequenceNumber = sequenceNumber;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new GatewayException(e.getMessage());
        }
    }

    List<String> getDependencies(Class<?> cls) {
        int i;
        ArrayList<String> types = new ArrayList<String>();
        Method[] methods = cls.getMethods();
        Field[] fields = cls.getFields();
        for (i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!Modifier.isPublic(m.getModifiers())) continue;
            this.addType(m.getReturnType(), types);
            Class<?>[] args = m.getParameterTypes();
            for (int j = 0; j < args.length; ++j) {
                this.addType(args[j], types);
            }
        }
        for (i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (!Modifier.isPublic(f.getModifiers())) continue;
            this.addType(f.getType(), types);
        }
        return types;
    }

    private void addType(Class<?> clazz, List<String> types) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (JavaGateway.isPrimitiveOrWrapper(clazz) || clazz == Void.TYPE) {
            return;
        }
        String typeName = clazz.getName();
        if (this.isExcluded(typeName)) {
            return;
        }
        if (!types.contains(typeName)) {
            types.add(typeName);
        }
    }

    private boolean isExcluded(String name) {
        for (int i = 0; i < this.exclusions.size(); ++i) {
            if (!name.startsWith(this.exclusions.get(i))) continue;
            return true;
        }
        return false;
    }

    private String getClassLastCompiled(String className, String unqualifiedClassName) {
        try {
            String path = this.loadClass(className).getResource(unqualifiedClassName + ".class").getPath();
            String[] jf = path.split("!");
            if (jf.length > 1) {
                path = jf[0].substring(5, jf[0].length());
            }
            return new Timestamp(new File(path).lastModified()).toString();
        }
        catch (Exception e) {
            return new Timestamp(0L).toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String upToDate(String className, String unqualifiedClassName, int sequenceNumber) throws Exception {
        String clientTimestamp = this.getClassLastCompiled(className, unqualifiedClassName);
        String serverTimestamp = null;
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.gateway_outMessage.wire.writeHeader(MESSAGE_GET_TIMESTAMP);
            this.gateway_outMessage.wire.set(TypeMap.getIRISClassName(className));
            this.gateway_outMessage.send(sequenceNumber);
            if (this.gateway_inMessage.readMessage() != 36) {
                throw new GatewayException("Invalid timestamp for class: " + className);
            }
            serverTimestamp = this.gateway_inMessage.wire.getString();
        }
        if (clientTimestamp.equals(serverTimestamp)) {
            return null;
        }
        return clientTimestamp;
    }

    private Object[] unmarshalOverloadParameters(int cardinality, Class<?>[] parameters) throws Exception {
        Object[] arguments = new Object[cardinality];
        for (int i = 0; i < cardinality; ++i) {
            String cosType = this.gateway_inMessage.wire.getString();
            Class<?> javaType = TypeMap.getJavaClass(cosType, this.getClassLoader());
            if (javaType == null) {
                javaType = this.loadClass(cosType);
            }
            parameters[i] = javaType;
            arguments[i] = this.unmarshalParameter(javaType);
        }
        return arguments;
    }

    private Object[] unmarshalParameters(int cardinality, Class<?>[] parameters) throws Exception {
        Object[] arguments = new Object[cardinality];
        for (int i = 0; i < cardinality; ++i) {
            arguments[i] = this.unmarshalParameter(parameters[i]);
        }
        return arguments;
    }

    private Object unmarshalParameter(Class<?> javaType) throws Exception {
        if (javaType.isArray()) {
            return this.unmarshalArray(javaType);
        }
        if (javaType == String.class) {
            return this.gateway_inMessage.wire.getString();
        }
        if (javaType == Integer.TYPE) {
            return this.gateway_inMessage.wire.GetParameter("Int");
        }
        if (javaType == Integer.class) {
            return this.gateway_inMessage.wire.GetParameter("Int");
        }
        if (javaType == Long.TYPE) {
            return this.gateway_inMessage.wire.GetParameter("Long");
        }
        if (javaType == Long.class) {
            return this.gateway_inMessage.wire.GetParameter("Long");
        }
        if (javaType == Short.TYPE) {
            return this.gateway_inMessage.wire.GetParameter("Short");
        }
        if (javaType == Short.class) {
            return this.gateway_inMessage.wire.GetParameter("Short");
        }
        if (javaType == Double.TYPE) {
            return this.gateway_inMessage.wire.GetParameter("Double");
        }
        if (javaType == Double.class) {
            return this.gateway_inMessage.wire.GetParameter("Double");
        }
        if (javaType == Float.TYPE) {
            return this.gateway_inMessage.wire.GetParameter("Float");
        }
        if (javaType == Float.class) {
            return this.gateway_inMessage.wire.GetParameter("Float");
        }
        if (javaType == Boolean.TYPE) {
            return this.gateway_inMessage.wire.GetParameter("Boolean");
        }
        if (javaType == Boolean.class) {
            return this.gateway_inMessage.wire.GetParameter("Boolean");
        }
        if (javaType == Byte.TYPE) {
            return this.gateway_inMessage.wire.getByte();
        }
        if (javaType == Byte.class) {
            return this.gateway_inMessage.wire.getByte();
        }
        if (javaType == Character.TYPE) {
            return Character.valueOf(this.gateway_inMessage.wire.getString().toCharArray()[0]);
        }
        if (javaType == Character.class) {
            return Character.valueOf(this.gateway_inMessage.wire.getString().toCharArray()[0]);
        }
        if (javaType == StringBuffer.class) {
            return new StringBuffer(this.gateway_inMessage.wire.getString());
        }
        if (javaType == Date.class) {
            return this.gateway_inMessage.wire.getDate();
        }
        if (javaType == Time.class) {
            return this.gateway_inMessage.wire.getTime();
        }
        if (javaType == Timestamp.class) {
            return this.gateway_inMessage.wire.getTimestamp();
        }
        String oref = this.gateway_inMessage.wire.getString();
        Object temp = this.connection.registry_NetRemoteObject_get_object_from_oref(oref);
        if (temp == null) {
            return oref;
        }
        return temp;
    }

    private void marshalReturnValue(Class<?> returnType, Object ret, int sequenceNumber) throws Exception {
        String cosType;
        String typeName = returnType.getName();
        if (ret != null && typeName.equals("java.lang.Object") && !Proxy.isProxyClass(ret.getClass())) {
            typeName = ret.getClass().getName();
        }
        if (TypeMap.isJavaDataType(typeName)) {
            cosType = this.irisType.get(typeName);
            this.gateway_outMessage.wire.set(cosType);
        }
        if (typeName.equals("int")) {
            this.gateway_outMessage.wire.set((Integer)ret);
        } else if (typeName.equals("double")) {
            this.gateway_outMessage.wire.set((Double)ret);
        } else if (typeName.equals("float")) {
            this.gateway_outMessage.wire.set((Float)ret);
        } else if (typeName.equals("boolean")) {
            this.gateway_outMessage.wire.set((Boolean)ret);
        } else if (typeName.equals("short")) {
            this.gateway_outMessage.wire.set((Short)ret);
        } else if (typeName.equals("long")) {
            this.gateway_outMessage.wire.set((Long)ret);
        } else if (typeName.equals("java.lang.String")) {
            if (ret != null && ((String)ret).length() == 0) {
                this.gateway_outMessage.wire.set((String)null);
            } else {
                this.gateway_outMessage.wire.set((String)ret);
            }
        } else if (typeName.equals("java.lang.Integer")) {
            this.gateway_outMessage.wire.set((Integer)ret);
        } else if (typeName.equals("java.lang.Boolean")) {
            this.gateway_outMessage.wire.set((Boolean)ret);
        } else if (typeName.equals("java.lang.Double")) {
            this.gateway_outMessage.wire.set((Double)ret);
        } else if (typeName.equals("java.lang.Float")) {
            this.gateway_outMessage.wire.set((Float)ret);
        } else if (typeName.equals("java.lang.Long")) {
            this.gateway_outMessage.wire.set((Long)ret);
        } else if (typeName.equals("java.lang.Short")) {
            this.gateway_outMessage.wire.set((Short)ret);
        } else if (typeName.equals("java.sql.Date")) {
            this.gateway_outMessage.wire.set((Date)ret);
        } else if (typeName.equals("java.sql.Time")) {
            this.gateway_outMessage.wire.set((Time)ret);
        } else if (typeName.equals("java.sql.Timestamp")) {
            this.gateway_outMessage.wire.set((Timestamp)ret);
        } else if (typeName.equals("byte")) {
            byte[] x = new byte[]{(Byte)ret};
            this.gateway_outMessage.wire.set(x);
        } else if (typeName.equals("char")) {
            this.gateway_outMessage.wire.set(((Character)ret).toString());
        } else if (returnType.isArray()) {
            this.marshalArray(this.gateway_outMessage.wire, ret, typeName, sequenceNumber);
        } else {
            cosType = this.irisType.get(typeName);
            this.gateway_outMessage.wire.set(cosType);
            if (ret == null) {
                this.gateway_outMessage.wire.setNull();
            } else {
                if (cosType == null || cosType.equals("")) {
                    cosType = typeName;
                }
                this.gateway_outMessage.wire.set(this.getOref(cosType, ret, sequenceNumber));
            }
        }
    }

    boolean exclude(String name) {
        for (int i = 0; i < this.exclusions.size(); ++i) {
            if (!name.startsWith(this.exclusions.get(i))) continue;
            return true;
        }
        return false;
    }

    private void getJDBCGatewayMessage() throws Exception {
        if (this.jdbcGateway == null) {
            this.jdbcGateway = new JDBCGateway();
        }
        try {
            JDBCGatewayHelper.processMessage(this.jdbcGateway, this.gateway_inMessage.wire, this.gateway_outMessage.wire, this.connection.conParams.getLogFile());
            this.outMessage_sequenceNumber = 0;
        }
        catch (Throwable e) {
            this.processException(e);
        }
    }

    void redirectOutput() throws Exception {
        if (!this.connection.disableOutputRedirect && outputRedirect.wasWrittenTo()) {
            this.gateway_outMessage.wire.set(outputRedirect.getBufferContents());
        } else {
            this.gateway_outMessage.wire.setUndefined();
        }
        if (!this.connection.disableOutputRedirect && errorRedirect.wasWrittenTo()) {
            this.gateway_outMessage.wire.set(errorRedirect.getBufferContents());
        } else {
            this.gateway_outMessage.wire.setUndefined();
        }
    }

    void setRedirect() throws Exception {
        if (!this.connection.disableOutputRedirect) {
            outputRedirect.register();
            errorRedirect.register();
        }
    }

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        return type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.class) || type.equals(Long.TYPE) || type.equals(Short.class) || type.equals(Short.TYPE) || type.equals(Float.class) || type.equals(Float.TYPE) || type.equals(Double.class) || type.equals(Double.TYPE) || type.equals(Character.class) || type.equals(Character.TYPE) || type.equals(Byte.class) || type.equals(Byte.TYPE) || type.equals(Boolean.class) || type.equals(Boolean.TYPE) || type.equals(String.class) || type.equals(Date.class) || type.equals(Time.class) || type.equals(Timestamp.class);
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] allFields = clazz.getFields();
        for (int i = 0; i < allFields.length; ++i) {
            Field field = allFields[i];
            int modifier = field.getModifiers();
            if (!Modifier.isPublic(modifier) || Modifier.isFinal(modifier) && Modifier.isStatic(modifier) && !field.isSynthetic()) continue;
            fields.add(field);
        }
        return fields;
    }

    private void fetchObject() throws Exception {
        int sequenceNumber = 0;
        try {
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            int closedProxyCount = this.gateway_inMessage.wire.getInt();
            if (closedProxyCount > 0) {
                this.updateOrefRegistry(closedProxyCount);
            }
            String oref = this.gateway_inMessage.wire.getString();
            this.log(" >> FETCH_OBJECT: " + oref);
            Object javaObject = this.connection.registry_NetRemoteObject_get_object_from_oref(oref);
            List<Field> fields = JavaGateway.getAllFields(javaObject.getClass());
            BufferWrite tempWire = new BufferWrite(null);
            tempWire.writeHeader(MESSAGE_FETCH_OBJECT);
            tempWire.set(fields.size());
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(i);
                tempWire.set(field.getName());
                this.marshalField(tempWire, field.get(javaObject), sequenceNumber);
            }
            this.gateway_outMessage.wire = tempWire;
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << FETCH_OBJECT");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private void sendObject() throws Exception {
        int sequenceNumber = 0;
        try {
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            int closedProxyCount = this.gateway_inMessage.wire.getInt();
            if (closedProxyCount > 0) {
                this.updateOrefRegistry(closedProxyCount);
            }
            String oref = this.gateway_inMessage.wire.getString();
            this.log(" >> SEND_OBJECT: " + oref);
            Object javaObject = this.connection.registry_NetRemoteObject_get_object_from_oref(oref);
            int count = this.gateway_inMessage.wire.getInt();
            for (int i = 0; i < count; ++i) {
                String name = this.gateway_inMessage.wire.getString();
                Field field = javaObject.getClass().getField(name);
                field.set(javaObject, this.unmarshalParameter(field.getType()));
            }
            this.gateway_outMessage.wire.writeHeader(MESSAGE_SEND_OBJECT);
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << SEND_OBJECT");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private void marshalField(BufferWrite wire, Object value, int sequenceNumber) throws Exception {
        if (value == null) {
            wire.set(0);
            wire.setNull();
            return;
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            wire.set(2);
            this.marshalArray(wire, value, type.getName(), sequenceNumber);
            return;
        }
        if (type == Integer.TYPE) {
            wire.set(0);
            wire.set((Integer)value);
        } else if (type == Double.TYPE) {
            wire.set(0);
            wire.set((Double)value);
        } else if (type == Float.TYPE) {
            wire.set(0);
            wire.set((Float)value);
        } else if (type == Boolean.TYPE) {
            wire.set(0);
            wire.set((Boolean)value);
        } else if (type == Short.TYPE) {
            wire.set(0);
            wire.set((Short)value);
        } else if (type == Long.TYPE) {
            wire.set(0);
            wire.set((Long)value);
        } else if (type == String.class) {
            wire.set(0);
            wire.set((String)value);
        } else if (type == Integer.class) {
            wire.set(0);
            wire.set((Integer)value);
        } else if (type == Boolean.class) {
            wire.set(0);
            wire.set((Boolean)value);
        } else if (type == Double.class) {
            wire.set(0);
            wire.set((Double)value);
        } else if (type == Float.class) {
            wire.set(0);
            wire.set((Float)value);
        } else if (type == Long.class) {
            wire.set(0);
            wire.set((Long)value);
        } else if (type == Short.class) {
            wire.set(0);
            wire.set((Short)value);
        } else if (type == Date.class) {
            wire.set(0);
            wire.set((Date)value);
        } else if (type == Time.class) {
            wire.set(0);
            wire.set((Time)value);
        } else if (type == Timestamp.class) {
            wire.set(0);
            wire.set((Timestamp)value);
        } else if (type == Byte.TYPE) {
            wire.set(0);
            byte[] x = new byte[]{(Byte)value};
            wire.set(x);
        } else if (type == Character.TYPE) {
            wire.set(0);
            wire.set(((Character)value).toString());
        } else {
            String oref = this.getOrefShort(value.getClass().getName(), value, sequenceNumber);
            wire.set(1);
            wire.set(oref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrefShort(String javaType, Object javaObject, int sequenceNumber) throws Exception {
        String oref = this.connection.registry_NetRemoteObject_get_oref_from_object(javaObject);
        if (oref != null) {
            return oref;
        }
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.gateway_outMessage.wire.writeHeader(MESSAGE_JAVA_OBJECT_CREATED);
            this.gateway_outMessage.wire.set(1);
            this.gateway_outMessage.wire.set(TypeMap.getIRISClassName(javaType));
            this.gateway_outMessage.send(sequenceNumber);
            this.gateway_inMessage.readMessage();
            oref = this.gateway_inMessage.wire.getString();
        }
        return oref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadCOSClass(String javaName, String cosName, String text) throws Exception {
        int sequenceNumber = 0;
        try {
            this.log(" >> LOAD COS CLASS");
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            IRISConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.gateway_outMessage.wire.writeHeader(MESSAGE_LOAD_COS_CLASS);
                this.gateway_outMessage.wire.set(javaName);
                this.gateway_outMessage.wire.set(cosName);
                if (text.length() < 16000) {
                    this.gateway_outMessage.wire.set(1);
                    this.gateway_outMessage.wire.set(text);
                } else {
                    int chunks = text.length() / 16000;
                    if (text.length() % 16000 > 0) {
                        ++chunks;
                    }
                    this.gateway_outMessage.wire.set(chunks);
                    while (text.length() > 16000) {
                        this.gateway_outMessage.wire.set(text.substring(0, 16000));
                        text = text.substring(16000);
                    }
                    if (text.length() > 0) {
                        this.gateway_outMessage.wire.set(text);
                    }
                }
                this.gateway_outMessage.send(sequenceNumber);
            }
            this.log(" << LOAD COS CLASS");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private void addToClassLoader(String jarFileName, boolean useSystemLoader) throws Exception {
        if (jarFileName == null) {
            return;
        }
        if (useSystemLoader && java.lang.ClassLoader.getSystemClassLoader() instanceof ClassLoader) {
            ((ClassLoader)java.lang.ClassLoader.getSystemClassLoader()).addURL(new File(jarFileName).toURI().toURL());
        } else {
            this.getClassLoader().addURL(new File(jarFileName).toURI().toURL());
        }
    }

    private String[] getClassNamesFromJar(String jarFileName, String ifaceName) throws Exception {
        JarEntry jarEntry;
        JarInputStream jarFile = new JarInputStream(new FileInputStream(jarFileName));
        ArrayList<String> classNames = new ArrayList<String>();
        this.addToClassLoader(jarFileName, false);
        Class<?> iface = null;
        if (ifaceName != null) {
            iface = this.getClassLoader().loadClass(ifaceName);
        }
        while ((jarEntry = jarFile.getNextJarEntry()) != null) {
            String name;
            if (jarEntry.isDirectory() || !(name = jarEntry.getName()).endsWith(".class")) continue;
            name = name.substring(0, name.length() - 6).replaceAll("/", "\\.");
            Class<?> clazz = this.getClassLoader().loadClass(name);
            if (!Modifier.isPublic(clazz.getModifiers())) continue;
            if (iface == null) {
                classNames.add(name);
                continue;
            }
            if (!iface.isAssignableFrom(clazz)) continue;
            classNames.add(name);
        }
        String[] c = new String[classNames.size()];
        classNames.toArray(c);
        jarFile.close();
        return c;
    }

    private void serviceCall() throws Throwable {
        int sequenceNumber = 0;
        try {
            Object serviceObject;
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            String serviceName = this.gateway_inMessage.wire.getString();
            byte[] arguments = this.gateway_inMessage.wire.getByteArray();
            this.log(" >> SERVICE_CALL: " + serviceName);
            Method service = this.serviceMethods.get(serviceName);
            if (service == null) {
                Class<?> serviceClass = this.loadClass(serviceName);
                serviceObject = serviceClass.newInstance();
                this.services.put(serviceName, serviceObject);
                service = serviceClass.getDeclaredMethod("execute", byte[].class);
                this.serviceMethods.put(serviceName, service);
            } else {
                serviceObject = this.services.get(serviceName);
            }
            byte[] result = (byte[])service.invoke(serviceObject, new Object[]{arguments});
            this.gateway_outMessage.wire.writeHeader(MESSAGE_SERVICE_CALL);
            this.gateway_outMessage.wire.set(result);
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << SERVICE_CALL");
        }
        catch (InvocationTargetException ite) {
            this.processException(ite.getTargetException(), sequenceNumber);
        }
        catch (Exception e) {
            this.processException(e, sequenceNumber);
        }
    }

    private void benchmarkEcho() throws Throwable {
        int sequenceNumber = 0;
        try {
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            this.gateway_outMessage.wire.writeHeader(MESSAGE_BENCHMARK_ECHO);
            this.outMessage_sequenceNumber = sequenceNumber;
        }
        catch (Exception e) {
            this.processException(e, sequenceNumber);
        }
    }

    private void xslt_request(int xslt_version) throws Throwable {
        int sequenceNumber = 0;
        try {
            this.log(" >> XSLT_REQUEST");
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            if (this.xslt_instance == null) {
                String className = "com.intersystems.xsltgateway.XSLTGateway";
                Class<?> instanceType = this.loadClass(className);
                Constructor<?> constructor = this.dynamicFindConstructor(className, 3, false);
                Object[] parameters = new Object[]{this.connection, this.gateway_inMessage, this.gateway_outMessage};
                this.xslt_instance = constructor.newInstance(parameters);
                this.xslt_handler2 = this.dynamicFindMethod(instanceType, "processXSLT2Request", 0, false);
                if (this.xslt_handler2 == null) {
                    throw new GatewayException("Method not found: " + className + ".processXSLT2Request(0)");
                }
                this.xslt_handler3 = this.dynamicFindMethod(instanceType, "processXSLT3Request", 0, false);
                if (this.xslt_handler3 == null) {
                    throw new GatewayException("Method not found: " + className + ".processXSLT3Request(0)");
                }
            }
            if (xslt_version == 2) {
                this.xslt_handler2.invoke(this.xslt_instance, null);
            } else if (xslt_version == 3) {
                this.xslt_handler3.invoke(this.xslt_instance, null);
            } else {
                throw new GatewayException("Invalid XSLT version.");
            }
            this.outMessage_sequenceNumber = sequenceNumber;
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private Constructor<?> dynamicFindConstructor(String classNameWithParameterSpecs, int parameterCount, boolean isRecast) throws Throwable {
        String[] parameterSpecs;
        String className;
        String cacheKey = classNameWithParameterSpecs + ":" + parameterCount;
        Constructor constructor = this.cachedConstructors.get(cacheKey);
        if (constructor != null) {
            return constructor;
        }
        int start = classNameWithParameterSpecs.indexOf("(");
        if (start == -1) {
            className = classNameWithParameterSpecs;
            parameterSpecs = null;
        } else {
            int end = classNameWithParameterSpecs.indexOf(")", start);
            className = classNameWithParameterSpecs.substring(0, start);
            String parameter_specs_string = classNameWithParameterSpecs.substring(start + 1, end);
            if (parameter_specs_string.isEmpty()) {
                parameterSpecs = new String[]{};
            } else {
                parameterSpecs = parameter_specs_string.split(",");
                this.normalizeParameterSpecs(parameterSpecs);
            }
        }
        Class<?> clazz = this.loadClass(className);
        if (clazz == null) {
            throw new GatewayException("Class not found: " + className);
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new GatewayException("Class not accessible: " + clazz.getName());
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        ArrayList foundConstructorsPhase1 = new ArrayList();
        ArrayList foundConstructorsPhase2 = new ArrayList();
        for (Constructor<?> c : constructors) {
            if (parameterSpecs != null && !this.isParameterSpecsMatch(c.getParameterTypes(), parameterSpecs)) continue;
            if (!isRecast && c.isVarArgs() && parameterCount >= c.getParameterTypes().length - 1) {
                foundConstructorsPhase2.add(c);
                continue;
            }
            if (c.getParameterTypes().length != parameterCount) continue;
            foundConstructorsPhase1.add(c);
        }
        if (foundConstructorsPhase1.size() == 1) {
            constructor = (Constructor)foundConstructorsPhase1.get(0);
            this.cachedConstructors.put(cacheKey, constructor);
            return constructor;
        }
        if (foundConstructorsPhase1.size() > 1) {
            return this.dynamicResolveConstructorOverloading(className, foundConstructorsPhase1, parameterCount, isRecast);
        }
        if (foundConstructorsPhase2.size() == 1) {
            constructor = (Constructor)foundConstructorsPhase2.get(0);
            this.cachedConstructors.put(cacheKey, constructor);
            return constructor;
        }
        if (foundConstructorsPhase2.size() > 1) {
            return this.dynamicResolveConstructorOverloading(className, foundConstructorsPhase2, parameterCount, isRecast);
        }
        throw new GatewayException("Constructor not found: " + className + "(" + parameterCount + ")");
    }

    private Constructor<?> dynamicResolveConstructorOverloading(String className, ArrayList<Constructor<?>> foundConstructors, int parameterCount, boolean isRecast) throws Throwable {
        int pCount;
        Class<?>[] runtimeParameterTypes = this.peekRuntimeParameterTypes(parameterCount);
        boolean[] typeHasNoVariations = new boolean[parameterCount];
        for (pCount = 0; pCount < parameterCount; ++pCount) {
            HashMap typeVariations = new HashMap();
            for (Constructor<?> constructor : foundConstructors) {
                Class<?> type = !isRecast && constructor.isVarArgs() && pCount >= constructor.getParameterTypes().length - 1 ? constructor.getParameterTypes()[constructor.getParameterTypes().length - 1].getComponentType() : constructor.getParameterTypes()[pCount];
                typeVariations.put(this.box(type).getName(), null);
                if (typeVariations.size() <= 1) continue;
                break;
            }
            typeHasNoVariations[pCount] = typeVariations.size() == 1;
        }
        for (pCount = 0; pCount < parameterCount; ++pCount) {
            if (typeHasNoVariations[pCount]) continue;
            Iterator<Constructor<?>> it = foundConstructors.iterator();
            while (it.hasNext()) {
                Constructor<?> constructor = it.next();
                Class<?> type = !isRecast && constructor.isVarArgs() && pCount >= constructor.getParameterTypes().length - 1 ? constructor.getParameterTypes()[constructor.getParameterTypes().length - 1].getComponentType() : constructor.getParameterTypes()[pCount];
                if (this.isTypeMatch(type, runtimeParameterTypes[pCount], isRecast)) continue;
                it.remove();
            }
        }
        if (foundConstructors.size() == 0) {
            throw new GatewayException("Unable to find a constructor in overloading resolution: " + className + "(" + parameterCount + ")");
        }
        if (foundConstructors.size() == 1) {
            return foundConstructors.get(0);
        }
        throw new GatewayException("Unable to resolve constructor overloading ambiguity: " + className + "(" + parameterCount + ")");
    }

    private Method dynamicFindMethod(Type type, String methodNameWithParameterSpecs, int parameterCount, boolean isRecast) throws Throwable {
        String[] parameterSpecs;
        String methodName;
        Class clazz = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        String className = clazz.getName();
        String cacheKey = className + ":" + methodNameWithParameterSpecs + ":" + parameterCount;
        Method method = this.cachedMethods.get(cacheKey);
        if (method != null) {
            return method;
        }
        int start = methodNameWithParameterSpecs.indexOf("(");
        if (start == -1) {
            methodName = methodNameWithParameterSpecs;
            parameterSpecs = null;
        } else {
            int end = methodNameWithParameterSpecs.indexOf(")", start);
            methodName = methodNameWithParameterSpecs.substring(0, start);
            String parameter_specs_string = methodNameWithParameterSpecs.substring(start + 1, end);
            if (parameter_specs_string.isEmpty()) {
                parameterSpecs = new String[]{};
            } else {
                parameterSpecs = parameter_specs_string.split(",");
                this.normalizeParameterSpecs(parameterSpecs);
            }
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new GatewayException("Class not accessible: " + className);
        }
        Method[] methods = clazz.getMethods();
        ArrayList<Method> foundMethodsPhase1 = new ArrayList<Method>();
        ArrayList<Method> foundMethodsPhase2 = new ArrayList<Method>();
        for (Method m : methods) {
            String mutatedName = m.getName().replace("_", "u");
            if (!m.getName().equals(methodName) && !mutatedName.equals(methodName) || parameterSpecs != null && !this.isParameterSpecsMatch(m.getParameterTypes(), parameterSpecs)) continue;
            boolean skipMethod = true;
            boolean isVarArgs = false;
            if (!isRecast && m.isVarArgs() && parameterCount >= m.getParameterTypes().length - 1) {
                skipMethod = false;
                isVarArgs = true;
            } else if (m.getParameterTypes().length == parameterCount) {
                skipMethod = false;
            }
            if (skipMethod) continue;
            Class<?>[] parameterTypes = m.getParameterTypes();
            for (int p = 0; p < parameterTypes.length; ++p) {
                if (Modifier.isPublic(parameterTypes[p].getModifiers())) continue;
                skipMethod = true;
                break;
            }
            if (skipMethod) continue;
            if (isVarArgs) {
                foundMethodsPhase2.add(m);
                continue;
            }
            foundMethodsPhase1.add(m);
        }
        if (foundMethodsPhase1.size() == 1) {
            method = (Method)foundMethodsPhase1.get(0);
            this.cachedMethods.put(cacheKey, method);
            return method;
        }
        if (foundMethodsPhase1.size() > 1) {
            return this.dynamicResolveMethodOverloading(className + "." + methodName, foundMethodsPhase1, parameterCount, isRecast);
        }
        if (foundMethodsPhase2.size() == 1) {
            method = (Method)foundMethodsPhase2.get(0);
            this.cachedMethods.put(cacheKey, method);
            return method;
        }
        if (foundMethodsPhase2.size() > 1) {
            return this.dynamicResolveMethodOverloading(className + "." + methodName, foundMethodsPhase2, parameterCount, isRecast);
        }
        return null;
    }

    private void normalizeParameterSpecs(String[] ParameterSpecs) {
        for (int i = 0; i < ParameterSpecs.length; ++i) {
            ParameterSpecs[i] = this.normalizeOneParameterSpec(ParameterSpecs[i]);
        }
    }

    private String normalizeOneParameterSpec(String type) {
        switch (type) {
            case "String": {
                return "java.lang.String";
            }
        }
        return type;
    }

    private boolean isParameterSpecsMatch(Class<?>[] parameters, String[] ParameterSpecs) {
        if (ParameterSpecs.length > parameters.length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (i >= ParameterSpecs.length) {
                return false;
            }
            if (ParameterSpecs[i].equals("...")) {
                return true;
            }
            if (ParameterSpecs[i].equals("*") || parameters[i].getName().equals(ParameterSpecs[i])) continue;
            return false;
        }
        return true;
    }

    private Method dynamicResolveMethodOverloading(String fullMethodName, ArrayList<Method> foundMethods, int parameterCount, boolean isRecast) throws Throwable {
        int pCount;
        Class<?>[] runtimeParameterTypes = this.peekRuntimeParameterTypes(parameterCount);
        boolean[] typeHasNoVariations = new boolean[parameterCount];
        for (pCount = 0; pCount < parameterCount; ++pCount) {
            HashMap typeVariations = new HashMap();
            for (Method method : foundMethods) {
                Class<?> type = !isRecast && method.isVarArgs() && pCount >= method.getParameterTypes().length - 1 ? method.getParameterTypes()[method.getParameterTypes().length - 1].getComponentType() : method.getParameterTypes()[pCount];
                typeVariations.put(this.box(type).getName(), null);
                if (typeVariations.size() <= 1) continue;
                break;
            }
            typeHasNoVariations[pCount] = typeVariations.size() == 1;
        }
        for (pCount = 0; pCount < parameterCount; ++pCount) {
            if (typeHasNoVariations[pCount]) continue;
            Iterator<Method> it = foundMethods.iterator();
            while (it.hasNext()) {
                Method method = it.next();
                Class<?> type = !isRecast && method.isVarArgs() && pCount >= method.getParameterTypes().length - 1 ? method.getParameterTypes()[method.getParameterTypes().length - 1].getComponentType() : method.getParameterTypes()[pCount];
                if (this.isTypeMatch(type, runtimeParameterTypes[pCount], isRecast)) continue;
                it.remove();
            }
        }
        if (foundMethods.size() == 0) {
            throw new GatewayException("Unable to find a method in overloading resolution: " + fullMethodName + "(" + parameterCount + ")");
        }
        if (foundMethods.size() == 1) {
            return foundMethods.get(0);
        }
        throw new GatewayException("Unable to resolve method overloading ambiguity: " + fullMethodName + "(" + parameterCount + ")");
    }

    private Class<?>[] peekRuntimeParameterTypes(int parameterCount) throws Throwable {
        String[] runtimeParameterTypeFamilies = this.gateway_inMessage.wire.peekListTypeFamilies(parameterCount);
        Class[] runtimeParameterTypes = new Class[parameterCount];
        block10: for (int i = 0; i < runtimeParameterTypeFamilies.length; ++i) {
            if (runtimeParameterTypeFamilies[i] == null) {
                runtimeParameterTypes[i] = null;
                continue;
            }
            switch (runtimeParameterTypeFamilies[i]) {
                case "%long": {
                    runtimeParameterTypes[i] = Long.class;
                    continue block10;
                }
                case "%double": {
                    runtimeParameterTypes[i] = Double.class;
                    continue block10;
                }
                case "%string": {
                    runtimeParameterTypes[i] = String.class;
                    continue block10;
                }
                default: {
                    Object obj = this.connection.registry_NetRemoteObject_get_object_from_oref(runtimeParameterTypeFamilies[i]);
                    runtimeParameterTypes[i] = obj != null ? obj.getClass() : IRISObject.class;
                }
            }
        }
        return runtimeParameterTypes;
    }

    private Class<?> box(Class<?> type) {
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }

    private boolean isTypeMatch(Class<?> declaredType, Class<?> runtimeType, boolean isRecast) {
        if (runtimeType == null) {
            return !declaredType.isPrimitive();
        }
        if (isRecast && declaredType.isArray()) {
            return runtimeType == IRISObject.class;
        }
        if (declaredType == Byte.TYPE || declaredType == Byte.class) {
            return runtimeType == String.class;
        }
        if (declaredType == Character.TYPE || declaredType == Character.class) {
            return runtimeType == String.class;
        }
        if (declaredType == Short.TYPE || declaredType == Short.class) {
            return runtimeType == Long.class;
        }
        if (declaredType == Integer.TYPE || declaredType == Integer.class) {
            return runtimeType == Long.class;
        }
        if (declaredType == Long.TYPE || declaredType == Long.class) {
            return runtimeType == Long.class;
        }
        if (declaredType == Float.TYPE || declaredType == Float.class) {
            return runtimeType == Double.class;
        }
        if (declaredType == Double.TYPE || declaredType == Double.class) {
            return runtimeType == Double.class;
        }
        if (declaredType == Boolean.TYPE || declaredType == Boolean.class) {
            return runtimeType == Long.class;
        }
        if (declaredType == String.class) {
            return runtimeType == String.class;
        }
        if (declaredType == Date.class) {
            return runtimeType == String.class;
        }
        if (declaredType == Time.class) {
            return runtimeType == String.class;
        }
        if (declaredType == Timestamp.class) {
            return runtimeType == String.class;
        }
        if (declaredType == IRISList.class) {
            return runtimeType == String.class;
        }
        return declaredType.isAssignableFrom(runtimeType);
    }

    private Field dynamicFindField(Type type, String fieldName) throws Throwable {
        Class clazz = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        String className = clazz.getName();
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new GatewayException("Class not accessible: " + className);
        }
        Field field = null;
        try {
            field = clazz.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            field = null;
        }
        if (field != null && !Modifier.isPublic(field.getType().getModifiers())) {
            field = null;
        }
        if (field == null) {
            Field[] fields;
            for (Field f : fields = clazz.getFields()) {
                String mutatedName;
                if (!Modifier.isPublic(f.getType().getModifiers()) || !fieldName.equals(mutatedName = f.getName().replace("_", "u"))) continue;
                field = f;
                break;
            }
        }
        return field;
    }

    private Object[] dynamicUnmarshalParameters(int cardinality, Class<?>[] parameterTypes, boolean isVarArgs, boolean isRecast) throws Exception {
        int parameterLength = parameterTypes.length;
        Object[] arguments = new Object[parameterLength];
        if (isVarArgs && !isRecast) {
            for (int i = 0; i < parameterLength - 1; ++i) {
                arguments[i] = this.dynamicUnmarshalParameter(parameterTypes[i], isRecast);
            }
            Class<?> varargType = parameterTypes[parameterLength - 1].getComponentType();
            int varargLength = cardinality - parameterLength + 1;
            Object varargArray = Array.newInstance(varargType, varargLength);
            for (int i = 0; i < varargLength; ++i) {
                Array.set(varargArray, i, this.dynamicUnmarshalParameter(varargType, isRecast));
            }
            arguments[parameterLength - 1] = varargArray;
        } else {
            int i;
            for (i = 0; i < parameterLength; ++i) {
                arguments[i] = this.dynamicUnmarshalParameter(parameterTypes[i], isRecast, true);
            }
            if (isRecast) {
                for (i = 0; i < parameterLength; ++i) {
                    if (!parameterTypes[i].isArray()) continue;
                    arguments[i] = this.dynamicUnmarshalParameterFetchRecastData((String)arguments[i], parameterTypes[i].getComponentType());
                }
            }
        }
        return arguments;
    }

    private Object dynamicUnmarshalParameter(Class<?> javaType, boolean isRecast) throws Exception {
        return this.dynamicUnmarshalParameter(javaType, isRecast, false);
    }

    private Object dynamicUnmarshalParameter(Class<?> javaType, boolean isRecast, boolean delayFetching) throws Exception {
        if (isRecast && javaType.isArray()) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            String oref = this.gateway_inMessage.wire.getString();
            if (delayFetching) {
                return oref;
            }
            return this.dynamicUnmarshalParameterFetchRecastData(oref, javaType.getComponentType());
        }
        if (javaType == Byte.TYPE || javaType == Byte.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            byte[] ba = this.gateway_inMessage.wire.getByteArray();
            if (ba != null) {
                return ba[0];
            }
            return javaType == Byte.class ? null : Byte.valueOf((byte)0);
        }
        if (javaType == Character.TYPE || javaType == Character.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            String cstring = this.gateway_inMessage.wire.getStringWithAsciiZero();
            if (cstring != null) {
                return Character.valueOf(cstring.charAt(0));
            }
            return javaType == Character.class ? null : Character.valueOf('\u0000');
        }
        if (javaType == Short.TYPE) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getShort();
        }
        if (javaType == Short.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getNullableShort();
        }
        if (javaType == Integer.TYPE) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getInt();
        }
        if (javaType == Integer.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getNullableInt();
        }
        if (javaType == Long.TYPE) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getLong();
        }
        if (javaType == Long.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getNullableLong();
        }
        if (javaType == Float.TYPE) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return Float.valueOf(this.gateway_inMessage.wire.getFloat());
        }
        if (javaType == Float.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getNullableFloat();
        }
        if (javaType == Double.TYPE) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getDouble();
        }
        if (javaType == Double.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getNullableDouble();
        }
        if (javaType == Boolean.TYPE) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getBoolean();
        }
        if (javaType == Boolean.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getNullableBoolean();
        }
        if (javaType == BigDecimal.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getNullableBigDecimal();
        }
        if (javaType == String.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getStringWithAsciiZero();
        }
        if (javaType == Date.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getDate();
        }
        if (javaType == Time.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getTime();
        }
        if (javaType == Timestamp.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            return this.gateway_inMessage.wire.getTimestamp();
        }
        if (javaType == IRISList.class) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            byte[] bytearray = this.gateway_inMessage.wire.getByteArray();
            return new IRISList(bytearray, bytearray.length, this.connection.connectionInfo.serverLocale, this.connection.connectionInfo.compactDoubleEnabled);
        }
        if (this.connection.getProtocolVersion() < 58) {
            this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
            String stringValue = this.gateway_inMessage.wire.getStringWithAsciiZero();
            Object javaObject = this.connection.registry_NetRemoteObject_get_object_from_oref(stringValue);
            return javaObject != null ? javaObject : stringValue;
        }
        Object javaObject = this.gateway_inMessage.wire.getObjectWithAsciiZero(true);
        if (javaObject instanceof IRISOREF) {
            javaObject = this.connection.registry_map_oref_to_object(((IRISOREF)javaObject).oref);
        }
        return javaObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dynamicUnmarshalParameterFetchRecastData(String oref, Class<?> componentType) throws Exception {
        IRISConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            if (oref == null) {
                return null;
            }
            if (componentType == Byte.class || componentType == Byte.TYPE || componentType == Character.class || componentType == Character.TYPE) {
                this.gateway_outMessage.wire.writeHeader(MESSAGE_RECAST_GET_STREAM);
                this.gateway_outMessage.wire.set(oref);
                int sequenceNumber = this.connection.messageCount.getCount();
                this.gateway_outMessage.send(sequenceNumber);
                this.gateway_inMessage.readMessage(sequenceNumber);
                String type = this.gateway_inMessage.wire.getString();
                if (type != null && type.equals("error")) {
                    throw new SQLException(this.gateway_inMessage.wire.getString());
                }
                int size = this.gateway_inMessage.wire.getInt();
                if (componentType == Byte.class || componentType == Byte.TYPE) {
                    Object array = Array.newInstance(componentType, size);
                    if (size > 0) {
                        int pointer = 0;
                        do {
                            byte[] chunk = this.gateway_inMessage.wire.getByteArray();
                            for (int i = 0; i < chunk.length; ++i) {
                                Array.set(array, pointer++, chunk[i]);
                            }
                        } while (pointer < size);
                    }
                    return array;
                }
                Object array = Array.newInstance(componentType, size);
                if (size > 0) {
                    int pointer = 0;
                    do {
                        String chunk = this.gateway_inMessage.wire.getStringWithAsciiZero();
                        for (int i = 0; i < chunk.length(); ++i) {
                            Array.set(array, pointer++, Character.valueOf(chunk.charAt(i)));
                        }
                    } while (pointer < size);
                }
                return array;
            }
            this.gateway_outMessage.wire.writeHeader(MESSAGE_RECAST_GET_LIST);
            this.gateway_outMessage.wire.set(oref);
            int sequenceNumber = this.connection.messageCount.getCount();
            this.gateway_outMessage.send(sequenceNumber);
            this.gateway_inMessage.readMessage(sequenceNumber);
            String type = this.gateway_inMessage.wire.getString();
            if (type != null && type.equals("error")) {
                throw new SQLException(this.gateway_inMessage.wire.getString());
            }
            int count = this.gateway_inMessage.wire.getInt();
            if (componentType == Short.TYPE) {
                short[] array = new short[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getShort();
                }
                return array;
            }
            if (componentType == Short.class) {
                Short[] array = new Short[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getNullableShort();
                }
                return array;
            }
            if (componentType == Integer.TYPE) {
                int[] array = new int[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getInt();
                }
                return array;
            }
            if (componentType == Integer.class) {
                Integer[] array = new Integer[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getNullableInt();
                }
                return array;
            }
            if (componentType == Long.TYPE) {
                long[] array = new long[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getLong();
                }
                return array;
            }
            if (componentType == Long.class) {
                Long[] array = new Long[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getNullableLong();
                }
                return array;
            }
            if (componentType == Float.TYPE) {
                float[] array = new float[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getFloat();
                }
                return array;
            }
            if (componentType == Float.class) {
                Float[] array = new Float[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getNullableFloat();
                }
                return array;
            }
            if (componentType == Double.TYPE) {
                double[] array = new double[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getDouble();
                }
                return array;
            }
            if (componentType == Double.class) {
                Double[] array = new Double[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getNullableDouble();
                }
                return array;
            }
            if (componentType == Boolean.TYPE) {
                boolean[] array = new boolean[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getBoolean();
                }
                return array;
            }
            if (componentType == Boolean.class) {
                Boolean[] array = new Boolean[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getNullableBoolean();
                }
                return array;
            }
            if (componentType == String.class) {
                String[] array = new String[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getStringWithAsciiZero();
                }
                return array;
            }
            if (componentType == Date.class) {
                Date[] array = new Date[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getDate();
                }
                return array;
            }
            if (componentType == Time.class) {
                Time[] array = new Time[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getTime();
                }
                return array;
            }
            if (componentType == Timestamp.class) {
                Timestamp[] array = new Timestamp[count];
                for (int i = 0; i < count; ++i) {
                    this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                    array[i] = this.gateway_inMessage.wire.getTimestamp();
                }
                return array;
            }
            Object array = Array.newInstance(componentType, count);
            for (int i = 0; i < count; ++i) {
                Object one = this.gateway_inMessage.wire.getObjectWithAsciiZero(true);
                if (one instanceof IRISOREF) {
                    one = this.connection.registry_map_oref_to_object(((IRISOREF)one).oref);
                }
                Array.set(array, i, one);
            }
            return array;
        }
    }

    private void dynamicMapProxy(Type returnType, Object returnValue, int sequenceNumber) throws Exception {
        this.dynamicMapProxyInternal(returnType, returnValue, sequenceNumber, false, false);
    }

    private void dynamicMapProxyRecast(Type returnType, Object returnValue, int sequenceNumber) throws Exception {
        this.dynamicMapProxyInternal(returnType, returnValue, sequenceNumber, true, true);
    }

    private void dynamicMapProxyInternal(Type returnType, Object returnValue, int sequenceNumber, boolean mapReturnArrayComponent, boolean mapAsRecastOref) throws Exception {
        String oref;
        if (returnValue == null) {
            return;
        }
        Class returnClass = returnType instanceof ParameterizedType ? (Class)((ParameterizedType)returnType).getRawType() : (Class)returnType;
        if (mapReturnArrayComponent && returnClass.isArray()) {
            Class<?> componentType = returnClass.getComponentType();
            if (!JavaGateway.isDatatype(componentType)) {
                int length = Array.getLength(returnValue);
                for (int i = 0; i < length; ++i) {
                    String oref2 = this.connection.registry_NetRemoteObject_IRISObject_get_oref_from_object(Array.get(returnValue, i), componentType);
                    if (oref2 != null) continue;
                    String iris_classname = mapAsRecastOref ? componentType.getName() : "%Net.Remote.Object";
                    this.connection.registry_map_object_to_oref(this.gateway_inMessage, this.gateway_outMessage, iris_classname, Array.get(returnValue, i), componentType, sequenceNumber);
                }
            }
            return;
        }
        if (!JavaGateway.isDatatype(returnValue.getClass()) && (oref = this.connection.registry_NetRemoteObject_IRISObject_get_oref_from_object(returnValue, returnType)) == null) {
            String iris_classname = mapAsRecastOref ? returnClass.getName() : "%Net.Remote.Object";
            oref = this.connection.registry_map_object_to_oref(this.gateway_inMessage, this.gateway_outMessage, iris_classname, returnValue, returnType, sequenceNumber);
        }
    }

    private void dynamicMarshalParameters(Object[] parameters) throws Exception {
        if (parameters == null) {
            return;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] == null || !parameters[i].getClass().isArray()) continue;
            Class<?> componentType = parameters[i].getClass().getComponentType();
            if (this.connection.getProtocolVersion() < 61) {
                this.gateway_outMessage.wire.set("output");
            } else {
                this.gateway_outMessage.wire.set("out");
            }
            this.gateway_outMessage.wire.set(i + 1);
            this.dynamicMarshalArrayReturnValue(parameters[i], componentType);
        }
    }

    private void dynamicMarshalReturnValue(Type returnType, Object returnValue, boolean isRecast) throws Exception {
        if (returnValue == null) {
            this.gateway_outMessage.wire.set("value");
            this.gateway_outMessage.wire.setNull();
            return;
        }
        Class returnClass = returnType instanceof ParameterizedType ? (Class)((ParameterizedType)returnType).getRawType() : (Class)returnType;
        if (isRecast && returnClass.isArray()) {
            this.dynamicMarshalArrayReturnValue(returnValue, returnClass.getComponentType());
            return;
        }
        Class<?> returnValueClass = returnValue.getClass();
        if (JavaGateway.isDatatype(returnValueClass)) {
            this.gateway_outMessage.wire.set("value");
            if (returnValueClass == Byte.TYPE || returnValueClass == Byte.class) {
                byte[] x = new byte[]{(Byte)returnValue};
                this.gateway_outMessage.wire.set(x);
            } else if (returnValueClass == Character.TYPE || returnValueClass == Character.class) {
                this.gateway_outMessage.wire.set(((Character)returnValue).toString());
            } else if (returnValueClass == Short.TYPE || returnValueClass == Short.class) {
                this.gateway_outMessage.wire.set((Short)returnValue);
            } else if (returnValueClass == Integer.TYPE || returnValueClass == Integer.class) {
                this.gateway_outMessage.wire.set((Integer)returnValue);
            } else if (returnValueClass == Long.TYPE || returnValueClass == Long.class) {
                this.gateway_outMessage.wire.set((Long)returnValue);
            } else if (returnValueClass == Float.TYPE || returnValueClass == Float.class) {
                this.gateway_outMessage.wire.set((Float)returnValue);
            } else if (returnValueClass == Double.TYPE || returnValueClass == Double.class) {
                this.gateway_outMessage.wire.set((Double)returnValue);
            } else if (returnValueClass == Boolean.TYPE || returnValueClass == Boolean.class) {
                this.gateway_outMessage.wire.set((Boolean)returnValue);
            } else if (returnValueClass == BigDecimal.class) {
                this.gateway_outMessage.wire.set((BigDecimal)returnValue);
            } else if (returnValueClass == String.class) {
                if (((String)returnValue).length() == 0) {
                    this.gateway_outMessage.wire.set((String)null);
                } else {
                    this.gateway_outMessage.wire.set((String)returnValue);
                }
            } else if (returnValueClass == Date.class) {
                this.gateway_outMessage.wire.set((Date)returnValue);
            } else if (returnValueClass == Time.class) {
                this.gateway_outMessage.wire.set((Time)returnValue);
            } else if (returnValueClass == Timestamp.class) {
                this.gateway_outMessage.wire.set((Timestamp)returnValue);
            } else if (returnValueClass == IRISList.class) {
                IRISList list = (IRISList)returnValue;
                this.gateway_outMessage.wire.set(list.getBuffer(), list.size());
            } else {
                this.gateway_outMessage.wire.set(returnValue.toString());
            }
        } else {
            String oref = this.connection.registry_NetRemoteObject_IRISObject_get_oref_from_object(returnValue, returnType);
            this.gateway_outMessage.wire.set("object");
            this.gateway_outMessage.wire.set(oref);
        }
    }

    private void dynamicMarshalArrayReturnValue(Object returnValue, Class<?> componentType) throws Exception {
        int length = Array.getLength(returnValue);
        if (JavaGateway.isDatatype(componentType)) {
            if (componentType == Byte.TYPE || componentType == Byte.class) {
                byte[] byteArray;
                this.gateway_outMessage.wire.set("bstream");
                this.gateway_outMessage.wire.set(length);
                if (componentType == Byte.class) {
                    byteArray = new byte[length];
                    for (int i = 0; i < length; ++i) {
                        byteArray[i] = ((Byte[])returnValue)[i] != null ? ((Byte[])returnValue)[i] : (byte)0;
                    }
                } else {
                    byteArray = (byte[])returnValue;
                }
                if (length > 0) {
                    int thisLength;
                    int chunksize = 3000000;
                    for (int pointer = 0; pointer < length; pointer += thisLength) {
                        thisLength = length - pointer;
                        if (thisLength > chunksize) {
                            thisLength = chunksize;
                        }
                        this.gateway_outMessage.wire.set(byteArray, pointer, thisLength);
                    }
                }
                return;
            }
            if (componentType == Character.TYPE || componentType == Character.class) {
                char[] charArray;
                this.gateway_outMessage.wire.set("cstream");
                this.gateway_outMessage.wire.set(length);
                if (componentType == Character.class) {
                    charArray = new char[length];
                    for (int i = 0; i < length; ++i) {
                        charArray[i] = ((Character[])returnValue)[i] != null ? ((Character[])returnValue)[i].charValue() : (char)'\u0000';
                    }
                } else {
                    charArray = (char[])returnValue;
                }
                if (length > 0) {
                    int thisLength;
                    int chunksize = 3000000;
                    for (int pointer = 0; pointer < length; pointer += thisLength) {
                        thisLength = length - pointer;
                        if (thisLength > chunksize) {
                            thisLength = chunksize;
                        }
                        this.gateway_outMessage.wire.set(String.valueOf(charArray, pointer, thisLength));
                    }
                }
                return;
            }
            if (componentType == Short.TYPE || componentType == Short.class) {
                if (this.connection.getProtocolVersion() < 61) {
                    this.gateway_outMessage.wire.set("valuelist");
                } else {
                    this.gateway_outMessage.wire.set("vlist");
                }
                this.gateway_outMessage.wire.set(length);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(returnValue, i);
                    if (value != null) {
                        this.gateway_outMessage.wire.set((short)((Short)value));
                        continue;
                    }
                    this.gateway_outMessage.wire.setNull();
                }
                return;
            }
            if (componentType == Integer.TYPE || componentType == Integer.class) {
                if (this.connection.getProtocolVersion() < 61) {
                    this.gateway_outMessage.wire.set("valuelist");
                } else {
                    this.gateway_outMessage.wire.set("vlist");
                }
                this.gateway_outMessage.wire.set(length);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(returnValue, i);
                    if (value != null) {
                        this.gateway_outMessage.wire.set((int)((Integer)value));
                        continue;
                    }
                    this.gateway_outMessage.wire.setNull();
                }
                return;
            }
            if (componentType == Long.TYPE || componentType == Long.class) {
                if (this.connection.getProtocolVersion() < 61) {
                    this.gateway_outMessage.wire.set("valuelist");
                } else {
                    this.gateway_outMessage.wire.set("vlist");
                }
                this.gateway_outMessage.wire.set(length);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(returnValue, i);
                    if (value != null) {
                        this.gateway_outMessage.wire.set((long)((Long)value));
                        continue;
                    }
                    this.gateway_outMessage.wire.setNull();
                }
                return;
            }
            if (componentType == Float.TYPE || componentType == Float.class) {
                if (this.connection.getProtocolVersion() < 61) {
                    this.gateway_outMessage.wire.set("valuelist");
                } else {
                    this.gateway_outMessage.wire.set("vlist");
                }
                this.gateway_outMessage.wire.set(length);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(returnValue, i);
                    if (value != null) {
                        this.gateway_outMessage.wire.set(((Float)value).floatValue());
                        continue;
                    }
                    this.gateway_outMessage.wire.setNull();
                }
                return;
            }
            if (componentType == Double.TYPE || componentType == Double.class) {
                if (this.connection.getProtocolVersion() < 61) {
                    this.gateway_outMessage.wire.set("valuelist");
                } else {
                    this.gateway_outMessage.wire.set("vlist");
                }
                this.gateway_outMessage.wire.set(length);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(returnValue, i);
                    if (value != null) {
                        this.gateway_outMessage.wire.set((double)((Double)value));
                        continue;
                    }
                    this.gateway_outMessage.wire.setNull();
                }
                return;
            }
            if (componentType == Boolean.TYPE || componentType == Boolean.class) {
                if (this.connection.getProtocolVersion() < 61) {
                    this.gateway_outMessage.wire.set("valuelist");
                } else {
                    this.gateway_outMessage.wire.set("vlist");
                }
                this.gateway_outMessage.wire.set(length);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(returnValue, i);
                    if (value != null) {
                        this.gateway_outMessage.wire.set((boolean)((Boolean)value));
                        continue;
                    }
                    this.gateway_outMessage.wire.setNull();
                }
                return;
            }
            if (componentType == String.class) {
                if (this.connection.getProtocolVersion() < 61) {
                    this.gateway_outMessage.wire.set("valuelist");
                } else {
                    this.gateway_outMessage.wire.set("vlist");
                }
                this.gateway_outMessage.wire.set(length);
                for (int i = 0; i < length; ++i) {
                    String onevalue = (String)Array.get(returnValue, i);
                    if (onevalue.length() == 0) {
                        this.gateway_outMessage.wire.setNull();
                        continue;
                    }
                    this.gateway_outMessage.wire.set(onevalue);
                }
                return;
            }
            if (componentType == Date.class) {
                if (this.connection.getProtocolVersion() < 61) {
                    this.gateway_outMessage.wire.set("valuelist");
                } else {
                    this.gateway_outMessage.wire.set("vlist");
                }
                this.gateway_outMessage.wire.set(length);
                for (int i = 0; i < length; ++i) {
                    this.gateway_outMessage.wire.set((Date)Array.get(returnValue, i));
                }
                return;
            }
            if (componentType == Time.class) {
                if (this.connection.getProtocolVersion() < 61) {
                    this.gateway_outMessage.wire.set("valuelist");
                } else {
                    this.gateway_outMessage.wire.set("vlist");
                }
                this.gateway_outMessage.wire.set(length);
                for (int i = 0; i < length; ++i) {
                    this.gateway_outMessage.wire.set((Time)Array.get(returnValue, i));
                }
                return;
            }
            if (componentType == Timestamp.class) {
                if (this.connection.getProtocolVersion() < 61) {
                    this.gateway_outMessage.wire.set("valuelist");
                } else {
                    this.gateway_outMessage.wire.set("vlist");
                }
                this.gateway_outMessage.wire.set(length);
                for (int i = 0; i < length; ++i) {
                    this.gateway_outMessage.wire.set((Timestamp)Array.get(returnValue, i));
                }
                return;
            }
            if (componentType == IRISList.class) {
                if (this.connection.getProtocolVersion() < 61) {
                    this.gateway_outMessage.wire.set("valuelist");
                } else {
                    this.gateway_outMessage.wire.set("vlist");
                }
                this.gateway_outMessage.wire.set(length);
                for (int i = 0; i < length; ++i) {
                    IRISList list = (IRISList)Array.get(returnValue, i);
                    this.gateway_outMessage.wire.set(list.getBuffer(), list.size());
                }
                return;
            }
            if (this.connection.getProtocolVersion() < 61) {
                this.gateway_outMessage.wire.set("valuelist");
            } else {
                this.gateway_outMessage.wire.set("vlist");
            }
            this.gateway_outMessage.wire.set(length);
            for (int i = 0; i < length; ++i) {
                this.gateway_outMessage.wire.set((String)Array.get(returnValue, i));
            }
            return;
        }
        if (this.connection.getProtocolVersion() < 61) {
            this.gateway_outMessage.wire.set("objectlist");
        } else {
            this.gateway_outMessage.wire.set("olist");
        }
        this.gateway_outMessage.wire.set(length);
        for (int i = 0; i < length; ++i) {
            this.gateway_outMessage.wire.set(this.connection.registry_NetRemoteObject_IRISObject_get_oref_from_object(Array.get(returnValue, i), componentType));
        }
    }

    private static boolean isDatatype(Class<?> type) {
        return type.isPrimitive() || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == Boolean.class || type == BigDecimal.class || type == String.class || type == Date.class || type == Time.class || type == Timestamp.class || type == IRISList.class;
    }

    private Class<?> dynamicFindClass(String className) throws Exception {
        switch (className) {
            case "byte": {
                return Byte.TYPE;
            }
            case "Byte": {
                return Byte.class;
            }
            case "char": {
                return Character.TYPE;
            }
            case "Character": {
                return Character.class;
            }
            case "short": {
                return Short.TYPE;
            }
            case "Short": {
                return Short.class;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "Integer": {
                return Integer.class;
            }
            case "long": {
                return Long.TYPE;
            }
            case "Long": {
                return Long.class;
            }
            case "float": {
                return Float.TYPE;
            }
            case "Float": {
                return Float.class;
            }
            case "double": {
                return Double.TYPE;
            }
            case "Double": {
                return Double.class;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "Boolean": {
                return Boolean.class;
            }
            case "String": {
                return String.class;
            }
        }
        return Class.forName(className, true, this.getClassLoader());
    }

    private void dynamicExecuteConstructor() throws Exception, Throwable {
        int sequenceNumber = 0;
        try {
            Class<?> instanceClass;
            Object instanceObject;
            this.log(" >> DYNAMIC_EXECUTE_CONSTRUCTOR");
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            int closedProxyCount = this.gateway_inMessage.wire.getInt();
            if (closedProxyCount > 0) {
                this.updateOrefRegistry(closedProxyCount);
            }
            String oref = this.gateway_inMessage.wire.getString();
            String className = this.gateway_inMessage.wire.getString();
            int cardinality = this.gateway_inMessage.wire.getInt();
            if (className.substring(className.length() - 1).equals("]")) {
                instanceObject = this.dynamicArrayConstructor(className, cardinality);
                instanceClass = instanceObject.getClass();
            } else {
                Constructor<?> constructor = this.dynamicFindConstructor(className, cardinality, false);
                Object[] parameters = this.dynamicUnmarshalParameters(cardinality, constructor.getParameterTypes(), constructor.isVarArgs(), false);
                instanceObject = constructor.newInstance(parameters);
                instanceClass = this.loadClass(className);
            }
            this.connection.registry_NetRemoteObject_insert(oref, instanceObject, instanceClass);
            this.releaseClosedIrisObjects();
            if (this.connection.getProtocolVersion() < 61) {
                this.gateway_outMessage.wire.writeHeader(MESSAGE_DYNAMIC_EXECUTE_CONSTRUCTOR);
            } else {
                this.gateway_outMessage.wire.writeHeader(MESSAGE_DYNAMIC_EXECUTE_CONSTRUCTOR);
                this.gateway_outMessage.wire.set("end");
            }
            this.redirectOutput();
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << DYNAMIC_EXECUTE_CONSTRUCTOR");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private Object dynamicArrayConstructor(String className, int cardinality) throws Exception {
        Object newArray = null;
        int bStart = className.indexOf(91);
        if (bStart == -1) {
            throw new GatewayException("Invalid array syntax: " + className);
        }
        String componentTypeName = className.substring(0, bStart);
        Class<?> componentType = this.dynamicFindClass(componentTypeName);
        String indicesAsOneString = className.substring(bStart + 1, className.length() - 1);
        String[] indicesAsStringArray = indicesAsOneString.split("\\]\\[", -1);
        int height = indicesAsStringArray.length;
        if (cardinality > 0) {
            int i;
            for (i = 1; i < height; ++i) {
                if (indicesAsStringArray[i].length() <= 0) continue;
                throw new GatewayException("Invalid array syntax: cannot define index expressions when an array initializer is provided");
            }
            for (i = 0; i < height - 1; ++i) {
                componentType = Array.newInstance(componentType, 0).getClass();
            }
            if (indicesAsStringArray[0].equals("*") || indicesAsStringArray[0].equals("?")) {
                if (cardinality == 1 && this.gateway_inMessage.wire.getNextOREF() != null) {
                    Class<?> componentArrayType = Array.newInstance(componentType, 0).getClass();
                    return this.dynamicUnmarshalParameter(componentArrayType, true);
                }
                throw new GatewayException("Invalid array syntax: only one parameter of IRIS collection is supported");
            }
            if (indicesAsStringArray[0].length() > 0) {
                throw new GatewayException("Invalid array syntax: cannot define index expressions when an array initializer is provided");
            }
            newArray = Array.newInstance(componentType, cardinality);
            for (i = 0; i < cardinality; ++i) {
                Object value = this.dynamicUnmarshalParameter(componentType, false);
                Array.set(newArray, i, value);
            }
            return newArray;
        }
        if (indicesAsStringArray[0].length() == 0) {
            indicesAsStringArray[0] = "0";
        }
        ArrayList<Integer> dimensionArray = new ArrayList<Integer>(height);
        ArrayList componentTypeArray = new ArrayList(height);
        for (int i = 0; i < height; ++i) {
            componentTypeArray.add(null);
        }
        boolean isEmpty = false;
        for (int i = 0; i < height; ++i) {
            dimensionArray.add(this.parseInteger(indicesAsStringArray[i]));
            componentTypeArray.set(height - 1 - i, componentType);
            componentType = Array.newInstance(componentType, 0).getClass();
            if (!isEmpty) {
                if (indicesAsStringArray[i].length() != 0) continue;
                isEmpty = true;
                continue;
            }
            if (indicesAsStringArray[i].length() <= 0) continue;
            throw new GatewayException("Invalid array syntax: cannot specify an array index after an empty index");
        }
        return this.InstantiateMultidimensionalArray(0, dimensionArray, componentTypeArray);
    }

    private Integer parseInteger(String intAsString) throws GatewayException {
        if (intAsString.length() == 0) {
            return null;
        }
        if (intAsString.matches("\\d+")) {
            return Integer.parseInt(intAsString);
        }
        throw new GatewayException("Invalid array syntax: " + intAsString);
    }

    private Object InstantiateMultidimensionalArray(int index, List<Integer> dimensionArray, List<Class<?>> componentTypeArray) {
        if (index >= componentTypeArray.size() || dimensionArray.get(index) == null) {
            return null;
        }
        int size = dimensionArray.get(index);
        Object newArray = Array.newInstance(componentTypeArray.get(index), size);
        for (int i = 0; i < size; ++i) {
            Object value = this.InstantiateMultidimensionalArray(index + 1, dimensionArray, componentTypeArray);
            if (value == null) continue;
            Array.set(newArray, i, value);
        }
        return newArray;
    }

    private void dynamicExecuteMethod() throws Exception {
        int sequenceNumber = 0;
        try {
            boolean isStatic;
            String methodName;
            String className;
            this.log(" >> DYNAMIC_EXECUTE_METHOD");
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            int closedProxyCount = this.gateway_inMessage.wire.getInt();
            if (closedProxyCount > 0) {
                this.updateOrefRegistry(closedProxyCount);
            }
            if ((className = this.gateway_inMessage.wire.getString()) == null) {
                throw new GatewayException("Class name cannot be null");
            }
            if (className.equals("**Utility**")) {
                className = "com.intersystems.gateway.Utility";
            }
            if ((methodName = this.gateway_inMessage.wire.getString()) == null) {
                throw new GatewayException("Method name cannot be null");
            }
            Type instanceType = null;
            Object instanceObject = null;
            if (className.contains("@")) {
                instanceObject = this.connection.registry_NetRemoteObject_get_object_from_oref(className);
                instanceType = this.connection.registry_NetRemoteObject_get_type_from_oref(className);
                className = instanceType.getTypeName();
                isStatic = false;
            } else {
                instanceType = this.loadClass(className);
                isStatic = true;
            }
            this.log(" >> DYNAMIC_EXECUTE_METHOD: " + methodName);
            int cardinality = this.gateway_inMessage.wire.getInt();
            Type returnType = null;
            boolean isReturnTypeVoid = false;
            Object returnValue = null;
            boolean mapReturnArrayComponent = false;
            if (methodName.equals("%get") || methodName.equals("%set") || methodName.equals("%getall") || methodName.equals("%setall")) {
                if (!instanceObject.getClass().isArray()) {
                    throw new GatewayException("Object is not an array");
                }
                switch (methodName) {
                    case "%get": {
                        if (cardinality != 1) {
                            throw new GatewayException("Method not found: " + className + "." + methodName + "(" + cardinality + ")");
                        }
                        int index = this.gateway_inMessage.wire.getInt();
                        returnValue = Array.get(instanceObject, index);
                        returnType = instanceObject.getClass().getComponentType();
                        isReturnTypeVoid = false;
                        break;
                    }
                    case "%set": {
                        if (cardinality != 2) {
                            throw new GatewayException("Method not found: " + className + "." + methodName + "(" + cardinality + ")");
                        }
                        int index = this.gateway_inMessage.wire.getInt();
                        Class<?> componentType = instanceObject.getClass().getComponentType();
                        Object value = this.dynamicUnmarshalParameter(componentType, false);
                        returnValue = Array.get(instanceObject, index);
                        returnType = componentType;
                        isReturnTypeVoid = false;
                        Array.set(instanceObject, index, value);
                        break;
                    }
                    case "%getall": {
                        if (cardinality != 0) {
                            throw new GatewayException("Method not found: " + className + "." + methodName + "(" + cardinality + ")");
                        }
                        returnValue = instanceObject;
                        returnType = instanceObject.getClass();
                        isReturnTypeVoid = false;
                        mapReturnArrayComponent = true;
                        break;
                    }
                    case "%setall": {
                        if (cardinality != 1) {
                            throw new GatewayException("Method not found: " + className + "." + methodName + "(" + cardinality + ")");
                        }
                        this.connection.closeUnusedIrisObject(this.gateway_inMessage.wire);
                        String oref = this.gateway_inMessage.wire.getString();
                        Class<?> componentType = instanceObject.getClass().getComponentType();
                        Object array = this.dynamicUnmarshalParameterFetchRecastData(oref, componentType);
                        for (int i = 0; i < Array.getLength(array) && i < Array.getLength(instanceObject); ++i) {
                            Array.set(instanceObject, i, Array.get(array, i));
                        }
                        isReturnTypeVoid = true;
                        break;
                    }
                    default: {
                        throw new GatewayException("Method not found: " + className + "." + methodName + "(" + cardinality + ")");
                    }
                }
            } else {
                Method method = this.dynamicFindMethod(instanceType, methodName, cardinality, false);
                if (method == null) {
                    throw new GatewayException("Method not found: " + className + "." + methodName + "(" + cardinality + ")");
                }
                if (isStatic && !Modifier.isStatic(method.getModifiers())) {
                    throw new GatewayException("Cannot invoke instance method as static method: " + className + "." + methodName + "(" + cardinality + ")");
                }
                Object[] parameters = this.dynamicUnmarshalParameters(cardinality, method.getParameterTypes(), method.isVarArgs(), false);
                returnType = this.dynamicResolveGenericType(method.getGenericReturnType(), instanceType, method.getReturnType());
                returnValue = method.invoke(instanceObject, parameters);
                isReturnTypeVoid = returnType.getTypeName().equals("void");
            }
            this.releaseClosedIrisObjects();
            if (isReturnTypeVoid) {
                if (this.connection.getProtocolVersion() < 61) {
                    this.gateway_outMessage.wire.writeHeader(MESSAGE_DYNAMIC_EXECUTE_METHOD);
                    this.gateway_outMessage.wire.setUndefined();
                } else {
                    this.gateway_outMessage.wire.writeHeader(MESSAGE_DYNAMIC_EXECUTE_METHOD);
                    this.gateway_outMessage.wire.set("end");
                }
            } else if (this.connection.getProtocolVersion() < 61) {
                this.dynamicMapProxy(returnType, returnValue, sequenceNumber);
                this.gateway_outMessage.wire.writeHeader(MESSAGE_DYNAMIC_EXECUTE_METHOD);
                this.dynamicMarshalReturnValue(returnType, returnValue, false);
            } else {
                this.dynamicMapProxyInternal(returnType, returnValue, sequenceNumber, mapReturnArrayComponent, false);
                this.gateway_outMessage.wire.writeHeader(MESSAGE_DYNAMIC_EXECUTE_METHOD);
                this.dynamicMarshalReturnValue(returnType, returnValue, mapReturnArrayComponent);
                this.gateway_outMessage.wire.set("end");
            }
            this.redirectOutput();
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << DYNAMIC_EXECUTE_METHOD");
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException && e.getTargetException().getCause() instanceof IRISRemoteException) {
                this.processException(e.getTargetException().getCause(), sequenceNumber);
            } else {
                this.processException(e.getTargetException(), sequenceNumber);
            }
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private Type dynamicResolveGenericType(Type genericType, Type runtimeType, Class<?> defaultClass) {
        if (genericType instanceof TypeVariable) {
            if (runtimeType instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)runtimeType).getActualTypeArguments();
                TypeVariable<Class<T>>[] typeParameters = ((Class)((ParameterizedType)runtimeType).getRawType()).getTypeParameters();
                for (int i = 0; i < typeParameters.length; ++i) {
                    if (typeParameters[i] != genericType) continue;
                    if (typeArguments[i] instanceof WildcardType) {
                        return defaultClass;
                    }
                    if (typeArguments[i] instanceof TypeVariable) {
                        return defaultClass;
                    }
                    return typeArguments[i];
                }
            }
            return defaultClass;
        }
        return genericType;
    }

    private void dynamicExecuteGet() throws Exception {
        int sequenceNumber = 0;
        try {
            String className;
            this.log(" >> DYNAMIC_EXECUTE_GET");
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            int closedProxyCount = this.gateway_inMessage.wire.getInt();
            if (closedProxyCount > 0) {
                this.updateOrefRegistry(closedProxyCount);
            }
            if ((className = this.gateway_inMessage.wire.getString()) == null) {
                throw new GatewayException("Class name cannot be null");
            }
            String propertyName = this.gateway_inMessage.wire.getString();
            if (propertyName == null) {
                throw new GatewayException("Property name cannot be null");
            }
            Type instanceType = null;
            Object instanceObject = null;
            if (className.contains("@")) {
                instanceObject = this.connection.registry_NetRemoteObject_get_object_from_oref(className);
                instanceType = this.connection.registry_NetRemoteObject_get_type_from_oref(className);
                className = instanceType.getTypeName();
            } else {
                instanceType = this.loadClass(className);
            }
            Object returnType = null;
            Object returnValue = null;
            if (instanceObject != null && instanceObject.getClass().isArray() && propertyName.equals("length")) {
                returnType = Integer.class;
                returnValue = Array.getLength(instanceObject);
            } else {
                Field field = this.dynamicFindField(instanceType, propertyName);
                if (field == null) {
                    throw new GatewayException("Field not found: " + className + "." + propertyName);
                }
                returnType = this.dynamicResolveGenericType(field.getGenericType(), instanceType, field.getType());
                returnValue = field.get(instanceObject);
            }
            this.releaseClosedIrisObjects();
            this.dynamicMapProxy((Type)returnType, returnValue, sequenceNumber);
            this.gateway_outMessage.wire.writeHeader(MESSAGE_DYNAMIC_EXECUTE_GET);
            this.dynamicMarshalReturnValue((Type)returnType, returnValue, false);
            this.redirectOutput();
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << DYNAMIC_EXECUTE_GET");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private void dynamicExecuteSet() throws Exception {
        int sequenceNumber = 0;
        try {
            String className;
            this.log(" >> DYNAMIC_EXECUTE_SET");
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            int closedProxyCount = this.gateway_inMessage.wire.getInt();
            if (closedProxyCount > 0) {
                this.updateOrefRegistry(closedProxyCount);
            }
            if ((className = this.gateway_inMessage.wire.getString()) == null) {
                throw new GatewayException("Class name cannot be null");
            }
            String propertyName = this.gateway_inMessage.wire.getString();
            if (propertyName == null) {
                throw new GatewayException("Property name cannot be null");
            }
            Type instanceType = null;
            Object instanceObject = null;
            if (className.contains("@")) {
                instanceObject = this.connection.registry_NetRemoteObject_get_object_from_oref(className);
                instanceType = this.connection.registry_NetRemoteObject_get_type_from_oref(className);
                className = instanceType.getTypeName();
            } else {
                instanceType = this.loadClass(className);
            }
            Field field = this.dynamicFindField(instanceType, propertyName);
            if (field == null) {
                throw new GatewayException("Field not found: " + className + "." + propertyName);
            }
            Object value = this.dynamicUnmarshalParameter(field.getType(), false);
            field.set(instanceObject, value);
            this.releaseClosedIrisObjects();
            this.gateway_outMessage.wire.writeHeader(MESSAGE_DYNAMIC_EXECUTE_SET);
            this.redirectOutput();
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << DYNAMIC_EXECUTE_SET");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private void releaseClosedIrisObjects() {
        if (this.connection.registry_closed_IRISObject.size() > IRISConnection.CLOSED_PROXY_UPDATE_THRESHOLD) {
            IRIS iris = GatewayContext.getIRIS();
            iris.releaseClosedIrisObjects();
        }
    }

    private void recastExecuteConstructor() throws Exception, Throwable {
        int sequenceNumber = 0;
        try {
            this.log(" >> RECAST_EXECUTE_CONSTRUCTOR");
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            int closedProxyCount = this.gateway_inMessage.wire.getInt();
            if (closedProxyCount > 0) {
                this.updateOrefRegistry(closedProxyCount);
            }
            String oref = this.gateway_inMessage.wire.getString();
            String className = this.gateway_inMessage.wire.getString();
            int cardinality = this.gateway_inMessage.wire.getInt();
            Constructor<?> constructor = this.dynamicFindConstructor(className, cardinality, true);
            Object[] parameters = this.dynamicUnmarshalParameters(cardinality, constructor.getParameterTypes(), constructor.isVarArgs(), true);
            Object instanceObject = constructor.newInstance(parameters);
            Class<?> instanceClass = this.loadClass(className);
            this.connection.registry_NetRemoteObject_insert(oref, instanceObject, instanceClass);
            this.releaseClosedIrisObjects();
            this.gateway_outMessage.wire.writeHeader(MESSAGE_RECAST_EXECUTE_CONSTRUCTOR);
            this.dynamicMarshalParameters(parameters);
            if (this.connection.getProtocolVersion() < 61) {
                this.gateway_outMessage.wire.set("endofdata");
            } else {
                this.gateway_outMessage.wire.set("end");
            }
            this.redirectOutput();
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << RECAST_EXECUTE_CONSTRUCTOR");
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    private void recastExecuteMethod() throws Exception {
        int sequenceNumber = 0;
        try {
            boolean isStatic;
            String className;
            this.log(" >> RECAST_EXECUTE_METHOD");
            sequenceNumber = this.gateway_inMessage.wire.getHeaderCount();
            int closedProxyCount = this.gateway_inMessage.wire.getInt();
            if (closedProxyCount > 0) {
                this.updateOrefRegistry(closedProxyCount);
            }
            if ((className = this.gateway_inMessage.wire.getString()) == null) {
                throw new GatewayException("Class name cannot be null");
            }
            String methodName = this.gateway_inMessage.wire.getString();
            if (methodName == null) {
                throw new GatewayException("Method name cannot be null");
            }
            Type instanceType = null;
            Object instanceObject = null;
            if (className.contains("@")) {
                instanceObject = this.connection.registry_NetRemoteObject_get_object_from_oref(className);
                instanceType = this.connection.registry_NetRemoteObject_get_type_from_oref(className);
                className = instanceType.getTypeName();
                isStatic = false;
            } else {
                instanceType = this.loadClass(className);
                isStatic = true;
            }
            this.log(" >> RECAST_EXECUTE_METHOD: " + methodName);
            int cardinality = this.gateway_inMessage.wire.getInt();
            Type returnType = null;
            boolean isReturnTypeVoid = false;
            Object returnValue = null;
            Object[] parameters = null;
            Method method = this.dynamicFindMethod(instanceType, methodName, cardinality, true);
            if (method != null) {
                if (isStatic && !Modifier.isStatic(method.getModifiers())) {
                    throw new GatewayException("Cannot invoke instance method as static method: " + className + "." + methodName + "(" + cardinality + ")");
                }
                parameters = this.dynamicUnmarshalParameters(cardinality, method.getParameterTypes(), method.isVarArgs(), true);
                returnValue = method.invoke(instanceObject, parameters);
                returnType = this.dynamicResolveGenericType(method.getGenericReturnType(), instanceType, method.getReturnType());
                isReturnTypeVoid = returnType.getTypeName().equals("void");
            } else if (methodName.substring(0, 3).equals("get") && cardinality == 0) {
                String propertyName = methodName.substring(3);
                Field field = this.dynamicFindField(instanceType, propertyName);
                if (field == null) {
                    throw new GatewayException("Method not found: " + className + "." + methodName + "(" + cardinality + ")");
                }
                returnValue = field.get(instanceObject);
                returnType = this.dynamicResolveGenericType(field.getGenericType(), instanceType, field.getType());
                isReturnTypeVoid = false;
            } else if (methodName.substring(0, 3).equals("set") && cardinality == 1) {
                String propertyName = methodName.substring(3);
                Field field = this.dynamicFindField(instanceType, propertyName);
                if (field == null) {
                    throw new GatewayException("Method not found: " + className + "." + methodName + "(" + cardinality + ")");
                }
                Object value = this.dynamicUnmarshalParameter(field.getType(), true);
                field.set(instanceObject, value);
                returnType = this.dynamicResolveGenericType(field.getGenericType(), instanceType, field.getType());
                isReturnTypeVoid = true;
            } else {
                throw new GatewayException("Method not found: " + className + "." + methodName + "(" + cardinality + ")");
            }
            this.releaseClosedIrisObjects();
            if (isReturnTypeVoid) {
                this.gateway_outMessage.wire.writeHeader(MESSAGE_RECAST_EXECUTE_METHOD);
                this.dynamicMarshalParameters(parameters);
            } else {
                this.dynamicMapProxyRecast(returnType, returnValue, sequenceNumber);
                this.gateway_outMessage.wire.writeHeader(MESSAGE_RECAST_EXECUTE_METHOD);
                this.dynamicMarshalParameters(parameters);
                this.dynamicMarshalReturnValue(returnType, returnValue, true);
            }
            if (this.connection.getProtocolVersion() < 61) {
                this.gateway_outMessage.wire.set("endofdata");
            } else {
                this.gateway_outMessage.wire.set("end");
            }
            this.redirectOutput();
            this.outMessage_sequenceNumber = sequenceNumber;
            this.log(" << RECAST_EXECUTE_METHOD");
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException && e.getTargetException().getCause() instanceof IRISRemoteException) {
                this.processException(e.getTargetException().getCause(), sequenceNumber);
            } else {
                this.processException(e.getTargetException(), sequenceNumber);
            }
        }
        catch (Throwable e) {
            this.processException(e, sequenceNumber);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    static {
        activeThreadStatus = new ConcurrentHashMap();
        activeThreadObject = new HashMap<Long, JavaGateway>();
        terminate_listener = false;
        update_thread_map = false;
    }
}

