/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.gateway;

import com.intersystems.gateway.ClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TypeMap {
    private static Map<String, String> types;
    private static Map<String, String> javaTypes;
    private static Map<String, Class<?>> javaClasses;
    private static List<String> exclusions;

    TypeMap() {
    }

    protected static Map<String, String> getIRISTypes() {
        return types;
    }

    protected static String getJavaType(String cosType) {
        String type;
        if (cosType.startsWith("%Library.")) {
            cosType = cosType.replace("%Library.", "%");
        }
        if ((type = javaTypes.get(cosType)) == null) {
            return cosType;
        }
        return type;
    }

    protected static Class<?> getJavaClass(String cosType, ClassLoader classLoader) throws Exception {
        if (cosType.startsWith("%Library.")) {
            cosType = cosType.replace("%Library.", "%");
        }
        if (cosType.equals("%GlobalBinaryStream")) {
            return Class.forName("[B", true, classLoader);
        }
        if (cosType.equals("%GlobalCharacterStream")) {
            return Class.forName("[C", true, classLoader);
        }
        if (cosType.equals("%Collection.AbstractList:%String")) {
            return Class.forName("[Ljava.lang.String;", true, classLoader);
        }
        if (cosType.equals("%Collection.AbstractList:%Integer")) {
            return Class.forName("[Ljava.lang.Integer;", true, classLoader);
        }
        if (cosType.equals("%Collection.AbstractList:%Float")) {
            return Class.forName("[Ljava.lang.Float;", true, classLoader);
        }
        return javaClasses.get(cosType);
    }

    protected static boolean isJavaDataType(String type) {
        return type.equals("java.lang.String") || type.equals("int") || type.equals("java.lang.Integer") || type.equals("float") || type.equals("java.lang.Float") || type.equals("double") || type.equals("java.lang.Double") || type.equals("short") || type.equals("java.lang.Short") || type.equals("long") || type.equals("java.lang.Long") || type.equals("char") || type.equals("byte") || type.equals("boolean") || type.equals("java.lang.Boolean") || type.equals("java.sql.Date") || type.equals("java.sql.Time") || type.equals("java.sql.Timestamp");
    }

    protected static List<String> getInitialExclusions() {
        return new ArrayList<String>(exclusions);
    }

    protected static String getIRISPropertyName(String javaPropertyName) {
        return javaPropertyName.replaceAll("_", "u").replace('$', 'd');
    }

    protected static String getIRISClassName(String javaClassName) throws Exception {
        return javaClassName.replaceAll("_", "u").replace('$', '.');
    }

    static {
        exclusions = new ArrayList<String>();
        exclusions.add("org.apache.poi.util");
        exclusions.add("org.apache.xalan.extensions.ExtensionHandlerGeneral");
        exclusions.add("sun");
        exclusions.add("com.sun.jms");
        exclusions.add("com.sun.security");
        exclusions.add("com.sun.corba");
        exclusions.add("com.sun.enterprise");
        exclusions.add("com.sun.ejb");
        exclusions.add("com.sun.jts");
        exclusions.add("COM.rsa");
        types = new HashMap<String, String>();
        types.put("void", "\"\"");
        types.put("boolean", "%Boolean");
        types.put("int", "%Integer");
        types.put("short", "%SmallInt");
        types.put("long", "%Integer");
        types.put("float", "%Double");
        types.put("double", "%Double");
        types.put("byte", "%Integer");
        types.put("char", "%String");
        types.put("java.lang.Boolean", "%Boolean");
        types.put("java.lang.Integer", "%Integer");
        types.put("java.lang.Short", "%SmallInt");
        types.put("java.lang.Long", "%Integer");
        types.put("java.lang.Float", "%Double");
        types.put("java.lang.Double", "%Double");
        types.put("java.lang.String", "%String");
        types.put("java.sql.Date", "%Date");
        types.put("java.sql.Time", "%Time");
        types.put("java.sql.Timestamp", "%TimeStamp");
        types.put("[Ljava.lang.String;", "%ListOfDataTypes");
        types.put("[Ljava.lang.Double;", "%ListOfDataTypes");
        types.put("[Ljava.sql.Time;", "%ListOfDataTypes");
        types.put("[Ljava.sql.Timestamp;", "%ListOfDataTypes");
        types.put("[Ljava.sql.Date;", "%ListOfDataTypes");
        types.put("[Z", "%ListOfDataTypes");
        types.put("[S", "%ListOfDataTypes");
        types.put("[I", "%ListOfDataTypes");
        types.put("[J", "%ListOfDataTypes");
        types.put("[F", "%ListOfDataTypes");
        types.put("[D", "%ListOfDataTypes");
        types.put("[B", "%GlobalBinaryStream");
        types.put("[C", "%GlobalCharacterStream");
        javaTypes = new HashMap<String, String>();
        javaTypes.put("%String", "java.lang.String");
        javaTypes.put("%Integer", "int");
        javaTypes.put("%Double", "double");
        javaTypes.put("%SmallInt", "short");
        javaTypes.put("%Date", "java.sql.Date");
        javaTypes.put("%Time", "java.sql.Time");
        javaTypes.put("%TimeStamp", "java.sql.Timestamp");
        javaClasses = new HashMap();
        javaClasses.put("%String", String.class);
        javaClasses.put("%Integer", Integer.TYPE);
        javaTypes.put("%Double", "Double.TYPE");
        javaTypes.put("%SmallInt", "Short.TYPE");
        javaTypes.put("%Date", "java.sql.Date.class");
        javaTypes.put("%Time", "java.sql.Time.class");
        javaTypes.put("%TimeStamp", "java.sql.Timestamp.class");
        javaTypes.put("%GlobalBinaryStream", "[B");
        javaTypes.put("%GlobalCharacterStream", "[C");
    }
}

