/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.gateway;

import com.intersystems.gateway.GatewayContext;
import com.intersystems.gateway.JavaGateway;
import com.intersystems.jdbc.IRIS;
import com.intersystems.jdbc.IRISConnection;
import java.lang.reflect.Method;

public class Utility {
    public static String getLanguageName() {
        return "Java";
    }

    public static String getLanguageVersion() {
        return System.getProperty("java.version");
    }

    public static String getProductVersion() {
        return IRIS.getProductVersion();
    }

    public static void writeOutput(String data) throws Exception {
        IRISConnection connection = GatewayContext.getConnection();
        Method method = connection.outputRedirectHandler;
        if (method == null) {
            System.out.print(data);
        } else {
            Object[] arguments = new Object[]{data};
            method.invoke(null, arguments);
        }
    }

    public static int getGatewayThreadCount() {
        int count = 0;
        for (Long key : JavaGateway.activeThreadStatus.keySet()) {
            if (!JavaGateway.activeThreadStatus.get(key).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public static String dumpProxyMaps() throws Exception {
        IRISConnection connection = GatewayContext.getConnection();
        return connection.dump_proxy_maps();
    }

    public static boolean flushClosedIRISObjects() throws Exception {
        IRIS iris = GatewayContext.getIRIS();
        iris.releaseClosedIrisObjects(true);
        return true;
    }

    public static boolean castAs(Object instance, String classname, String neworef) throws Exception {
        IRISConnection connection = GatewayContext.getConnection();
        JavaGateway gateway = connection.getGateway();
        Class<?> clazz = gateway.loadClass(classname);
        connection.registry_NetRemoteObject_insert(neworef, instance, clazz);
        return true;
    }
}

