/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.SQLValidationException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListMap;

public final class BatchUpdateStatus
extends BatchUpdateException {
    private static final long serialVersionUID = 4282857442048743072L;
    int[] updateCount = null;
    private volatile SQLException currentException = null;
    private ConcurrentSkipListMap<Integer, SQLException> rowErrors = new ConcurrentSkipListMap();
    private Iterator<SQLException> iterator = null;
    private Integer[] arrayOfErroredRows = null;

    BatchUpdateStatus(int rowSets, int fill) {
        this.updateCount = new int[rowSets];
        if (fill != 0) {
            Arrays.fill(this.updateCount, fill);
        }
    }

    void setException(SQLException sqlEx, boolean atEnd, int rowNumber) throws BatchUpdateException {
        SQLException existsEx;
        this.updateCount[rowNumber] = -3;
        if (sqlEx instanceof SQLValidationException) {
            ((SQLValidationException)sqlEx).setRowNumber(rowNumber);
        }
        if ((existsEx = this.rowErrors.get(rowNumber)) == null) {
            this.rowErrors.put(rowNumber, sqlEx);
        } else {
            existsEx.setNextException(sqlEx);
        }
        if (atEnd) {
            Arrays.fill(this.updateCount, -3);
            throw this;
        }
    }

    void setException(SQLException sqlEx, boolean atEnd) throws BatchUpdateException {
        this.updateCount[0] = -3;
        this.rowErrors.put(0, sqlEx);
        if (atEnd) {
            Arrays.fill(this.updateCount, -3);
            throw this;
        }
    }

    void setServerUpdateCount(int row, int value) throws SQLException {
        if (value == -3) {
            this.setException(new SQLValidationException("Server Exception!"), false, row);
        } else {
            this.updateCount[row] = value;
        }
    }

    public Integer[] getRowErrors() {
        if (this.arrayOfErroredRows == null) {
            this.arrayOfErroredRows = this.rowErrors.keySet().toArray(new Integer[0]);
        }
        return this.arrayOfErroredRows;
    }

    public Collection<SQLException> getAllExceptions() {
        return this.rowErrors.values();
    }

    @Override
    public SQLException getNextException() {
        try {
            if (this.iterator == null) {
                this.iterator = this.rowErrors.values().iterator();
            }
            this.currentException = this.iterator.next();
            return this;
        }
        catch (Exception ex) {
            this.iterator = null;
            this.currentException = null;
            return null;
        }
    }

    @Override
    public int[] getUpdateCounts() {
        return this.updateCount;
    }

    public boolean hadException() {
        return this.getErrors() > 0;
    }

    public boolean rowErrored(int row) {
        return this.rowErrors.containsKey(row);
    }

    SQLException CurrentException() {
        if (this.currentException == null) {
            if (this.iterator == null) {
                if (this.rowErrors == null) {
                    this.currentException = null;
                    return this.currentException;
                }
                this.iterator = this.rowErrors.values().iterator();
            }
            this.currentException = this.iterator.next();
        }
        return this.currentException;
    }

    public int getErrors() {
        return this.rowErrors.size();
    }

    @Override
    public Iterator<Throwable> iterator() {
        this.iterator = this.rowErrors.values().iterator();
        this.currentException = null;
        return new Iterator<Throwable>(){

            @Override
            public boolean hasNext() {
                return BatchUpdateStatus.this.iterator.hasNext();
            }

            @Override
            public Throwable next() {
                SQLException throwable = BatchUpdateStatus.this.getNextException();
                if (throwable == null) {
                    throw new NoSuchElementException();
                }
                return throwable;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String getMessage() {
        if (this.CurrentException() == null) {
            return null;
        }
        return this.currentException.getMessage();
    }

    @Override
    public String getSQLState() {
        if (this.CurrentException() == null) {
            return null;
        }
        return this.currentException.getSQLState();
    }

    @Override
    public int getErrorCode() {
        if (this.CurrentException() == null) {
            return 0;
        }
        return this.currentException.getErrorCode();
    }

    void throwException(SQLException sqlEx) throws BatchUpdateException {
        if (this.rowErrors.size() == 0) {
            this.rowErrors.put(0, sqlEx);
            this.CurrentException();
        }
        throw this;
    }

    void throwException(String string) throws BatchUpdateException {
        if (this.rowErrors.size() == 0) {
            SQLException ex = new SQLException(string);
            this.rowErrors.put(0, ex);
            this.CurrentException();
        }
        throw this;
    }
}

