/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

import com.intersystems.jdbc.BufferUtils;
import com.intersystems.jdbc.DBList;
import com.intersystems.jdbc.ListItem;
import com.intersystems.jdbc.ListReader;
import com.intersystems.jdbc.MessageHeader;
import java.sql.SQLException;

public class BufferRO
extends ListReader {
    MessageHeader Header;
    int maxFieldSize;
    boolean NewRow;

    BufferRO(BufferRO listBuffer, MessageHeader inHeader, String inLocale, boolean fd) {
        this.m_locale = inLocale;
        this.Header = inHeader;
        if (fd && listBuffer != null && !listBuffer.NewRow) {
            int carryOver = listBuffer.m_item.listBufferEnd - listBuffer.m_item.nextOffset;
            this.m_item = new ListItem(new byte[inHeader.getMessageLength() + carryOver]);
            BufferUtils.copyByteArray(listBuffer.m_item.buffer, listBuffer.m_item.nextOffset, this.m_item.buffer, 0, carryOver);
            this.m_item.listBufferEnd = carryOver;
            this.setOffset(this.m_item.listBufferEnd);
            return;
        }
        int headerMsgLength = inHeader.getMessageLength();
        this.m_item = new ListItem(new byte[headerMsgLength < 0 ? 0 : headerMsgLength]);
        this.m_item.listBufferEnd = 0;
        this.setOffset(0);
    }

    BufferRO(BufferRO listBuffer, BufferRO newListBuffer) {
        this.m_locale = newListBuffer.m_locale;
        this.Header = newListBuffer.Header;
        int carryOver = listBuffer.m_item.listBufferEnd - listBuffer.m_item.nextOffset;
        int newSize = newListBuffer.Header.getMessageLength() + carryOver;
        this.m_item = new ListItem(new byte[newSize]);
        BufferUtils.copyByteArray(listBuffer.m_item.buffer, listBuffer.m_item.nextOffset, this.m_item.buffer, 0, carryOver);
        BufferUtils.copyByteArray(newListBuffer.m_item.buffer, newListBuffer.m_item.nextOffset, this.m_item.buffer, carryOver, newSize - carryOver);
        this.setOffset(carryOver);
        this.m_item.listBufferEnd = newSize;
    }

    BufferRO(BufferRO listBuffer, int numItems) {
        this.m_locale = listBuffer.m_locale;
        this.Header = listBuffer.Header;
        ListItem li = listBuffer.m_item.clone();
        int startingOffset = listBuffer.getOffset();
        for (int i = 0; i < numItems; ++i) {
            DBList.getListElement(li.nextOffset, li);
        }
        int newSize = li.nextOffset - startingOffset;
        this.m_item = new ListItem(new byte[newSize]);
        BufferUtils.copyByteArray(listBuffer.m_item.buffer, listBuffer.m_item.nextOffset, this.m_item.buffer, 0, newSize);
        this.m_item.listBufferEnd = newSize;
    }

    void setBuffer(MessageHeader inHeader) {
        this.m_item.buffer = new byte[inHeader.getMessageLength()];
        this.Header = inHeader;
        this.clearList();
    }

    void growBuffer(MessageHeader inHeader) {
        this.m_item.buffer = BufferUtils.growByteArray(this.m_item.buffer, 0, inHeader.getMessageLength());
        this.Header = inHeader;
    }

    public int getID() {
        return this.Header.getStatementID();
    }

    public int getHeaderCount() {
        return this.Header.getCount();
    }

    byte[] getRawByteArray(int len) {
        byte[] ba = BufferUtils.copyByteArray(this.m_item.buffer, this.m_item.nextOffset, len);
        this.m_item.nextOffset += len;
        return ba;
    }

    int getRaw2ByteInt(int offset) {
        int temp = BufferUtils.get2ByteIntRaw(this.m_item.buffer, offset);
        this.m_item.nextOffset = offset + 2;
        return temp;
    }

    int getRaw2ByteInt() {
        int temp = BufferUtils.get2ByteIntRaw(this.m_item.buffer, this.m_item.nextOffset);
        this.m_item.nextOffset += 2;
        return temp;
    }

    int getRaw4ByteInt(int offset) {
        int temp = BufferUtils.get4ByteIntRaw(this.m_item.buffer, offset);
        this.m_item.nextOffset = offset + 4;
        return temp;
    }

    int getRaw4ByteInt() {
        int temp = BufferUtils.get4ByteIntRaw(this.m_item.buffer, this.m_item.nextOffset);
        this.m_item.nextOffset += 4;
        return temp;
    }

    boolean isUndefined() {
        return this.m_item.type == -1;
    }

    void nextUnlessUndefined() throws SQLException {
        this.next();
        if (this.isPastLastItem()) {
            throw new NoMoreDataException();
        }
        if (this.isUndefined()) {
            throw new SQLException("Output/Default parameter not assigned a value.", "S1000");
        }
    }

    ListReader getOutputParameterList(int begin, boolean addNull) {
        int len = this.m_item.nextOffset - begin;
        int offset = addNull ? 3 : 0;
        byte[] ba = new byte[len + offset];
        if (addNull) {
            byte[] quoteQuote = new byte[]{3, 1, 0};
            BufferUtils.copyByteArray(quoteQuote, 0, ba, 0, 3);
        }
        BufferUtils.copyByteArray(this.m_item.buffer, begin, ba, offset, len);
        return new ListReader(new ListItem(ba, len + offset), this.m_locale);
    }

    int ByteArrayItemLength(int offset) {
        ListItem li = this.m_item.clone();
        DBList.getListElement(offset, li);
        if (li.dataLength == 1 & li.buffer[li.dataOffset] == 0) {
            return 0;
        }
        return li.dataLength;
    }

    public Object GetParameter(String type) throws SQLException {
        Object temp = null;
        switch (type) {
            case "String": {
                temp = this.getString();
                break;
            }
            case "Int": {
                temp = this.getInt();
                break;
            }
            case "Long": {
                temp = this.getLong();
                break;
            }
            case "Short": {
                temp = this.getShort();
                break;
            }
            case "Double": {
                temp = this.getDouble();
                break;
            }
            case "Float": {
                temp = Float.valueOf(this.getFloat());
                break;
            }
            case "Boolean": {
                temp = this.getBoolean();
                break;
            }
            default: {
                return null;
            }
        }
        if (this.isNull()) {
            return null;
        }
        return temp;
    }

    static class NoMoreDataException
    extends SQLException {
        NoMoreDataException() {
            super("Invalid column number", "S1002");
        }
    }
}

