/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbc;

public class BufferUtils {
    public static int get2ByteIntRaw(byte[] data, int iOffset) {
        return data[iOffset] & 0xFF | (data[iOffset + 1] & 0xFF) << 8;
    }

    public static int get4ByteIntRaw(byte[] data, int iOffset) {
        return data[iOffset] & 0xFF | (data[iOffset + 1] & 0xFF) << 8 | (data[iOffset + 2] & 0xFF) << 16 | (data[iOffset + 3] & 0xFF) << 24;
    }

    public static void set2ByteIntRaw(byte[] data, int iOffset, short value) {
        data[iOffset] = (byte)value;
        data[iOffset + 1] = (byte)(value >> 8);
    }

    public static void setRaw4ByteInt(byte[] data, int iOffset, int value) {
        data[iOffset] = (byte)value;
        data[iOffset + 1] = (byte)(value >> 8);
        data[iOffset + 2] = (byte)(value >> 16);
        data[iOffset + 3] = (byte)(value >> 24);
    }

    public static byte[] copyByteArray(byte[] byteArray) {
        return (byte[])byteArray.clone();
    }

    public static byte[] copyByteArray(byte[] byteArray, int offset, int length) {
        byte[] b = new byte[length];
        System.arraycopy(byteArray, offset, b, 0, length);
        return b;
    }

    public static void copyByteArray(byte[] src, int srcOffset, byte[] dst, int dstOffset, int length) {
        System.arraycopy(src, srcOffset, dst, dstOffset, length);
    }

    static byte[] growByteArray(byte[] byteArray, int offset, int addLength) {
        byte[] b;
        if (byteArray != null) {
            b = new byte[byteArray.length + addLength];
            System.arraycopy(byteArray, offset, b, 0, byteArray.length);
        } else {
            b = new byte[addLength];
        }
        return b;
    }
}

